/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.trovit.TrovitDocument;
import org.openestate.io.trovit.TrovitUtils;
import org.openestate.io.trovit.xml.AdType;
import org.openestate.io.trovit.xml.Trovit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TrovitReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrovitReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)TrovitReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                TrovitReadingExample.read(TrovitReadingExample.class.getResourceAsStream("/org/openestate/io/examples/trovit.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    TrovitReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        TrovitDocument trovitDocument = TrovitUtils.createDocument((File)file);
        if (trovitDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            TrovitReadingExample.printToConsole(trovitDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        TrovitDocument trovitDocument = TrovitUtils.createDocument((InputStream)inputStream);
        if (trovitDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            TrovitReadingExample.printToConsole(trovitDocument);
        }
    }

    protected static void printToConsole(TrovitDocument trovitDocument) throws JAXBException {
        Trovit trovit = trovitDocument.toObject();
        for (AdType adType : trovit.getAd()) {
            String string;
            String string2 = StringUtils.trimToNull((String)adType.getId());
            if (string2 == null) {
                string2 = "???";
            }
            if ((string = StringUtils.trimToNull((String)adType.getTitle())) == null) {
                string = "???";
            }
            LOGGER.info("> found object '" + string2 + "' with title '" + string + "'");
        }
    }
}

