/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.examples.utils.RandomStringUtils;
import org.openestate.io.trovit.TrovitDocument;
import org.openestate.io.trovit.TrovitUtils;
import org.openestate.io.trovit.xml.AdType;
import org.openestate.io.trovit.xml.ObjectFactory;
import org.openestate.io.trovit.xml.PictureType;
import org.openestate.io.trovit.xml.Trovit;
import org.openestate.io.trovit.xml.types.AreaUnitValue;
import org.openestate.io.trovit.xml.types.ForeclosureTypeValue;
import org.openestate.io.trovit.xml.types.OrientationValue;
import org.openestate.io.trovit.xml.types.PricePeriodValue;
import org.openestate.io.trovit.xml.types.TypeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrovitWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrovitWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = TrovitUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)TrovitWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Trovit trovit = FACTORY.createTrovit();
        trovit.getAd().add(TrovitWritingExample.createAd());
        trovit.getAd().add(TrovitWritingExample.createAd());
        trovit.getAd().add(TrovitWritingExample.createAd());
        TrovitDocument trovitDocument = null;
        try {
            trovitDocument = TrovitDocument.newDocument((Trovit)trovit);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            TrovitWritingExample.write(trovitDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        TrovitWritingExample.write(trovitDocument, (OutputStream)new NullOutputStream());
        TrovitWritingExample.write(trovitDocument, (Writer)new NullWriter());
        TrovitWritingExample.writeToConsole(trovitDocument);
    }

    protected static AdType createAd() {
        AdType adType = FACTORY.createAdType();
        adType.setAddress("object address");
        adType.setAgency("name of the agency");
        adType.setBathrooms(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)5.0)));
        adType.setByOwner(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        adType.setCity("name of the city");
        adType.setCityArea("name of the district");
        adType.setCondition("some notes about the condition");
        adType.setContactEmail("test@mywebsite.org");
        adType.setContactName("John Smith");
        adType.setContactTelephone("0049301234567");
        adType.setContent("some more descriptions");
        adType.setCountry("DE");
        adType.setDate(Calendar.getInstance());
        adType.setEcoScore("A");
        adType.setExpirationDate(Calendar.getInstance());
        adType.setFloorNumber("number of floors");
        adType.setForeclosure(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        adType.setForeclosureType(ForeclosureTypeValue.values()[RandomUtils.nextInt((int)0, (int)ForeclosureTypeValue.values().length)]);
        adType.setId(RandomStringUtils.random(5));
        adType.setIsFurnished(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        adType.setIsNew(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        adType.setIsRentToOwn(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        adType.setLatitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)180.0) - 90.0));
        adType.setLongitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)360.0) - 180.0));
        adType.setMlsDatabase("notes about mls database");
        adType.setNeighborhood("notes about the neighborhood");
        adType.setOrientation(OrientationValue.values()[RandomUtils.nextInt((int)0, (int)OrientationValue.values().length)]);
        adType.setParking(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        adType.setPostcode("postcode");
        adType.setPropertyType("notes about the property type");
        adType.setRegion("notes about the region");
        adType.setRooms(BigDecimal.valueOf(RandomUtils.nextDouble((double)1.0, (double)10.0)));
        adType.setTitle("title of the object");
        adType.setType(TypeValue.values()[RandomUtils.nextInt((int)0, (int)TypeValue.values().length)]);
        adType.setYear(BigInteger.valueOf(RandomUtils.nextInt((int)1700, (int)2017)));
        adType.setFloorArea(FACTORY.createFloorAreaType());
        adType.getFloorArea().setUnit(AreaUnitValue.values()[RandomUtils.nextInt((int)0, (int)AreaUnitValue.values().length)]);
        adType.getFloorArea().setValue(BigInteger.valueOf(RandomUtils.nextInt((int)10, (int)10000)));
        adType.setPictures(FACTORY.createAdTypePictures());
        adType.getPictures().getPicture().add(TrovitWritingExample.createPicture(0));
        adType.getPictures().getPicture().add(TrovitWritingExample.createPicture(1));
        adType.getPictures().getPicture().add(TrovitWritingExample.createPicture(2));
        adType.setPlotArea(FACTORY.createPlotAreaType());
        adType.getPlotArea().setUnit(AreaUnitValue.values()[RandomUtils.nextInt((int)0, (int)AreaUnitValue.values().length)]);
        adType.getPlotArea().setValue(BigInteger.valueOf(RandomUtils.nextInt((int)10, (int)10000)));
        adType.setPrice(FACTORY.createPriceType());
        adType.getPrice().setPeriod(PricePeriodValue.values()[RandomUtils.nextInt((int)0, (int)PricePeriodValue.values().length)]);
        adType.getPrice().setValue(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)2000.0)).setScale(2, RoundingMode.HALF_EVEN));
        try {
            adType.setUrl(new URI("http://mywebsite.org/"));
            adType.setMobileUrl(new URI("http://mobile.mywebsite.org/"));
            adType.setVirtualTour(new URI("http://tour.mywebsite.org/"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return adType;
    }

    protected static PictureType createPicture(int n) {
        try {
            PictureType pictureType = FACTORY.createPictureType();
            pictureType.setPictureTitle("some descriptive title");
            pictureType.setPictureUrl(new URI("http://mywebsite.org/image" + n + ".jpg"));
            pictureType.setFeatured(Boolean.valueOf(n == 0));
            return pictureType;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected static void write(TrovitDocument trovitDocument, File file) {
        LOGGER.info("writing document");
        try {
            trovitDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(TrovitDocument trovitDocument, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            trovitDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(TrovitDocument trovitDocument, Writer writer) {
        LOGGER.info("writing document");
        try {
            trovitDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(TrovitDocument trovitDocument) {
        LOGGER.info("writing document");
        try {
            String string = trovitDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + System.lineSeparator() + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

