/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.filemaker;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.filemaker.FilemakerDocument;
import org.openestate.io.filemaker.FilemakerUtils;
import org.openestate.io.filemaker.xml.layout.FMPXMLLAYOUT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilemakerLayoutDocument
extends FilemakerDocument<FMPXMLLAYOUT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilemakerLayoutDocument.class);

    public FilemakerLayoutDocument(Document document) {
        super(document);
        if (!FilemakerLayoutDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "FMPXMLLAYOUT".equals(element.getLocalName());
    }

    public static FilemakerLayoutDocument newDocument() throws ParserConfigurationException, JAXBException {
        return FilemakerLayoutDocument.newDocument(FilemakerUtils.getFactoryForLayout().createFMPXMLLAYOUT());
    }

    public static FilemakerLayoutDocument newDocument(FMPXMLLAYOUT fMPXMLLAYOUT) throws ParserConfigurationException, JAXBException {
        Document document = XmlUtils.newDocument();
        FilemakerUtils.createMarshaller("UTF-8", true).marshal((Object)fMPXMLLAYOUT, (Node)document);
        return new FilemakerLayoutDocument(document);
    }

    public FMPXMLLAYOUT toObject() throws JAXBException {
        return (FMPXMLLAYOUT)FilemakerUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

