/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.filemaker;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openestate.io.filemaker.xml.result.FMPXMLRESULT;
import org.openestate.io.filemaker.xml.result.MetaDataType;
import org.openestate.io.filemaker.xml.result.ResultSetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilemakerResultMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilemakerResultMapping.class);
    private final List<MetaDataType.FIELD> fields;
    private final List<Row> rows;

    public FilemakerResultMapping(FMPXMLRESULT fMPXMLRESULT) {
        if (fMPXMLRESULT.getMETADATA() == null || fMPXMLRESULT.getMETADATA().getFIELD().isEmpty()) {
            throw new IllegalArgumentException("No metadata is present in the xml result!");
        }
        this.fields = new ArrayList<MetaDataType.FIELD>();
        this.fields.addAll(fMPXMLRESULT.getMETADATA().getFIELD());
        this.rows = new ArrayList<Row>();
        if (fMPXMLRESULT.getRESULTSET() != null) {
            for (ResultSetType.ROW rOW : fMPXMLRESULT.getRESULTSET().getROW()) {
                this.rows.add(new Row(rOW.getRECORDID(), rOW.getMODID(), rOW, this.fields));
            }
        }
    }

    public MetaDataType.FIELD getField(int n) {
        return this.fields.get(n);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String[] getFieldNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MetaDataType.FIELD fIELD : this.fields) {
            arrayList.add(fIELD.getNAME());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public MetaDataType.FIELD[] getFields() {
        return this.fields.toArray(new MetaDataType.FIELD[this.fields.size()]);
    }

    public Row getRow(int n) {
        return this.rows.get(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Row[] getRows() {
        return this.rows.toArray(new Row[this.rows.size()]);
    }

    public static final class Row {
        private final long recordId;
        private final long modId;
        private final Map<String, Column> columns;

        private Row(BigInteger bigInteger, BigInteger bigInteger2, ResultSetType.ROW rOW, List<MetaDataType.FIELD> list) {
            this.recordId = bigInteger != null ? bigInteger.longValue() : 0L;
            this.modId = bigInteger2 != null ? bigInteger2.longValue() : 0L;
            this.columns = new HashMap<String, Column>();
            int n = 0;
            for (ResultSetType.ROW.COL cOL : rOW.getCOL()) {
                MetaDataType.FIELD fIELD = list.get(n);
                if (fIELD == null) {
                    LOGGER.warn("Can't find a field definition for column " + n + "!");
                    continue;
                }
                this.columns.put(fIELD.getNAME(), new Column(fIELD, cOL.getDATA()));
                ++n;
            }
        }

        public Column getColumn(String string) {
            return this.columns.get(string);
        }

        public MetaDataType.FIELD getField(String string) {
            Column column = this.columns.get(string);
            return column != null ? column.getField() : null;
        }

        public String[] getFieldNames() {
            return this.columns.keySet().toArray(new String[this.columns.size()]);
        }

        public long getModId() {
            return this.modId;
        }

        public long getRecordId() {
            return this.recordId;
        }

        public String getValue(String string) {
            Column column = this.columns.get(string);
            return column != null ? column.getValue() : null;
        }

        public String[] getValues(String string) {
            Column column = this.columns.get(string);
            return column != null ? column.getValues() : null;
        }
    }

    public static final class Column {
        private final MetaDataType.FIELD field;
        private final List<String> data;

        private Column(MetaDataType.FIELD fIELD, List<String> list) {
            this.field = fIELD;
            this.data = list;
        }

        public MetaDataType.FIELD getField() {
            return this.field;
        }

        public String getValue() {
            return !this.data.isEmpty() ? this.data.get(0) : null;
        }

        public String[] getValues() {
            return this.data.toArray(new String[this.data.size()]);
        }
    }
}

