/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.records;

import java.math.BigDecimal;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.types.Ausstattung;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Heizungsart;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.ObjektkategorieAnlageobjekt;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Anlageobjekt
extends Is24CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(Anlageobjekt.class);
    protected static final int FIELD_OBJEKTKATEGORIE = 60;
    protected static final int FIELD_GESAMTFLAECHE = 61;
    protected static final int FIELD_VERMIETBARE_FLAECHE = 62;
    protected static final int FIELD_WOHNFLAECHE = 63;
    protected static final int FIELD_GEWERBEFLAECHE = 64;
    protected static final int FIELD_GRUNDSTUECKSFLAECHE = 65;
    protected static final int FIELD_SONSTIGE_FLAECHE = 66;
    protected static final int FIELD_ETAGEN = 67;
    protected static final int FIELD_BAUJAHR = 68;
    protected static final int FIELD_OBJEKTZUSTAND = 69;
    protected static final int FIELD_PERSONENAUFZUG = 70;
    protected static final int FIELD_X_FACHE = 71;
    protected static final int FIELD_MIETEINNAHMEN_IST = 72;
    protected static final int FIELD_MIETEINNAHMEN_SOLL = 73;
    protected static final int FIELD_ANZAHL_PARKFLAECHEN = 74;
    protected static final int FIELD_FUSSWEG_NAHVERKEHR = 75;
    protected static final int FIELD_FAHRTWEG_HAUPTBAHNHOF = 76;
    protected static final int FIELD_FAHRTWEG_AUTOBAHN = 77;
    protected static final int FIELD_FAHRTWEG_FLUGHAFEN = 78;
    protected static final int FIELD_SANIERUNGSJAHR = 80;
    protected static final int FIELD_AUSSTATTUNG = 81;
    protected static final int FIELD_BEFEUERUNG = 83;
    protected static final int FIELD_ENERGIEAUSWEIS_TYP = 84;
    protected static final int FIELD_ENERGIEAUSWEIS_KENNWERT = 85;
    protected static final int FIELD_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    protected static final int FIELD_HEIZUNGSART = 87;
    protected static final int FIELD_DENKMALSCHUTZ = 88;
    protected static final int FIELD_KAUFPREIS = 90;
    protected static final int FIELD_KAUFPREIS_PRO_QM = 91;
    protected static final int FIELD_BETRIEBSKOSTEN_UMGELEGT = 92;
    protected static final int FIELD_NICHT_UMGELEGTE_KOSTEN = 93;
    protected static final int FIELD_PREIS_PRO_PARKFLAECHE = 94;

    public Anlageobjekt() {
        this.setImmobilienart(Immobilienart.ANLAGE);
    }

    public Integer getAnzahlParkflaechen() {
        try {
            return Is24CsvFormat.parseInteger(this.get(74));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Parkflaechen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Ausstattung getAusstattung() {
        return Ausstattung.parse(this.get(81));
    }

    public Integer getBaujahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(68));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Baujahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Befeuerungsart[] getBefeuerungsart() {
        return Befeuerungsart.parseMultiple(this.get(83));
    }

    public BigDecimal getBetriebskostenUmgelegt() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(92));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Betriebskosten umgelegt'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getDenkmalschutz() {
        return Is24CsvFormat.parseBoolean(this.get(88));
    }

    public Boolean getEnergieausweisInklWarmwasser() {
        return Is24CsvFormat.parseBoolean(this.get(86));
    }

    public BigDecimal getEnergieausweisKennwert() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(85));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Energieausweis-Kennwert'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public EnergieausweisTyp getEnergieausweisTyp() {
        return EnergieausweisTyp.parse(this.get(84));
    }

    public String getEtagen() {
        return this.get(67);
    }

    public Integer getFahrtwegAutobahn() {
        try {
            return Is24CsvFormat.parseInteger(this.get(77));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zur Autobahn'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFahrtwegFlughafen() {
        try {
            return Is24CsvFormat.parseInteger(this.get(78));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zum Flughafen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFahrtwegHauptbahnhof() {
        try {
            return Is24CsvFormat.parseInteger(this.get(76));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zum Hauptbahnhof'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFusswegNahverkehr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(75));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fussweg zum Nahverkehr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGesamtflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(61));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Gesamtflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGewerbeflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(64));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Gewerbeflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGrundstuecksflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(65));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Grundstuecksflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Heizungsart getHeizungsart() {
        return Heizungsart.parse(this.get(87));
    }

    public BigDecimal getKaufpreis() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(90));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Kaufpreis'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getKaufpreisProQm() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(91));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Kaufpreis pro qm'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getMieteinnahmenIst() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(72));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'IST-Mieteinnahmen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getMieteinnahmenSoll() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(73));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'SOLL-Mieteinnahmen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getNichtUmgelegteKosten() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(93));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'nicht umgelegte eKosten'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public ObjektkategorieAnlageobjekt getObjektkategorie() {
        return ObjektkategorieAnlageobjekt.parse(this.get(60));
    }

    public Objektzustand getObjektzustand() {
        return Objektzustand.parse(this.get(69));
    }

    public Boolean getPersonenaufzug() {
        return Is24CsvFormat.parseBoolean(this.get(70));
    }

    public BigDecimal getPreisProParkflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(94));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Preis pro Parkflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getSanierungsjahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(80));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Sanierungsjahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getSonstigeFlaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(66));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'sonstige Flaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getVermietbareFlaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(62));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'vermietbare Flaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getWohnflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(63));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Wohnflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getXFache() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(71));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'X-fache'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public static Anlageobjekt newRecord(CSVRecord cSVRecord) {
        Anlageobjekt anlageobjekt = new Anlageobjekt();
        anlageobjekt.parse(cSVRecord);
        return anlageobjekt;
    }

    protected Iterable<String> print() {
        this.setImmobilienart(Immobilienart.ANLAGE);
        return super.print();
    }

    public void setAnzahlParkflaechen(Number number) {
        this.set(74, Is24CsvFormat.printNumber(number, 5));
    }

    public void setAusstattung(Ausstattung ausstattung) {
        this.set(81, ausstattung != null ? ausstattung.print() : null);
    }

    public void setBaujahr(Number number) {
        this.set(68, Is24CsvFormat.printNumber(number, 4));
    }

    public void setBefeuerungsart(Befeuerungsart befeuerungsart) {
        this.set(83, befeuerungsart != null ? befeuerungsart.print() : null);
    }

    public void setBefeuerungsart(Iterable<Befeuerungsart> iterable) {
        this.set(83, Befeuerungsart.printMultiple(iterable));
    }

    public void setBetriebskostenUmgelegt(Number number) {
        this.set(92, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setDenkmalschutz(Boolean bl) {
        this.set(88, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisInklWarmwasser(Boolean bl) {
        this.set(86, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisKennwert(Number number) {
        this.set(85, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setEnergieausweisTyp(EnergieausweisTyp energieausweisTyp) {
        this.set(84, energieausweisTyp != null ? energieausweisTyp.print() : null);
    }

    public void setEtagen(String string) {
        this.set(67, Is24CsvFormat.printString(string, 50));
    }

    public void setFahrtwegAutobahn(Number number) {
        this.set(77, Is24CsvFormat.printNumber(number, 3));
    }

    public void setFahrtwegFlughafen(Number number) {
        this.set(78, Is24CsvFormat.printNumber(number, 3));
    }

    public void setFahrtwegHauptbahnhof(Number number) {
        this.set(76, Is24CsvFormat.printNumber(number, 2));
    }

    public void setFusswegNahverkehr(Number number) {
        this.set(75, Is24CsvFormat.printNumber(number, 2));
    }

    public void setGesamtflaeche(Number number) {
        this.set(61, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setGewerbeflaeche(Number number) {
        this.set(64, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setGrundstuecksflaeche(Number number) {
        this.set(65, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setHeizungsart(Heizungsart heizungsart) {
        this.set(87, heizungsart != null ? heizungsart.print() : null);
    }

    public void setKaufpreis(Number number) {
        this.set(90, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setKaufpreisProQm(Number number) {
        this.set(91, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setMieteinnahmenIst(Number number) {
        this.set(72, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setMieteinnahmenSoll(Number number) {
        this.set(73, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setNichtUmgelegteKosten(Number number) {
        this.set(93, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setObjektkategorie(ObjektkategorieAnlageobjekt objektkategorieAnlageobjekt) {
        this.set(60, objektkategorieAnlageobjekt != null ? objektkategorieAnlageobjekt.print() : null);
    }

    public void setObjektzustand(Objektzustand objektzustand) {
        this.set(69, objektzustand != null ? objektzustand.print() : null);
    }

    public void setPersonenaufzug(Boolean bl) {
        this.set(70, Is24CsvFormat.printBoolean(bl));
    }

    public void setPreisProParkflaeche(Number number) {
        this.set(94, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setSanierungsjahr(Number number) {
        this.set(80, Is24CsvFormat.printNumber(number, 4));
    }

    public void setSonstigeFlaeche(Number number) {
        this.set(66, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setVermietbareFlaeche(Number number) {
        this.set(62, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setWohnflaeche(Number number) {
        this.set(63, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setXFache(Number number) {
        this.set(71, Is24CsvFormat.printNumber(number, 3, 1));
    }
}

