/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.records;

import java.math.BigDecimal;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.Bodenbelag;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Heizungsart;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.KaltmietePro;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeHalleProduktion;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.openestate.io.is24_csv.types.VermarktungsartGewerbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GewerbeHalleProduktion
extends Is24CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(GewerbeHalleProduktion.class);
    protected static final int FIELD_VERMARKTUNGSART = 60;
    protected static final int FIELD_OBJEKTKATEGORIE = 61;
    protected static final int FIELD_GEWERBEFLAECHE = 62;
    protected static final int FIELD_NEBENFLAECHE = 63;
    protected static final int FIELD_GESAMTFLAECHE = 64;
    protected static final int FIELD_TEILBAR_AB = 65;
    protected static final int FIELD_ANZAHL_PARKFLAECHEN = 66;
    protected static final int FIELD_ETAGEN = 67;
    protected static final int FIELD_BAUJAHR = 68;
    protected static final int FIELD_OBJEKTZUSTAND = 69;
    protected static final int FIELD_BODENBELAG = 70;
    protected static final int FIELD_PERSONENAUFZUG = 71;
    protected static final int FIELD_HEBEBUEHNE = 72;
    protected static final int FIELD_HALLENHOEHE = 73;
    protected static final int FIELD_RAMPE = 74;
    protected static final int FIELD_BODENBELASTUNG = 75;
    protected static final int FIELD_LASTENAUFZUG = 76;
    protected static final int FIELD_LASTENAUFZUG_TRAGKRAFT = 77;
    protected static final int FIELD_KRANBAHN = 78;
    protected static final int FIELD_KRANBAHN_TRAGKRAFT = 79;
    protected static final int FIELD_GRUNDSTUECKSFLAECHE = 80;
    protected static final int FIELD_STROMANSCHLUSSWERT = 81;
    protected static final int FIELD_FUSSWEG_NAHVERKEHR = 82;
    protected static final int FIELD_FAHRTWEG_HAUPTBAHNHOF = 83;
    protected static final int FIELD_FAHRTWEG_AUTOBAHN = 84;
    protected static final int FIELD_FAHRTWEG_FLUGHAFEN = 85;
    protected static final int FIELD_VERFUEGBAR_AB = 87;
    protected static final int FIELD_HEIZUNGSART = 87;
    protected static final int FIELD_SANIERUNGSJAHR = 88;
    protected static final int FIELD_BEFEUERUNG = 89;
    protected static final int FIELD_KALTMIETE = 90;
    protected static final int FIELD_NEBENKOSTEN = 91;
    protected static final int FIELD_KALTMIETE_PRO = 92;
    protected static final int FIELD_KAUFPREIS = 93;
    protected static final int FIELD_PREIS_PRO_PARKFLAECHE = 94;
    protected static final int FIELD_KAUTION = 95;
    protected static final int FIELD_ENERGIEAUSWEIS_TYP = 96;
    protected static final int FIELD_ENERGIEAUSWEIS_KENNWERT = 97;
    protected static final int FIELD_ENERGIEAUSWEIS_INKL_WARMWASSER = 98;

    public GewerbeHalleProduktion() {
        this.setImmobilienart(Immobilienart.GEWERBE_HALLE_PRODUKTION);
    }

    public Integer getAnzahlParkflaechen() {
        try {
            return Is24CsvFormat.parseInteger(this.get(66));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Parkflaechen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getBaujahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(68));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Baujahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Befeuerungsart[] getBefeuerungsart() {
        return Befeuerungsart.parseMultiple(this.get(89));
    }

    public Bodenbelag getBodenbelag() {
        return Bodenbelag.parse(this.get(70));
    }

    public BigDecimal getBodenbelastung() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(75));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Bodenbelastung'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getEnergieausweisInklWarmwasser() {
        return Is24CsvFormat.parseBoolean(this.get(98));
    }

    public BigDecimal getEnergieausweisKennwert() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(97));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Energieausweis-Kennwert'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public EnergieausweisTyp getEnergieausweisTyp() {
        return EnergieausweisTyp.parse(this.get(96));
    }

    public String getEtagen() {
        return this.get(67);
    }

    public Integer getFahrtwegAutobahn() {
        try {
            return Is24CsvFormat.parseInteger(this.get(84));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zur Autobahn'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFahrtwegFlughafen() {
        try {
            return Is24CsvFormat.parseInteger(this.get(85));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zum Flughafen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFahrtwegHauptbahnhof() {
        try {
            return Is24CsvFormat.parseInteger(this.get(83));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zum Hauptbahnhof'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFusswegNahverkehr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(82));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fussweg zum Nahverkehr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGesamtflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(64));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Gesamtflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGewerbeflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(62));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Gewerbeflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGrundstuecksflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(80));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Grundstuecksflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getHallenhoehe() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(73));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Hallenhoehe'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getHebebuehne() {
        return Is24CsvFormat.parseBoolean(this.get(72));
    }

    public Heizungsart getHeizungsart() {
        return Heizungsart.parse(this.get(87));
    }

    public BigDecimal getKaltmiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(90));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Kaltmiete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public KaltmietePro getKaltmietePro() {
        return KaltmietePro.parse(this.get(92));
    }

    public BigDecimal getKaufpreis() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(93));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Kaufpreis'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getKaution() {
        return this.get(95);
    }

    public Boolean getKranbahn() {
        return Is24CsvFormat.parseBoolean(this.get(78));
    }

    public BigDecimal getKranbahnTragkraft() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(79));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Kranbahn Tragkraft'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getLastenaufzug() {
        return Is24CsvFormat.parseBoolean(this.get(76));
    }

    public BigDecimal getLastenaufzugTragkraft() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(77));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Lastenaufzug Tragkraft'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getNebenflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(63));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Nebenflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getNebenkosten() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(91));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Nebenkosten'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public ObjektkategorieGewerbeHalleProduktion getObjektkategorie() {
        return ObjektkategorieGewerbeHalleProduktion.parse(this.get(61));
    }

    public Objektzustand getObjektzustand() {
        return Objektzustand.parse(this.get(69));
    }

    public Boolean getPersonenaufzug() {
        return Is24CsvFormat.parseBoolean(this.get(71));
    }

    public BigDecimal getPreisProParkflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(94));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Preis pro Parkflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getRampe() {
        return Is24CsvFormat.parseBoolean(this.get(74));
    }

    public Integer getSanierungsjahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(88));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Sanierungsjahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getStromanschlusswert() {
        try {
            return Is24CsvFormat.parseInteger(this.get(81));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Stromanschlusswert'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getTeilbarAb() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(65));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'teilbar ab'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getVerfuegbarAb() {
        return this.get(87);
    }

    public VermarktungsartGewerbe getVermarktungsart() {
        return VermarktungsartGewerbe.parse(this.get(60));
    }

    public static GewerbeHalleProduktion newRecord(CSVRecord cSVRecord) {
        GewerbeHalleProduktion gewerbeHalleProduktion = new GewerbeHalleProduktion();
        gewerbeHalleProduktion.parse(cSVRecord);
        return gewerbeHalleProduktion;
    }

    protected Iterable<String> print() {
        this.setImmobilienart(Immobilienart.GEWERBE_HALLE_PRODUKTION);
        return super.print();
    }

    public void setAnzahlParkflaechen(Number number) {
        this.set(66, Is24CsvFormat.printNumber(number, 5));
    }

    public void setBaujahr(Number number) {
        this.set(68, Is24CsvFormat.printNumber(number, 4));
    }

    public void setBefeuerungsart(Befeuerungsart befeuerungsart) {
        this.set(89, befeuerungsart != null ? befeuerungsart.print() : null);
    }

    public void setBefeuerungsart(Iterable<Befeuerungsart> iterable) {
        this.set(89, Befeuerungsart.printMultiple(iterable));
    }

    public void setBodenbelag(Bodenbelag bodenbelag) {
        this.set(70, bodenbelag != null ? bodenbelag.print() : null);
    }

    public void setBodenbelastung(Number number) {
        this.set(75, Is24CsvFormat.printNumber(number, 7, 2));
    }

    public void setEnergieausweisInklWarmwasser(Boolean bl) {
        this.set(98, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisKennwert(Number number) {
        this.set(97, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setEnergieausweisTyp(EnergieausweisTyp energieausweisTyp) {
        this.set(96, energieausweisTyp != null ? energieausweisTyp.print() : null);
    }

    public void setEtagen(String string) {
        this.set(67, Is24CsvFormat.printString(string, 50));
    }

    public void setFahrtwegAutobahn(Number number) {
        this.set(84, Is24CsvFormat.printNumber(number, 3));
    }

    public void setFahrtwegFlughafen(Number number) {
        this.set(85, Is24CsvFormat.printNumber(number, 3));
    }

    public void setFahrtwegHauptbahnhof(Number number) {
        this.set(83, Is24CsvFormat.printNumber(number, 2));
    }

    public void setFusswegNahverkehr(Number number) {
        this.set(82, Is24CsvFormat.printNumber(number, 2));
    }

    public void setGesamtflaeche(Number number) {
        this.set(64, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setGewerbeflaeche(Number number) {
        this.set(62, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setGrundstuecksflaeche(Number number) {
        this.set(80, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setHallenhoehe(Number number) {
        this.set(73, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setHebebuehne(Boolean bl) {
        this.set(72, Is24CsvFormat.printBoolean(bl));
    }

    public void setHeizungsart(Heizungsart heizungsart) {
        this.set(87, heizungsart != null ? heizungsart.print() : null);
    }

    public void setKaltmiete(Number number) {
        this.set(90, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setKaltmietePro(KaltmietePro kaltmietePro) {
        this.set(92, kaltmietePro != null ? kaltmietePro.print() : null);
    }

    public void setKaufpreis(Number number) {
        this.set(93, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setKaution(String string) {
        this.set(95, Is24CsvFormat.printString(string, 50));
    }

    public void setKranbahn(Boolean bl) {
        this.set(78, Is24CsvFormat.printBoolean(bl));
    }

    public void setKranbahnTragkraft(Number number) {
        this.set(79, Is24CsvFormat.printNumber(number, 7, 2));
    }

    public void setLastenaufzug(Boolean bl) {
        this.set(76, Is24CsvFormat.printBoolean(bl));
    }

    public void setLastenaufzugTragkraft(Number number) {
        this.set(77, Is24CsvFormat.printNumber(number, 7, 2));
    }

    public void setNebenflaeche(Number number) {
        this.set(63, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setNebenkosten(Number number) {
        this.set(91, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setObjektkategorie(ObjektkategorieGewerbeHalleProduktion objektkategorieGewerbeHalleProduktion) {
        this.set(61, objektkategorieGewerbeHalleProduktion != null ? objektkategorieGewerbeHalleProduktion.print() : null);
    }

    public void setObjektzustand(Objektzustand objektzustand) {
        this.set(69, objektzustand != null ? objektzustand.print() : null);
    }

    public void setPersonenaufzug(Boolean bl) {
        this.set(71, Is24CsvFormat.printBoolean(bl));
    }

    public void setPreisProParkflaeche(Number number) {
        this.set(94, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setRampe(Boolean bl) {
        this.set(74, Is24CsvFormat.printBoolean(bl));
    }

    public void setSanierungsjahr(Number number) {
        this.set(88, Is24CsvFormat.printNumber(number, 4));
    }

    public void setStromanschlusswert(Number number) {
        this.set(81, Is24CsvFormat.printNumber(number, 5));
    }

    public void setTeilbarAb(Number number) {
        this.set(65, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setVerfuegbarAb(String string) {
        this.set(87, Is24CsvFormat.printString(string, 50));
    }

    public void setVermarktungsart(VermarktungsartGewerbe vermarktungsartGewerbe) {
        this.set(60, vermarktungsartGewerbe != null ? vermarktungsartGewerbe.print() : null);
    }
}

