/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.types;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public enum Befeuerungsart {
    KEINE_ANGABE(1),
    ERDWAERME(2),
    SOLARHEIZUNG(3),
    PELLETHEIZUNG(4),
    GAS(5),
    OEL(6),
    FERNWAERME(7),
    STROM(8),
    KOHLE(9);

    private final int value;

    private Befeuerungsart(int n2) {
        this.value = n2;
    }

    public static Befeuerungsart parse(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (Befeuerungsart befeuerungsart : Befeuerungsart.values()) {
            if (!String.valueOf(befeuerungsart.value).equalsIgnoreCase(string)) continue;
            return befeuerungsart;
        }
        return KEINE_ANGABE;
    }

    public static Befeuerungsart[] parseMultiple(String string) {
        String[] stringArray = StringUtils.split((String)string, (String)";");
        if (stringArray == null) {
            return new Befeuerungsart[0];
        }
        ArrayList<Befeuerungsart> arrayList = new ArrayList<Befeuerungsart>();
        for (String string2 : stringArray) {
            Befeuerungsart befeuerungsart = Befeuerungsart.parse(string2);
            if (befeuerungsart == null || KEINE_ANGABE.equals((Object)befeuerungsart) || arrayList.contains((Object)befeuerungsart)) continue;
            arrayList.add(befeuerungsart);
        }
        return arrayList.toArray(new Befeuerungsart[arrayList.size()]);
    }

    public String print() {
        return String.valueOf(this.value);
    }

    public static String printMultiple(Iterable<Befeuerungsart> iterable) {
        if (iterable == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Befeuerungsart befeuerungsart : iterable) {
            String string;
            if (KEINE_ANGABE.equals((Object)befeuerungsart) || arrayList.contains(string = befeuerungsart.print())) continue;
            arrayList.add(string);
        }
        return StringUtils.trimToNull((String)StringUtils.join(arrayList, (String)";"));
    }
}

