/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.records;

import java.math.BigDecimal;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.records.Grundstueck;
import org.openestate.io.is24_csv.types.BebaubarNach;
import org.openestate.io.is24_csv.types.Erschliessung;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.NutzungGrundstueckWohnen;
import org.openestate.io.is24_csv.types.ObjektkategorieGrundstueck;
import org.openestate.io.is24_csv.types.Vermarktungsart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrundstueckWohnen
extends Grundstueck {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrundstueckWohnen.class);
    protected static final int FIELD_GRUNDSTUECKSFLAECHE = 62;
    protected static final int FIELD_FLAECHE_TEILBAR_AB = 63;
    protected static final int FIELD_EMPFOHLENE_NUTZUNG = 64;
    protected static final int FIELD_BEBAUBAR_NACH = 65;
    protected static final int FIELD_ERBPACHTDAUER = 66;
    protected static final int FIELD_BAUGENEHMIGUNG_VORHANDEN = 67;
    protected static final int FIELD_ABRISS_ERFORDERLICH = 68;
    protected static final int FIELD_GRUNDFLAECHENZAHL = 69;
    protected static final int FIELD_GESCHOSSFLAECHENZAHL = 70;
    protected static final int FIELD_ERSCHLIESSUNG = 71;
    protected static final int FIELD_KURZFRISTIG_BEBAUBAR = 72;
    protected static final int FIELD_VERFUEGBAR_AB = 73;
    protected static final int FIELD_PREIS = 90;

    public GrundstueckWohnen() {
        this.setImmobilienart(Immobilienart.GRUNDSTUECKE);
        this.setObjektkategorie(ObjektkategorieGrundstueck.WOHNEN);
    }

    public Boolean getAbrissErforderlich() {
        return Is24CsvFormat.parseBoolean(this.get(68));
    }

    public Boolean getBaugenehmigungVorhanden() {
        return Is24CsvFormat.parseBoolean(this.get(67));
    }

    public BebaubarNach getBebaubarNach() {
        return BebaubarNach.parse(this.get(65));
    }

    public NutzungGrundstueckWohnen[] getEmpfohleneNutzung() {
        return NutzungGrundstueckWohnen.parseMultiple(this.get(64));
    }

    public Integer getErbpachtdauer() {
        try {
            return Is24CsvFormat.parseInteger(this.get(66));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Erbpachtdauer'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Erschliessung getErschliessung() {
        return Erschliessung.parse(this.get(71));
    }

    public Long getFlaecheTeilbarAb() {
        try {
            return Is24CsvFormat.parseLong(this.get(63));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Flaeche teilbar ab'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGeschossflaechenzahl() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(70));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Geschossflaechenzahl'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGrundflaechenzahl() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(69));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Grundflaechenzahl'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGrundstuecksflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(62));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Grundstuecksflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getKurzfristigBebaubar() {
        return Is24CsvFormat.parseBoolean(this.get(72));
    }

    public BigDecimal getPreis() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(90));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Preis'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getVerfuegbarAb() {
        return this.get(73);
    }

    public static GrundstueckWohnen newRecord(CSVRecord cSVRecord) {
        GrundstueckWohnen grundstueckWohnen = new GrundstueckWohnen();
        grundstueckWohnen.parse(cSVRecord);
        return grundstueckWohnen;
    }

    protected Iterable<String> print() {
        this.setImmobilienart(Immobilienart.GRUNDSTUECKE);
        this.setObjektkategorie(ObjektkategorieGrundstueck.WOHNEN);
        Vermarktungsart vermarktungsart = this.getVermarktungsart();
        if (!Vermarktungsart.ERBPACHT.equals((Object)vermarktungsart)) {
            this.setErbpachtdauer(null);
        }
        return super.print();
    }

    public void setAbrissErforderlich(Boolean bl) {
        this.set(68, Is24CsvFormat.printBoolean(bl));
    }

    public void setBaugenehmigungVorhanden(Boolean bl) {
        this.set(67, Is24CsvFormat.printBoolean(bl));
    }

    public void setBebaubarNach(BebaubarNach bebaubarNach) {
        this.set(65, bebaubarNach != null ? bebaubarNach.print() : null);
    }

    public void setEmpfohleneNutzung(NutzungGrundstueckWohnen nutzungGrundstueckWohnen) {
        this.set(64, nutzungGrundstueckWohnen != null ? nutzungGrundstueckWohnen.print() : null);
    }

    public void setEmpfohleneNutzung(Iterable<NutzungGrundstueckWohnen> iterable) {
        this.set(64, NutzungGrundstueckWohnen.printMultiple(iterable));
    }

    public void setErbpachtdauer(Number number) {
        this.set(66, Is24CsvFormat.printNumber(number, 3));
    }

    public void setErschliessung(Erschliessung erschliessung) {
        this.set(71, erschliessung != null ? erschliessung.print() : null);
    }

    public void setFlaecheTeilbarAb(Number number) {
        this.set(63, Is24CsvFormat.printNumber(number, 8));
    }

    public void setGeschossflaechenzahl(Number number) {
        this.set(70, Is24CsvFormat.printNumber(number, 3, 2));
    }

    public void setGrundflaechenzahl(Number number) {
        this.set(69, Is24CsvFormat.printNumber(number, 3, 2));
    }

    public void setGrundstuecksflaeche(Number number) {
        this.set(62, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setKurzfristigBebaubar(Boolean bl) {
        this.set(72, Is24CsvFormat.printBoolean(bl));
    }

    @Override
    public void setObjektkategorie(ObjektkategorieGrundstueck objektkategorieGrundstueck) {
        if (objektkategorieGrundstueck != null && !ObjektkategorieGrundstueck.WOHNEN.equals((Object)objektkategorieGrundstueck)) {
            throw new IllegalArgumentException("The provided value (" + (Object)((Object)objektkategorieGrundstueck) + ") is not supported by this record.");
        }
        super.setObjektkategorie(objektkategorieGrundstueck != null ? objektkategorieGrundstueck : ObjektkategorieGrundstueck.WOHNEN);
    }

    public void setPreis(Number number) {
        this.set(90, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setVerfuegbarAb(String string) {
        this.set(73, Is24CsvFormat.printString(string, 50));
    }
}

