/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.is24_xml.Is24XmlDocument;
import org.openestate.io.is24_xml.xml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Is24XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlUtils.class);
    private static JAXBContext JAXB = null;
    public static final String VERSION = "rev189438";
    public static final String NAMESPACE = "http://www.immobilienscout24.de/immobilientransfer";
    public static final String PACKAGE = "org.openestate.io.is24_xml.xml";
    public static final ObjectFactory FACTORY = new ObjectFactory();

    private Is24XmlUtils() {
    }

    public static Is24XmlDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return Is24XmlUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static Is24XmlDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return Is24XmlUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static Is24XmlDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return Is24XmlUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static Is24XmlDocument createDocument(Document document) {
        if (Is24XmlDocument.isReadable(document)) {
            return new Is24XmlDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return Is24XmlUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = Is24XmlUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = Is24XmlUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            Is24XmlUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static Calendar parseDate(String string) {
        return XmlUtils.parseDate((String)string);
    }

    public static BigDecimal parsePreisAufAnfrage(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static String parseEmail(String string) {
        return StringUtils.trimToNull((String)string);
    }

    private static String parseText(String string, int n) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parseText4(String string) {
        return Is24XmlUtils.parseText(string, 4);
    }

    public static String parseText15(String string) {
        return Is24XmlUtils.parseText(string, 15);
    }

    public static String parseText20(String string) {
        return Is24XmlUtils.parseText(string, 20);
    }

    public static String parseText30(String string) {
        return Is24XmlUtils.parseText(string, 30);
    }

    public static String parseText40(String string) {
        return Is24XmlUtils.parseText(string, 40);
    }

    public static String parseText50(String string) {
        return Is24XmlUtils.parseText(string, 50);
    }

    public static String parseText80(String string) {
        return Is24XmlUtils.parseText(string, 80);
    }

    public static String parseText100(String string) {
        return Is24XmlUtils.parseText(string, 100);
    }

    public static String parseText150(String string) {
        return Is24XmlUtils.parseText(string, 150);
    }

    public static String parseText200(String string) {
        return Is24XmlUtils.parseText(string, 200);
    }

    public static String parseText255(String string) {
        return Is24XmlUtils.parseText(string, 255);
    }

    public static String parseText300(String string) {
        return Is24XmlUtils.parseText(string, 300);
    }

    public static String parseText500(String string) {
        return Is24XmlUtils.parseText(string, 500);
    }

    public static String parseText2000(String string) {
        return Is24XmlUtils.parseText(string, 2000);
    }

    public static URI parseWebUrl(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            if (StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"http://")) {
                return new URI(string);
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"https://")) {
                return new URI(string);
            }
            return new URI("http://" + string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Can't parse URI value '" + string + "'!", uRISyntaxException);
        }
    }

    public static Long parseZahl2(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Long.valueOf(DatatypeConverter.parseLong((String)string)) : null;
    }

    public static Long parseZahl3(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Long.valueOf(DatatypeConverter.parseLong((String)string)) : null;
    }

    public static Long parseZahl4(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Long.valueOf(DatatypeConverter.parseLong((String)string)) : null;
    }

    public static Long parseZahl5(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Long.valueOf(DatatypeConverter.parseLong((String)string)) : null;
    }

    public static Long parseZahl8(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Long.valueOf(DatatypeConverter.parseLong((String)string)) : null;
    }

    public static Long parseZahl10(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Long.valueOf(DatatypeConverter.parseLong((String)string)) : null;
    }

    public static BigInteger parseZahl20(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseInteger((String)string) : null;
    }

    public static BigDecimal parseZahl31(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZahl32(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZahl42(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZahl52(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZahl62(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZahl72(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZahl102(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZahl152(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseZimmeranzahl(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static String printDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date value!");
        }
        return Is24XmlUtils.getDateFormat().format(calendar.getTime());
    }

    public static String printEmail(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null || string.length() > 150 || !string.matches(".*@.*\\..*")) {
            throw new IllegalArgumentException("Can't print email value '" + string + "'!");
        }
        return string;
    }

    public static String printPreisAufAnfrage(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 0 || bigDecimal.compareTo(BigDecimal.TEN.pow(13)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    private static String printText(String string, int n) {
        int n2 = (string = StringUtils.trimToEmpty((String)string)).length();
        if (n2 <= 0) {
            return "";
        }
        if (n2 <= n) {
            return string;
        }
        if (n > 3) {
            return StringUtils.abbreviate((String)string, (int)n);
        }
        return string.substring(0, n);
    }

    public static String printText4(String string) {
        return Is24XmlUtils.printText(string, 4);
    }

    public static String printText15(String string) {
        return Is24XmlUtils.printText(string, 15);
    }

    public static String printText20(String string) {
        return Is24XmlUtils.printText(string, 20);
    }

    public static String printText30(String string) {
        return Is24XmlUtils.printText(string, 30);
    }

    public static String printText40(String string) {
        return Is24XmlUtils.printText(string, 40);
    }

    public static String printText50(String string) {
        return Is24XmlUtils.printText(string, 50);
    }

    public static String printText80(String string) {
        return Is24XmlUtils.printText(string, 80);
    }

    public static String printText100(String string) {
        return Is24XmlUtils.printText(string, 100);
    }

    public static String printText150(String string) {
        return Is24XmlUtils.printText(string, 150);
    }

    public static String printText200(String string) {
        return Is24XmlUtils.printText(string, 200);
    }

    public static String printText255(String string) {
        return Is24XmlUtils.printText(string, 255);
    }

    public static String printText300(String string) {
        return Is24XmlUtils.printText(string, 300);
    }

    public static String printText500(String string) {
        return Is24XmlUtils.printText(string, 500);
    }

    public static String printText2000(String string) {
        return Is24XmlUtils.printText(string, 2000);
    }

    public static String printWebUrl(URI uRI) {
        if (uRI == null || StringUtils.isBlank((CharSequence)uRI.getHost())) {
            throw new IllegalArgumentException("Can't print URI value '" + uRI + "'!");
        }
        return uRI.toString();
    }

    public static String printZahl2(Long l) {
        if (l == null || l <= 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 2) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 2 digits.");
        }
        return string;
    }

    public static String printZahl2Including0(Long l) {
        if (l == null || l < 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 2) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 2 digits.");
        }
        return string;
    }

    public static String printZahl3(Long l) {
        if (l == null || l <= 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 3) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 3 digits.");
        }
        return string;
    }

    public static String printZahl3Including0(Long l) {
        if (l == null || l < 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 3) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 3 digits.");
        }
        return string;
    }

    public static String printZahl4(Long l) {
        if (l == null || l <= 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 4) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 4 digits.");
        }
        return string;
    }

    public static String printZahl5(Long l) {
        if (l == null || l <= 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 5) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 5 digits.");
        }
        return string;
    }

    public static String printZahl8(Long l) {
        if (l == null || l <= 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 8) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 8 digits.");
        }
        return string;
    }

    public static String printZahl10(Long l) {
        if (l == null || l <= 0L) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'!");
        }
        String string = DatatypeConverter.printLong((long)l);
        if (string.length() > 10) {
            throw new IllegalArgumentException("Can't print integer value '" + l + "'! The value exceeds maximal length of 10 digits.");
        }
        return string;
    }

    public static String printZahl20(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 1) {
            throw new IllegalArgumentException("Can't print integer value '" + bigInteger + "'!");
        }
        String string = DatatypeConverter.printInteger((BigInteger)bigInteger);
        if (string.length() > 20) {
            throw new IllegalArgumentException("Can't print integer value '" + bigInteger + "'! The value exceeds maximal length of 20 digits.");
        }
        return string;
    }

    public static String printZahl31(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(2)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(1, 4));
    }

    public static String printZahl32(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(1)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printZahl42(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(2)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printZahl52(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(3)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printZahl62(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(4)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printZahl72(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(5)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printZahl102(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(8)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printZahl152(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1 || bigDecimal.compareTo(BigDecimal.TEN.pow(13)) >= 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printZimmeranzahl(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal("0.5");
        BigDecimal bigDecimal3 = new BigDecimal("9999");
        if (bigDecimal == null || bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return Is24XmlUtils.printZahl62(bigDecimal);
    }
}

