/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.immoxml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.immoxml.ImmoXmlDocument;
import org.openestate.io.immoxml.ImmoXmlVersion;
import org.openestate.io.immoxml.xml.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ImmoXmlUtils {
    private static JAXBContext JAXB = null;
    public static final ImmoXmlVersion VERSION = ImmoXmlVersion.V3_0;
    public static final String NAMESPACE = "http://www.immoxml.de";
    public static final String PACKAGE = "org.openestate.io.immoxml.xml";
    public static final ObjectFactory FACTORY = new ObjectFactory();

    private ImmoXmlUtils() {
    }

    public static ImmoXmlDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return ImmoXmlUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static ImmoXmlDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return ImmoXmlUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static ImmoXmlDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return ImmoXmlUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static ImmoXmlDocument createDocument(Document document) {
        if (ImmoXmlDocument.isReadable(document)) {
            return new ImmoXmlDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return ImmoXmlUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = ImmoXmlUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = ImmoXmlUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static Element createUserDefinedSimplefield(Document document, String string, String string2) {
        Element element = XmlUtils.getRootElement((Document)document);
        Element element2 = document.createElementNS(element.getNamespaceURI(), "user_defined_simplefield");
        element2.setAttribute("feldname", string);
        element2.setTextContent(string2);
        return element2;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            ImmoXmlUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static Calendar parseDate(String string) {
        return XmlUtils.parseDate((String)string);
    }

    public static Calendar parseDateTime(String string) {
        return XmlUtils.parseDateTime((String)string);
    }

    public static BigDecimal parseDecimal(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseDecimal((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);
                return BigDecimal.valueOf(numberFormat.parse(string).doubleValue());
            }
            catch (NumberFormatException numberFormatException2) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            throw new IllegalArgumentException("Can't parse decimal value '" + string + "'!");
        }
    }

    public static BigInteger parseInteger(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseInteger((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse integer value '" + string + "'! " + numberFormatException.getLocalizedMessage());
        }
    }

    public static BigDecimal parsePositiveDecimal(String string) {
        return ImmoXmlUtils.parseDecimal(string);
    }

    public static BigInteger parsePositiveInteger(String string) {
        return ImmoXmlUtils.parseInteger(string);
    }

    public static String printDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date value!");
        }
        return ImmoXmlUtils.getDateFormat().format(calendar.getTime());
    }

    public static String printDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date-time value!");
        }
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public static String printDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print double value!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Can't print integer value!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printPositiveDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) >= 0) {
            throw new IllegalArgumentException("Can't print positive decimal value!");
        }
        return ImmoXmlUtils.printDecimal(bigDecimal.setScale(2, 4));
    }

    public static String printPositiveInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) > 0) {
            throw new IllegalArgumentException("Can't print positive integer value!");
        }
        return ImmoXmlUtils.printInteger(bigInteger);
    }
}

