/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.immoxml;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConvertableDocument;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.immoxml.ImmoXmlUtils;
import org.openestate.io.immoxml.ImmoXmlVersion;
import org.openestate.io.immoxml.xml.Immoxml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImmoXmlDocument
extends XmlConvertableDocument<Immoxml, ImmoXmlVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmoXmlDocument.class);

    public ImmoXmlDocument(Document document) {
        super(document);
        if (!ImmoXmlDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    public ImmoXmlVersion getDocumentVersion() {
        String string;
        Object object;
        try {
            object = this.getDocument();
            string = StringUtils.trimToNull((String)XmlUtils.newXPath((String)"/io:immoxml/io:uebertragung/@version", (Document)object).stringValueOf(object));
            if (string == null) {
                LOGGER.warn("Can't find version informations in the XML document!");
                return null;
            }
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
            return null;
        }
        object = ImmoXmlVersion.detectFromString(string);
        if (object != null) {
            return object;
        }
        LOGGER.warn("The provided version (" + string + ") is not supported!");
        return null;
    }

    public ImmoXmlVersion getLatestVersion() {
        return ImmoXmlVersion.V3_0;
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "immoxml".equals(element.getLocalName());
    }

    public static ImmoXmlDocument newDocument() throws ParserConfigurationException, JAXBException {
        return ImmoXmlDocument.newDocument(ImmoXmlUtils.getFactory().createImmoxml());
    }

    public static ImmoXmlDocument newDocument(Immoxml immoxml) throws ParserConfigurationException, JAXBException {
        if (immoxml.getUebertragung() == null) {
            immoxml.setUebertragung(ImmoXmlUtils.getFactory().createUebertragung());
        }
        if (StringUtils.isBlank((CharSequence)immoxml.getUebertragung().getVersion())) {
            immoxml.getUebertragung().setVersion(ImmoXmlUtils.VERSION.toReadableVersion());
        }
        Document document = XmlUtils.newDocument();
        ImmoXmlUtils.createMarshaller("UTF-8", true).marshal((Object)immoxml, (Node)document);
        return new ImmoXmlDocument(document);
    }

    public void setDocumentVersion(ImmoXmlVersion immoXmlVersion) {
        try {
            Object object;
            Document document = this.getDocument();
            String string = StringUtils.trimToEmpty((String)XmlUtils.newXPath((String)"/io:immoxml/io:uebertragung/@version", (Document)document).stringValueOf((Object)document));
            String[] stringArray = StringUtils.split((String)string, (String)"/", (int)2);
            Element element = (Element)XmlUtils.newXPath((String)"/io:immoxml/io:uebertragung", (Document)document).selectSingleNode((Object)document);
            if (element == null) {
                object = (Element)XmlUtils.newXPath((String)"/io:immoxml", (Document)document).selectSingleNode((Object)document);
                if (object == null) {
                    LOGGER.warn("Can't find an <immoxml> element in the document!");
                    return;
                }
                element = document.createElement("uebertragung");
                object.insertBefore(element, object.getFirstChild());
            }
            object = immoXmlVersion.toReadableVersion();
            if (stringArray.length > 1) {
                object = (String)object + "/" + stringArray[1];
            }
            element.setAttribute("version", (String)object);
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
        }
    }

    public Immoxml toObject() throws JAXBException {
        this.upgradeToLatestVersion();
        return (Immoxml)ImmoXmlUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

