/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.kyero;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConvertableDocument;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.KyeroVersion;
import org.openestate.io.kyero.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KyeroDocument
extends XmlConvertableDocument<Root, KyeroVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroDocument.class);

    public KyeroDocument(Document document) {
        super(document);
        if (!KyeroDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    public KyeroVersion getDocumentVersion() {
        String string;
        Object object;
        try {
            object = this.getDocument();
            string = StringUtils.trimToNull((String)XmlUtils.newXPath((String)"/io:root/io:kyero/io:feed_version/text()", (Document)object).stringValueOf(object));
            if (string == null) {
                LOGGER.warn("Can't find version informations in the XML document!");
                return null;
            }
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
            return null;
        }
        object = KyeroVersion.detectFromString(string);
        if (object != null) {
            return object;
        }
        LOGGER.warn("The provided version (" + string + ") is not supported!");
        return null;
    }

    public KyeroVersion getLatestVersion() {
        return KyeroVersion.V3;
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "root".equals(element.getLocalName());
    }

    public static KyeroDocument newDocument() throws ParserConfigurationException, JAXBException {
        return KyeroDocument.newDocument(KyeroUtils.getFactory().createRoot());
    }

    public static KyeroDocument newDocument(Root root) throws ParserConfigurationException, JAXBException {
        if (root.getKyero() == null) {
            root.setKyero(KyeroUtils.getFactory().createKyeroType());
        }
        if (StringUtils.isBlank((CharSequence)root.getKyero().getFeedVersion())) {
            root.getKyero().setFeedVersion(KyeroUtils.VERSION.toXmlVersion());
        }
        Document document = XmlUtils.newDocument();
        KyeroUtils.createMarshaller("UTF-8", true).marshal((Object)root, (Node)document);
        return new KyeroDocument(document);
    }

    public void setDocumentVersion(KyeroVersion kyeroVersion) {
        try {
            Object object;
            Document document = this.getDocument();
            Element element = (Element)XmlUtils.newXPath((String)"/io:root/io:kyero/io:feed_version", (Document)document).selectSingleNode((Object)document);
            if (element == null) {
                object = (Element)XmlUtils.newXPath((String)"/io:root/io:kyero", (Document)document).selectSingleNode((Object)document);
                if (object == null) {
                    Element element2 = (Element)XmlUtils.newXPath((String)"/io:root", (Document)document).selectSingleNode((Object)document);
                    if (element2 == null) {
                        LOGGER.warn("Can't find a <root> element in the document!");
                        return;
                    }
                    object = document.createElement("kyero");
                    element2.insertBefore((Node)object, element2.getFirstChild());
                }
                element = document.createElement("feed_version");
                object.insertBefore(element, object.getFirstChild());
            }
            object = kyeroVersion.toXmlVersion();
            element.setTextContent((String)object);
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
        }
    }

    public Root toObject() throws JAXBException {
        this.upgradeToLatestVersion();
        return (Root)KyeroUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

