/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.kyero;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroVersion;
import org.openestate.io.kyero.xml.ObjectFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class KyeroUtils {
    private static JAXBContext JAXB = null;
    public static final KyeroVersion VERSION = KyeroVersion.V3;
    public static final String NAMESPACE = "";
    public static final String PACKAGE = "org.openestate.io.kyero.xml";
    public static final ObjectFactory FACTORY = new ObjectFactory();

    private KyeroUtils() {
    }

    public static KyeroDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return KyeroUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static KyeroDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return KyeroUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static KyeroDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return KyeroUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static KyeroDocument createDocument(Document document) {
        if (KyeroDocument.isReadable(document)) {
            return new KyeroDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return KyeroUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = KyeroUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = KyeroUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            KyeroUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getDateFormatAlternative() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static boolean isValidFeedVersionType(String string) {
        return string != null && string.length() > 0 && string.length() <= 3;
    }

    public static boolean isValidIdType(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isValidImageAttributeType(Integer n) {
        return n != null && n >= 0 && n <= 100;
    }

    public static boolean isValidImageUrlType(URL uRL) {
        if (uRL == null) {
            return false;
        }
        if (!"http".equals(uRL.getProtocol()) && !"ftp".equals(uRL.getProtocol())) {
            return false;
        }
        String string = StringUtils.trimToEmpty((String)uRL.getPath()).toLowerCase();
        return string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".png");
    }

    public static boolean isValidRefType(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isValidRequiredType(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isValidTypeDataType(String string) {
        return string != null && string.matches("([a-zA-Z&\\s\\(\\)/\\-]+)");
    }

    public static boolean isValidUrlDataType(URL uRL) {
        if (uRL == null) {
            return false;
        }
        if (!"http".equals(uRL.getProtocol())) {
            return false;
        }
        return uRL.toString().length() < 256;
    }

    public static Boolean parseBoolType(String string) {
        string = StringUtils.trimToNull((String)string);
        return DatatypeConverter.parseBoolean((String)string);
    }

    public static Calendar parseDateType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KyeroUtils.getDateFormat().parse(string));
            return calendar;
        }
        catch (ParseException parseException) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(KyeroUtils.getDateFormatAlternative().parse(string));
                return calendar;
            }
            catch (ParseException parseException2) {
                try {
                    return XmlUtils.parseDateTime((String)string);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Can't parse date-type value '" + string + "'!");
                }
            }
        }
    }

    public static BigDecimal parseDecimal(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static String parseFeedVersionType(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parseIdType(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static Integer parseImageAttributeType(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? Integer.valueOf(DatatypeConverter.parseInt((String)string)) : null;
    }

    public static URL parseImageUrlType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"http://") && !StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"https://")) {
                return new URL("http://" + string);
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Can't parse URL value '" + string + "'!", malformedURLException);
        }
    }

    public static BigInteger parseInteger(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseInteger((String)string) : null;
    }

    public static String parseLocationType(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static BigInteger parseNonNegativeInteger(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseInteger((String)string) : null;
    }

    public static Long parsePriceType(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null && !"x".equalsIgnoreCase(string) ? Long.valueOf(DatatypeConverter.parseLong((String)string)) : null;
    }

    public static String parseRefType(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parseRequiredType(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parseTypeDataType(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static URL parseUrlDataType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"http://") && !StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"https://")) {
                return new URL("http://" + string);
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Can't parse URL value '" + string + "'!", malformedURLException);
        }
    }

    public static String printBoolType(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "1";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "0";
        }
        throw new IllegalArgumentException("Can't print boolean value!");
    }

    public static String printDateType(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date value!");
        }
        return KyeroUtils.getDateFormat().format(calendar.getTime());
    }

    public static String printDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print decimal value '" + bigDecimal + "'!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printFeedVersionType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null || !KyeroUtils.isValidFeedVersionType(string)) {
            throw new IllegalArgumentException("Can't print feed-version value!");
        }
        return string;
    }

    public static String printIdType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null || !KyeroUtils.isValidIdType(string)) {
            throw new IllegalArgumentException("Can't print id value!");
        }
        return StringUtils.abbreviate((String)string, (int)50);
    }

    public static String printImageAttributeType(Integer n) {
        if (n == null || !KyeroUtils.isValidImageAttributeType(n)) {
            throw new IllegalArgumentException("Can't print image-attribute value!");
        }
        return DatatypeConverter.printInt((int)n);
    }

    public static String printImageUrlType(URL uRL) {
        if (uRL == null || !KyeroUtils.isValidImageUrlType(uRL)) {
            throw new IllegalArgumentException("Can't print image-url value!");
        }
        return uRL.toString();
    }

    public static String printInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Can't print integer value '" + bigInteger + "'!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printLocationType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            throw new IllegalArgumentException("Can't print location value!");
        }
        return StringUtils.abbreviate((String)string, (int)50);
    }

    public static String printNonNegativeInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("Can't print integer value '" + bigInteger + "'!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printPriceType(Long l) {
        return l != null ? DatatypeConverter.printLong((long)l) : "x";
    }

    public static String printRefType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null || !KyeroUtils.isValidRefType(string)) {
            throw new IllegalArgumentException("Can't print ref value!");
        }
        return StringUtils.abbreviate((String)string, (int)15);
    }

    public static String printRequiredType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null || !KyeroUtils.isValidRequiredType(string)) {
            throw new IllegalArgumentException("Can't print required value!");
        }
        return string;
    }

    public static String printTypeDataType(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null || !KyeroUtils.isValidTypeDataType(string)) {
            throw new IllegalArgumentException("Can't print type-data value!");
        }
        return string;
    }

    public static String printUrlDataType(URL uRL) {
        if (uRL == null || !KyeroUtils.isValidUrlDataType(uRL)) {
            throw new IllegalArgumentException("Can't print url-data value!");
        }
        return uRL.toString();
    }
}

