/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.kyero;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.kyero.xml.LangType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KyeroLanguage {
    AR,
    BG,
    CA,
    CS,
    DA,
    DE,
    EL,
    EN,
    ES,
    ET,
    FA,
    FI,
    FR,
    HE,
    HI,
    HU,
    ID,
    IT,
    JA,
    KO,
    LT,
    LV,
    NL,
    NO,
    PL,
    PT,
    RO,
    RU,
    SK,
    SL,
    SV,
    TH,
    TR,
    UK,
    VI,
    ZH;

    private static final Logger LOGGER;

    public static void clear(LangType langType) {
        for (KyeroLanguage kyeroLanguage : KyeroLanguage.values()) {
            kyeroLanguage.setText(langType, null);
        }
    }

    public static KyeroLanguage fromLanguageCode(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (KyeroLanguage kyeroLanguage : KyeroLanguage.values()) {
            if (!kyeroLanguage.name().equalsIgnoreCase(string)) continue;
            return kyeroLanguage;
        }
        return null;
    }

    public static KyeroLanguage fromLocale(Locale locale) {
        return locale != null ? KyeroLanguage.fromLanguageCode(locale.getLanguage()) : null;
    }

    public static KyeroLanguage[] getLanguages(LangType langType) {
        ArrayList<KyeroLanguage> arrayList = new ArrayList<KyeroLanguage>();
        if (StringUtils.isNotBlank((CharSequence)langType.getAr())) {
            arrayList.add(AR);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getBg())) {
            arrayList.add(BG);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getCa())) {
            arrayList.add(CA);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getCs())) {
            arrayList.add(CS);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getDa())) {
            arrayList.add(DA);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getDe())) {
            arrayList.add(DE);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getEl())) {
            arrayList.add(EL);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getEn())) {
            arrayList.add(EN);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getEs())) {
            arrayList.add(ES);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getEt())) {
            arrayList.add(ET);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getFa())) {
            arrayList.add(FA);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getFi())) {
            arrayList.add(FI);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getFr())) {
            arrayList.add(FR);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getHe())) {
            arrayList.add(HE);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getHi())) {
            arrayList.add(HI);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getHu())) {
            arrayList.add(HU);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getId())) {
            arrayList.add(ID);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getIt())) {
            arrayList.add(IT);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getJa())) {
            arrayList.add(JA);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getKo())) {
            arrayList.add(KO);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getLt())) {
            arrayList.add(LT);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getLv())) {
            arrayList.add(LV);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getNl())) {
            arrayList.add(NL);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getNo())) {
            arrayList.add(NO);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getPl())) {
            arrayList.add(PL);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getPt())) {
            arrayList.add(PT);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getRo())) {
            arrayList.add(RO);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getRu())) {
            arrayList.add(RU);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getSk())) {
            arrayList.add(SK);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getSl())) {
            arrayList.add(SL);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getSv())) {
            arrayList.add(SV);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getTh())) {
            arrayList.add(TH);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getTr())) {
            arrayList.add(TR);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getUk())) {
            arrayList.add(UK);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getVi())) {
            arrayList.add(VI);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getZh())) {
            arrayList.add(ZH);
        }
        return arrayList.toArray(new KyeroLanguage[arrayList.size()]);
    }

    public String getText(LangType langType) {
        if (langType == null) {
            return null;
        }
        switch (this) {
            case AR: {
                return StringUtils.trimToNull((String)langType.getAr());
            }
            case BG: {
                return StringUtils.trimToNull((String)langType.getBg());
            }
            case CA: {
                return StringUtils.trimToNull((String)langType.getCa());
            }
            case CS: {
                return StringUtils.trimToNull((String)langType.getCs());
            }
            case DA: {
                return StringUtils.trimToNull((String)langType.getDa());
            }
            case DE: {
                return StringUtils.trimToNull((String)langType.getDe());
            }
            case EL: {
                return StringUtils.trimToNull((String)langType.getEl());
            }
            case EN: {
                return StringUtils.trimToNull((String)langType.getEn());
            }
            case ES: {
                return StringUtils.trimToNull((String)langType.getEs());
            }
            case ET: {
                return StringUtils.trimToNull((String)langType.getEt());
            }
            case FA: {
                return StringUtils.trimToNull((String)langType.getFa());
            }
            case FI: {
                return StringUtils.trimToNull((String)langType.getFi());
            }
            case FR: {
                return StringUtils.trimToNull((String)langType.getFr());
            }
            case HE: {
                return StringUtils.trimToNull((String)langType.getHe());
            }
            case HI: {
                return StringUtils.trimToNull((String)langType.getHi());
            }
            case HU: {
                return StringUtils.trimToNull((String)langType.getHu());
            }
            case ID: {
                return StringUtils.trimToNull((String)langType.getId());
            }
            case IT: {
                return StringUtils.trimToNull((String)langType.getIt());
            }
            case JA: {
                return StringUtils.trimToNull((String)langType.getJa());
            }
            case KO: {
                return StringUtils.trimToNull((String)langType.getKo());
            }
            case LT: {
                return StringUtils.trimToNull((String)langType.getLt());
            }
            case LV: {
                return StringUtils.trimToNull((String)langType.getLv());
            }
            case NL: {
                return StringUtils.trimToNull((String)langType.getNl());
            }
            case NO: {
                return StringUtils.trimToNull((String)langType.getNo());
            }
            case PL: {
                return StringUtils.trimToNull((String)langType.getPl());
            }
            case PT: {
                return StringUtils.trimToNull((String)langType.getPt());
            }
            case RO: {
                return StringUtils.trimToNull((String)langType.getRo());
            }
            case RU: {
                return StringUtils.trimToNull((String)langType.getRu());
            }
            case SK: {
                return StringUtils.trimToNull((String)langType.getSk());
            }
            case SL: {
                return StringUtils.trimToNull((String)langType.getSl());
            }
            case SV: {
                return StringUtils.trimToNull((String)langType.getSv());
            }
            case TH: {
                return StringUtils.trimToNull((String)langType.getTh());
            }
            case TR: {
                return StringUtils.trimToNull((String)langType.getTr());
            }
            case UK: {
                return StringUtils.trimToNull((String)langType.getUk());
            }
            case VI: {
                return StringUtils.trimToNull((String)langType.getVi());
            }
            case ZH: {
                return StringUtils.trimToNull((String)langType.getZh());
            }
        }
        LOGGER.warn("unsupported language: " + (Object)((Object)this));
        return null;
    }

    public static String getText(LangType langType, KyeroLanguage kyeroLanguage) {
        return kyeroLanguage != null ? kyeroLanguage.getText(langType) : null;
    }

    public void setText(LangType langType, String string) {
        if (langType == null) {
            return;
        }
        switch (this) {
            case AR: {
                langType.setAr(StringUtils.trimToNull((String)string));
                break;
            }
            case BG: {
                langType.setBg(StringUtils.trimToNull((String)string));
                break;
            }
            case CA: {
                langType.setCa(StringUtils.trimToNull((String)string));
                break;
            }
            case CS: {
                langType.setCs(StringUtils.trimToNull((String)string));
                break;
            }
            case DA: {
                langType.setDa(StringUtils.trimToNull((String)string));
                break;
            }
            case DE: {
                langType.setDe(StringUtils.trimToNull((String)string));
                break;
            }
            case EL: {
                langType.setEl(StringUtils.trimToNull((String)string));
                break;
            }
            case EN: {
                langType.setEn(StringUtils.trimToNull((String)string));
                break;
            }
            case ES: {
                langType.setEs(StringUtils.trimToNull((String)string));
                break;
            }
            case ET: {
                langType.setEt(StringUtils.trimToNull((String)string));
                break;
            }
            case FA: {
                langType.setFa(StringUtils.trimToNull((String)string));
                break;
            }
            case FI: {
                langType.setFi(StringUtils.trimToNull((String)string));
                break;
            }
            case FR: {
                langType.setFr(StringUtils.trimToNull((String)string));
                break;
            }
            case HE: {
                langType.setHe(StringUtils.trimToNull((String)string));
                break;
            }
            case HI: {
                langType.setHi(StringUtils.trimToNull((String)string));
                break;
            }
            case HU: {
                langType.setHu(StringUtils.trimToNull((String)string));
                break;
            }
            case ID: {
                langType.setId(StringUtils.trimToNull((String)string));
                break;
            }
            case IT: {
                langType.setIt(StringUtils.trimToNull((String)string));
                break;
            }
            case JA: {
                langType.setJa(StringUtils.trimToNull((String)string));
                break;
            }
            case KO: {
                langType.setKo(StringUtils.trimToNull((String)string));
                break;
            }
            case LT: {
                langType.setLt(StringUtils.trimToNull((String)string));
                break;
            }
            case LV: {
                langType.setLv(StringUtils.trimToNull((String)string));
                break;
            }
            case NL: {
                langType.setNl(StringUtils.trimToNull((String)string));
                break;
            }
            case NO: {
                langType.setNo(StringUtils.trimToNull((String)string));
                break;
            }
            case PL: {
                langType.setPl(StringUtils.trimToNull((String)string));
                break;
            }
            case PT: {
                langType.setPt(StringUtils.trimToNull((String)string));
                break;
            }
            case RO: {
                langType.setRo(StringUtils.trimToNull((String)string));
                break;
            }
            case RU: {
                langType.setRu(StringUtils.trimToNull((String)string));
                break;
            }
            case SK: {
                langType.setSk(StringUtils.trimToNull((String)string));
                break;
            }
            case SL: {
                langType.setSl(StringUtils.trimToNull((String)string));
                break;
            }
            case SV: {
                langType.setSv(StringUtils.trimToNull((String)string));
                break;
            }
            case TH: {
                langType.setTh(StringUtils.trimToNull((String)string));
                break;
            }
            case TR: {
                langType.setTr(StringUtils.trimToNull((String)string));
                break;
            }
            case UK: {
                langType.setUk(StringUtils.trimToNull((String)string));
                break;
            }
            case VI: {
                langType.setVi(StringUtils.trimToNull((String)string));
                break;
            }
            case ZH: {
                langType.setZh(StringUtils.trimToNull((String)string));
                break;
            }
            default: {
                LOGGER.warn("unsupported language: " + (Object)((Object)this));
            }
        }
    }

    public static void setText(LangType langType, String string, KyeroLanguage kyeroLanguage) {
        if (kyeroLanguage != null) {
            kyeroLanguage.setText(langType, string);
        }
    }

    public String toLanguageCode() {
        return this.name().toLowerCase();
    }

    public Locale toLocale() {
        return LocaleUtils.toLocale((String)this.toLanguageCode());
    }

    static {
        LOGGER = LoggerFactory.getLogger(KyeroLanguage.class);
    }
}

