/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.kyero;

import org.apache.commons.lang3.ArrayUtils;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.converters.Kyero_2_1;
import org.openestate.io.kyero.converters.Kyero_3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KyeroVersion implements XmlVersion
{
    V2_1(Kyero_2_1.class, "2_1", "2.1", new String[0]),
    V3(Kyero_3.class, "3", "3", "3.0", "3.1");

    private static final Logger LOGGER;
    private final Class converterClass;
    private final String xmlVersion;
    private final String readableVersion;
    private final String[] alias;

    private KyeroVersion(Class clazz, String string2, String string3, String ... stringArray) {
        this.converterClass = clazz;
        this.xmlVersion = string2;
        this.readableVersion = string3;
        this.alias = stringArray;
    }

    public static KyeroVersion detectFromString(String string) {
        if (string != null) {
            for (KyeroVersion kyeroVersion : KyeroVersion.values()) {
                if (kyeroVersion.toXmlVersion().equalsIgnoreCase(string)) {
                    return kyeroVersion;
                }
                if (kyeroVersion.toReadableVersion().equalsIgnoreCase(string)) {
                    return kyeroVersion;
                }
                if (kyeroVersion.alias == null) continue;
                for (String string2 : kyeroVersion.alias) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    return kyeroVersion;
                }
            }
        }
        return null;
    }

    public XmlConverter getConverter() {
        try {
            return (XmlConverter)this.converterClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("Can't create converter!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public KyeroVersion getNextVersion() {
        KyeroVersion[] kyeroVersionArray = KyeroVersion.values();
        int n = ArrayUtils.indexOf((Object[])kyeroVersionArray, (Object)((Object)this));
        return kyeroVersionArray.length > ++n ? kyeroVersionArray[n] : null;
    }

    public KyeroVersion getPreviousVersion() {
        KyeroVersion[] kyeroVersionArray = KyeroVersion.values();
        int n = ArrayUtils.indexOf((Object[])kyeroVersionArray, (Object)((Object)this));
        return --n >= 0 ? kyeroVersionArray[n] : null;
    }

    public boolean isLatestVersion() {
        return KyeroUtils.VERSION.equals((Object)this);
    }

    public boolean isNewerThen(XmlVersion xmlVersion) {
        KyeroVersion[] kyeroVersionArray = KyeroVersion.values();
        return ArrayUtils.indexOf((Object[])kyeroVersionArray, (Object)((Object)this)) > ArrayUtils.indexOf((Object[])kyeroVersionArray, (Object)xmlVersion);
    }

    public boolean isOlderThen(XmlVersion xmlVersion) {
        KyeroVersion[] kyeroVersionArray = KyeroVersion.values();
        return ArrayUtils.indexOf((Object[])kyeroVersionArray, (Object)((Object)this)) < ArrayUtils.indexOf((Object[])kyeroVersionArray, (Object)xmlVersion);
    }

    public String toReadableVersion() {
        return this.readableVersion;
    }

    public String toXmlVersion() {
        return this.xmlVersion;
    }

    static {
        LOGGER = LoggerFactory.getLogger(KyeroVersion.class);
    }
}

