/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.converters.OpenImmo_1_1;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_0;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_1;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_2;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_3;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_4;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_5;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_6;
import org.openestate.io.openimmo.converters.OpenImmo_1_2_7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OpenImmoVersion implements XmlVersion
{
    V1_1(OpenImmo_1_1.class, "1.1", "1.1.0"),
    V1_2_0(OpenImmo_1_2_0.class, "1.2", "1.2.0"),
    V1_2_1(OpenImmo_1_2_1.class, "1.2.1", new String[0]),
    V1_2_2(OpenImmo_1_2_2.class, "1.2.2", new String[0]),
    V1_2_3(OpenImmo_1_2_3.class, "1.2.3", new String[0]),
    V1_2_4(OpenImmo_1_2_4.class, "1.2.4", new String[0]),
    V1_2_5(OpenImmo_1_2_5.class, "1.2.5", new String[0]),
    V1_2_6(OpenImmo_1_2_6.class, "1.2.6", new String[0]),
    V1_2_7(OpenImmo_1_2_7.class, "1.2.7", new String[0]);

    private static final Logger LOGGER;
    private final Class converterClass;
    private final String readableVersion;
    private final String[] alias;

    private OpenImmoVersion(Class clazz, String string2, String ... stringArray) {
        this.converterClass = clazz;
        this.readableVersion = string2;
        this.alias = stringArray;
    }

    public static OpenImmoVersion detectFromString(String string) {
        if (string != null) {
            String[] stringArray = StringUtils.split((String)string, (String)"/");
            for (OpenImmoVersion openImmoVersion : OpenImmoVersion.values()) {
                if (openImmoVersion.toReadableVersion().equalsIgnoreCase(stringArray[0])) {
                    return openImmoVersion;
                }
                if (openImmoVersion.alias == null) continue;
                for (String string2 : openImmoVersion.alias) {
                    if (!string2.equalsIgnoreCase(stringArray[0])) continue;
                    return openImmoVersion;
                }
            }
        }
        return null;
    }

    public XmlConverter getConverter() {
        try {
            return (XmlConverter)this.converterClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("Can't create converter!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public OpenImmoVersion getNextVersion() {
        OpenImmoVersion[] openImmoVersionArray = OpenImmoVersion.values();
        int n = ArrayUtils.indexOf((Object[])openImmoVersionArray, (Object)((Object)this));
        return openImmoVersionArray.length > ++n ? openImmoVersionArray[n] : null;
    }

    public OpenImmoVersion getPreviousVersion() {
        OpenImmoVersion[] openImmoVersionArray = OpenImmoVersion.values();
        int n = ArrayUtils.indexOf((Object[])openImmoVersionArray, (Object)((Object)this));
        return --n >= 0 ? openImmoVersionArray[n] : null;
    }

    public boolean isLatestVersion() {
        return OpenImmoUtils.VERSION.equals((Object)this);
    }

    public boolean isNewerThen(XmlVersion xmlVersion) {
        OpenImmoVersion[] openImmoVersionArray = OpenImmoVersion.values();
        return ArrayUtils.indexOf((Object[])openImmoVersionArray, (Object)((Object)this)) > ArrayUtils.indexOf((Object[])openImmoVersionArray, (Object)xmlVersion);
    }

    public boolean isOlderThen(XmlVersion xmlVersion) {
        OpenImmoVersion[] openImmoVersionArray = OpenImmoVersion.values();
        return ArrayUtils.indexOf((Object[])openImmoVersionArray, (Object)((Object)this)) < ArrayUtils.indexOf((Object[])openImmoVersionArray, (Object)xmlVersion);
    }

    public String toReadableVersion() {
        return this.readableVersion;
    }

    static {
        LOGGER = LoggerFactory.getLogger(OpenImmoVersion.class);
    }
}

