/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenImmo_1_2_1
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_1.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_1;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_0);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.removeObjektartZusatzElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <objektart_zusatz> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeHausElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <haus> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        try {
            this.downgradeXmlNamespace(openImmoDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't downgrade the XML namespace!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_1);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.upgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        try {
            this.upgradeXmlNamespace(openImmoDocument.getDocument());
        }
        catch (Exception exception) {
            LOGGER.error("Can't upgrade the XML namespace!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected void downgradeEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:energiepass", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element;
            String string;
            Node node;
            Element element2 = (Element)e;
            boolean bl = false;
            String string2 = XmlUtils.newXPath((String)"io:art/text()", (Document)document).stringValueOf((Object)element2);
            List list2 = XmlUtils.newXPath((String)"io:mitwarmwasser", (Document)document).selectNodes((Object)element2);
            for (Object e2 : list2) {
                node = (Node)e2;
                node.getParentNode().removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:energieverbrauchkennwert", (Document)document).selectNodes((Object)element2);
            for (Object e2 : list2) {
                node = (Node)e2;
                string = StringUtils.trimToNull((String)node.getTextContent());
                if (!bl && "VERBRAUCH".equalsIgnoreCase(string2) && string != null) {
                    bl = true;
                    element = document.createElementNS("http://www.openimmo.de", "skala");
                    element.setAttribute("type", "ZAHL");
                    element.setTextContent(string);
                    element2.appendChild(element);
                }
                node.getParentNode().removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:endenergiebedarf", (Document)document).selectNodes((Object)element2);
            for (Object e2 : list2) {
                node = (Node)e2;
                string = StringUtils.trimToNull((String)node.getTextContent());
                if (!bl && "BEDARF".equalsIgnoreCase(string2) && string != null) {
                    bl = true;
                    element = document.createElementNS("http://www.openimmo.de", "skala");
                    element.setAttribute("type", "ZAHL");
                    element.setTextContent(string);
                    element2.appendChild(element);
                    Element element3 = document.createElementNS("http://www.openimmo.de", "energiebedarf");
                    element3.setTextContent(string);
                    element2.appendChild(element3);
                }
                node.getParentNode().removeChild(node);
            }
        }
    }

    protected void downgradeHausElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:haus[@haustyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("haustyp"));
            if (!"BUNGALOW".equalsIgnoreCase(string)) continue;
            element.removeAttribute("haustyp");
        }
    }

    protected void downgradeXmlNamespace(Document document) throws JaxenException {
        XmlUtils.replaceNamespace((Document)document, (String)"http://www.openimmo.de");
    }

    protected void removeObjektartZusatzElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:objektart_zusatz", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void upgradeEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:energiepass", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Object object;
            Node node;
            Object object22;
            Element element = (Element)e;
            String string = null;
            String string2 = null;
            Element element2 = (Element)XmlUtils.newXPath((String)"io:art", (Document)document).selectSingleNode((Object)element);
            String string3 = element2 != null ? StringUtils.trimToNull((String)element2.getTextContent()) : null;
            List list2 = XmlUtils.newXPath((String)"io:heizwert", (Document)document).selectNodes((Object)element);
            for (Object object22 : list2) {
                node = (Node)object22;
                node.getParentNode().removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:energiebedarf", (Document)document).selectNodes((Object)element);
            for (Object object22 : list2) {
                node = (Node)object22;
                if (string == null) {
                    string = StringUtils.trimToNull((String)node.getTextContent());
                }
                node.getParentNode().removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:skala", (Document)document).selectNodes((Object)element);
            for (Object object22 : list2) {
                node = (Element)object22;
                if (string2 == null && "ZAHL".equalsIgnoreCase(node.getAttribute("type"))) {
                    string2 = StringUtils.trimToNull((String)node.getTextContent());
                }
                node.getParentNode().removeChild(node);
            }
            if (element2 != null && "VERBRAUCH".equalsIgnoreCase(string3)) {
                element2.setTextContent("VERBRAUCH");
                object = string2;
                if (object == null) continue;
                object22 = document.createElementNS("", "energieverbrauchkennwert");
                object22.setTextContent((String)object);
                element.appendChild((Node)object22);
                continue;
            }
            if (element2 == null || !"BEDARF".equalsIgnoreCase(string3)) continue;
            element2.setTextContent("BEDARF");
            object = string != null ? string : string2;
            if (object == null) continue;
            object22 = document.createElementNS("", "endenergiebedarf");
            object22.setTextContent((String)object);
            element.appendChild((Node)object22);
        }
    }

    protected void upgradeXmlNamespace(Document document) {
        XmlUtils.replaceNamespace((Document)document, (String)"");
    }
}

