/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenImmo_1_2_7
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_7.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_7;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_6);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.removeMultipleEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove odd <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeObjektTextElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove odd <objekt_text> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeSummemietenettoElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <summemietenetto> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBefeuerungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <befeuerung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeAnhangElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <anhang> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeAktionElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <aktion> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_7);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.upgradeSummemietenettoElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <summemietenetto> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.upgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    protected void downgradeAktionElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:verwaltung_techn/io:aktion[@aktionart]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("aktionart"));
            if (!"REFERENZ".equalsIgnoreCase(string)) continue;
            element.setAttribute("aktionart", "CHANGE");
        }
    }

    protected void downgradeAnhangElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:anhang[@gruppe] | /io:openimmo/io:anbieter/io:immobilie/io:anhaenge/io:anhang[@gruppe]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("gruppe"));
            if ("EPASS-SKALA".equalsIgnoreCase(string)) {
                element.removeAttribute("gruppe");
                continue;
            }
            if (!"ANBOBJURL".equalsIgnoreCase(string)) continue;
            element.removeAttribute("gruppe");
        }
    }

    protected void downgradeBefeuerungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:befeuerung[@KOHLE or @HOLZ or @FLUESSIGGAS]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("KOHLE");
            element.removeAttribute("HOLZ");
            element.removeAttribute("FLUESSIGGAS");
        }
    }

    protected void downgradeEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:energiepass", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            String string;
            Node node;
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            List list2 = XmlUtils.newXPath((String)"io:primaerenergietraeger", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:epasstext", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:stromwert", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_stromwert", string));
                    bl = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:waermewert", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl2 && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_waermewert", string));
                    bl2 = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:wertklasse", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl3 && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_wertklasse", string));
                    bl3 = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:baujahr", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl4 && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_baujahr", string));
                    bl4 = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:ausstelldatum", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl5 && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_ausstelldatum", string));
                    bl5 = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:jahrgang", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl6 && ("2008".equalsIgnoreCase(string = StringUtils.trimToNull((String)node.getTextContent())) || "2014".equalsIgnoreCase(string) || "ohne".equalsIgnoreCase(string))) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_jahrgang", string));
                    bl6 = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:gebaeudeart", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl7 && ("wohn".equalsIgnoreCase(string = StringUtils.trimToNull((String)node.getTextContent())) || "nichtwohn".equalsIgnoreCase(string) || "ohne".equalsIgnoreCase(string))) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_gebaeudeart", string));
                    bl7 = true;
                }
                element.removeChild(node);
            }
        }
    }

    protected void downgradeSummemietenettoElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:summemietenetto[@summemieteust]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("summemieteust"));
            if (string != null) {
                element.setAttribute("sonstigemieteust", string);
            }
            element.removeAttribute("summemieteust");
        }
    }

    protected void removeMultipleEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            List list2 = XmlUtils.newXPath((String)"io:energiepass", (Document)document).selectNodes((Object)element);
            if (list2.size() < 2) continue;
            for (int i = 1; i < list2.size(); ++i) {
                element.removeChild((Node)list2.get(i));
            }
        }
    }

    protected void removeObjektTextElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:freitexte/io:objekt_text", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void upgradeEnergiepassElements(Document document) throws JaxenException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("stromwert", "user_defined_simplefield[@feldname='epass_stromwert']");
        hashMap.put("waermewert", "user_defined_simplefield[@feldname='epass_waermewert']");
        hashMap.put("wertklasse", "user_defined_simplefield[@feldname='epass_wertklasse']");
        hashMap.put("baujahr", "user_defined_simplefield[@feldname='epass_baujahr']");
        hashMap.put("ausstelldatum", "user_defined_simplefield[@feldname='epass_ausstelldatum']");
        hashMap.put("jahrgang", "user_defined_simplefield[@feldname='epass_jahrgang']");
        hashMap.put("gebaeudeart", "user_defined_simplefield[@feldname='epass_gebaeudeart']");
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)XmlUtils.newXPath((String)"io:energiepass", (Document)document).selectSingleNode((Object)element);
            if (element2 == null) {
                element2 = document.createElementNS("", "energiepass");
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                boolean bl = false;
                List list2 = XmlUtils.newXPath((String)((String)entry.getValue()), (Document)document).selectNodes((Object)element);
                for (Object e2 : list2) {
                    String string;
                    Node node = (Node)e2;
                    if (!bl && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                        Element element3 = document.createElementNS("", (String)entry.getKey());
                        element3.setTextContent(string);
                        element2.appendChild(element3);
                        bl = true;
                    }
                    element.removeChild(node);
                }
            }
            if (element2.getParentNode() != null || !element2.hasChildNodes()) continue;
            element.appendChild(element2);
        }
    }

    protected void upgradeSummemietenettoElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:summemietenetto[@sonstigemieteust]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("sonstigemieteust"));
            if (string != null) {
                element.setAttribute("summemieteust", string);
            }
            element.removeAttribute("sonstigemieteust");
        }
    }
}

