/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.wis_it;

import java.math.BigInteger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.openestate.io.core.XmlDocument;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.wis_it.WisItUtils;
import org.openestate.io.wis_it.xml.WIS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WisItDocument
extends XmlDocument<WIS> {
    public WisItDocument(Document document) {
        super(document);
        if (!WisItDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
        this.setTextWrittenAsCDATA(true);
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "WIS".equals(element.getLocalName());
    }

    public static WisItDocument newDocument() throws ParserConfigurationException, JAXBException {
        return WisItDocument.newDocument(WisItUtils.getFactory().createWIS());
    }

    public static WisItDocument newDocument(WIS wIS) throws ParserConfigurationException, JAXBException {
        if (wIS.getOBJEKTE() == null) {
            wIS.setOBJEKTE(WisItUtils.getFactory().createWISOBJEKTE());
        }
        wIS.getOBJEKTE().setANZAHL(BigInteger.valueOf(wIS.getOBJEKTE().getOBJEKT().size()));
        Document document = XmlUtils.newDocument();
        WisItUtils.createMarshaller("UTF-8", true).marshal((Object)wIS, (Node)document);
        return new WisItDocument(document);
    }

    public WIS toObject() throws JAXBException {
        return (WIS)WisItUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

