/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomStringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomStringUtils.class);
    private static final CharacterPredicate NUMBERS = new CharacterPredicate(){

        public boolean test(int n) {
            return n >= 48 && n <= 57;
        }
    };
    private static final CharacterPredicate LETTERS = new CharacterPredicate(){

        public boolean test(int n) {
            return n >= 65 && n <= 90 || n >= 97 && n <= 122;
        }
    };

    private RandomStringUtils() {
    }

    public static String random(int n) {
        return new RandomStringGenerator.Builder().filteredBy(new CharacterPredicate[]{NUMBERS, LETTERS}).build().generate(n);
    }

    public static String randomLetters(int n) {
        return new RandomStringGenerator.Builder().filteredBy(new CharacterPredicate[]{LETTERS}).build().generate(n);
    }

    public static String randomNumeric(int n) {
        return new RandomStringGenerator.Builder().filteredBy(new CharacterPredicate[]{NUMBERS}).build().generate(n);
    }
}

