/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import oauth.signpost.exception.OAuthException;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.ImportExport;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRealEstateExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadRealEstateExample.class);
    private static final String WEBSERVICE_URL = "https://rest.immobilienscout24.de/restapi";
    private static final String CONSUMER_KEY = "my consumer key";
    private static final String CONSUMER_SECRET = "my consumer secret";
    private static final String ACCESS_KEY = "user's access key";
    private static final String ACCESS_SECRET = "user's access secret";
    private static final long is24ObjectId = 123L;
    private static final String externalObjectId = "123";

    public static void main(String[] stringArray) {
        String string;
        RealEstate realEstate;
        DefaultClient defaultClient = new DefaultClient(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET);
        try {
            defaultClient.authorize(ACCESS_KEY, ACCESS_SECRET);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        try {
            System.out.println("------------------");
            System.out.println("Get object with IS24-ID 123");
            realEstate = ImportExport.RealEstateService.getByIs24Id((AbstractClient)defaultClient, (long)123L);
            if (realEstate == null) {
                System.out.println("Can't find object for IS24-ID 123!");
            } else {
                string = XmlUtils.marshal((Object)realEstate, (String)"UTF-8", (boolean)true);
                System.out.println("title '" + realEstate.getTitle() + "'");
                System.out.println(string);
            }
        }
        catch (RequestFailedException requestFailedException) {
            throw new RuntimeException("Request failed with '" + requestFailedException.statusMessage + "' (" + requestFailedException.statusCode + ")!", requestFailedException);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("XML processing failed!", jAXBException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Communication failed!", iOException);
        }
        try {
            System.out.println("------------------");
            System.out.println("Get object with external ID 123");
            realEstate = ImportExport.RealEstateService.getByExternalId((AbstractClient)defaultClient, (String)externalObjectId);
            if (realEstate == null) {
                System.out.println("Can't find object for external ID 123!");
            } else {
                string = XmlUtils.marshal((Object)realEstate, (String)"UTF-8", (boolean)true);
                System.out.println("title '" + realEstate.getTitle() + "'");
                System.out.println(string);
            }
        }
        catch (RequestFailedException requestFailedException) {
            throw new RuntimeException("Request failed with '" + requestFailedException.statusMessage + "' (" + requestFailedException.statusCode + ")!", requestFailedException);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("XML processing failed!", jAXBException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Communication failed!", iOException);
        }
    }
}

