/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import oauth.signpost.exception.OAuthException;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.ImportExport;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.offerlistelement.OfferRealEstateForList;
import org.openestate.is24.restapi.xml.realestates.RealEstates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRealEstateListExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadRealEstateListExample.class);
    private static final String WEBSERVICE_URL = "https://rest.immobilienscout24.de/restapi";
    private static final String CONSUMER_KEY = "my consumer key";
    private static final String CONSUMER_SECRET = "my consumer secret";
    private static final String ACCESS_KEY = "user's access key";
    private static final String ACCESS_SECRET = "user's access secret";

    public static void main(String[] stringArray) {
        RealEstates realEstates;
        DefaultClient defaultClient = new DefaultClient(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET);
        try {
            defaultClient.authorize(ACCESS_KEY, ACCESS_SECRET);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        int n = 0;
        do {
            ++n;
            try {
                realEstates = ImportExport.RealEstateService.getAll((AbstractClient)defaultClient, null, null, (int)10, (int)n, (boolean)true);
                for (OfferRealEstateForList offerRealEstateForList : realEstates.getRealEstateList().getRealEstateElement()) {
                    String string = XmlUtils.marshal((Object)offerRealEstateForList, (String)"UTF-8", (boolean)true);
                    System.out.println("object #" + offerRealEstateForList.getId() + "");
                    System.out.println("title '" + offerRealEstateForList.getTitle() + "'");
                    System.out.println(string);
                    System.out.println("------------------");
                }
            }
            catch (RequestFailedException requestFailedException) {
                throw new RuntimeException("Request failed with '" + requestFailedException.statusMessage + "' (" + requestFailedException.statusCode + ")!", requestFailedException);
            }
            catch (OAuthException oAuthException) {
                throw new RuntimeException("Authorization failed!", oAuthException);
            }
            catch (JAXBException jAXBException) {
                throw new RuntimeException("XML processing failed!", jAXBException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Communication failed!", iOException);
            }
        } while (realEstates.getPaging().getNumberOfPages() > (long)n);
    }
}

