/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBException;
import org.openestate.is24.restapi.utils.RandomRealEstateFactory;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomRealEstateExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomRealEstateExample.class);

    public static void main(String[] stringArray) {
        try {
            RandomRealEstateFactory randomRealEstateFactory = new RandomRealEstateFactory();
            Charset charset = Charset.forName("UTF-8");
            for (RandomRealEstateFactory.Type type : RandomRealEstateFactory.Type.values()) {
                System.out.println("----------------------------------------");
                System.out.println("example for " + type + ":");
                RealEstate realEstate = randomRealEstateFactory.createRandomObject(type);
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    XmlUtils.writeXml((RealEstate)realEstate, (String)charset.name(), (boolean)true, (OutputStream)byteArrayOutputStream);
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                    String string = charset.decode(byteBuffer).toString();
                    System.out.println(string.trim());
                }
            }
        }
        catch (IOException | JAXBException throwable) {
            System.err.println("XML error!");
            throwable.printStackTrace(System.err);
        }
    }
}

