/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import oauth.signpost.exception.OAuthException;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.utils.Authorization;
import org.openestate.is24.restapi.utils.Verification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerificationExample.class);
    private static final String WEBSERVICE_URL = "https://rest.immobilienscout24.de/restapi";
    private static final String CONSUMER_KEY = "my consumer key";
    private static final String CONSUMER_SECRET = "my consumer secret";
    private static final String CALLBACK_URL = "http://mywebsite.com/is24-callback.php";

    public static void main(String[] stringArray) {
        String string;
        BufferedReader bufferedReader;
        Verification verification;
        DefaultClient defaultClient = new DefaultClient(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET);
        try {
            verification = defaultClient.fetchVerification(CALLBACK_URL);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Can't fetch verification!", oAuthException);
        }
        System.out.println("Visit the following URL to verify access to an agency account at IS24:");
        System.out.println(verification.verificationUrl);
        System.out.println("Please enter your verification code: ");
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset().name()));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't read verification code!", iOException);
        }
        try {
            bufferedReader = defaultClient.authorizeAfterVerification(verification, string);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Can't fetch authorization!", oAuthException);
        }
        System.out.println("The access token was created.");
        System.out.println("token  : " + ((Authorization)bufferedReader).accessToken);
        System.out.println("secret : " + ((Authorization)bufferedReader).accessTokenSecret);
    }
}

