/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.ArrayUtils;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlReadingExample.class);
    private static final String ENCODING = "UTF-8";
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        Unmarshaller unmarshaller;
        if (ArrayUtils.isEmpty((Object[])stringArray)) {
            System.out.println("No files were specified for reading.");
        }
        try {
            unmarshaller = XmlUtils.createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("Can't build unmarshaller!", jAXBException);
        }
        for (String string : stringArray) {
            RealEstate realEstate;
            Object object;
            File file = new File(string);
            if (!file.isFile()) {
                System.out.println("The provided file '" + string + "' does not exist!");
                continue;
            }
            try {
                object = (JAXBElement)unmarshaller.unmarshal(file);
                realEstate = (RealEstate)object.getValue();
            }
            catch (JAXBException jAXBException) {
                throw new RuntimeException("Can't read XML file '" + file.getAbsolutePath() + "'!", jAXBException);
            }
            if (realEstate == null) {
                throw new RuntimeException("Can't read XML file '" + file.getAbsolutePath() + "'!");
            }
            try {
                object = XmlUtils.marshal((Object)realEstate, (String)ENCODING, (boolean)true);
                System.out.println("-----------------------------------");
                System.out.println("processed content of " + file.getAbsolutePath());
                System.out.println((String)object);
            }
            catch (IOException | JAXBException throwable) {
                throw new RuntimeException("Can't process XML file '" + file.getAbsolutePath() + "'!", throwable);
            }
        }
    }
}

