/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import org.openestate.is24.restapi.utils.RandomRealEstateFactory;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlWritingExample.class);
    private static final String ENCODING = "UTF-8";
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        Throwable throwable;
        FileOutputStream fileOutputStream;
        File file;
        RealtorContactDetails realtorContactDetails;
        RandomRealEstateFactory randomRealEstateFactory = new RandomRealEstateFactory();
        try {
            realtorContactDetails = randomRealEstateFactory.createRandomContact();
            file = File.createTempFile("example-contact-", ".xml");
            fileOutputStream = new FileOutputStream(file);
            throwable = null;
            try {
                XmlUtils.writeXml((RealtorContactDetails)realtorContactDetails, (String)ENCODING, (boolean)true, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileOutputStream != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
            }
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("Can't build XML file!", jAXBException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't write XML file!", iOException);
        }
        try {
            realtorContactDetails = randomRealEstateFactory.createRandomObject();
            file = File.createTempFile("example-object-", ".xml");
            fileOutputStream = new FileOutputStream(file);
            throwable = null;
            try {
                XmlUtils.writeXml((RealEstate)realtorContactDetails, (String)ENCODING, (boolean)true, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (fileOutputStream != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
            }
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("Can't build XML file!", jAXBException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't write XML file!", iOException);
        }
    }
}

