/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.IOException;
import java.math.BigDecimal;
import javax.xml.bind.JAXBException;
import oauth.signpost.exception.OAuthException;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.ImportExport;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.xml.common.BuildingEnergyRatingType;
import org.openestate.is24.restapi.xml.common.BuildingType;
import org.openestate.is24.restapi.xml.common.ConstructionPhaseType;
import org.openestate.is24.restapi.xml.common.Currency;
import org.openestate.is24.restapi.xml.common.HeatingTypeEnev2014;
import org.openestate.is24.restapi.xml.common.InteriorQuality;
import org.openestate.is24.restapi.xml.common.MarketingType;
import org.openestate.is24.restapi.xml.common.PriceIntervalType;
import org.openestate.is24.restapi.xml.common.RealEstateCondition;
import org.openestate.is24.restapi.xml.common.YesNoNotApplicableType;
import org.openestate.is24.restapi.xml.common.YesNotApplicableType;
import org.openestate.is24.restapi.xml.realestates.HouseBuy;
import org.openestate.is24.restapi.xml.realestates.ObjectFactory;
import org.openestate.is24.restapi.xml.realestates.RealEstate;

public class UploadRealEstateExample {
    private static final String WEBSERVICE_URL = "https://rest.immobilienscout24.de/restapi";
    private static final String CONSUMER_KEY = "my consumer key";
    private static final String CONSUMER_SECRET = "my consumer secret";
    private static final String ACCESS_KEY = "user's access key";
    private static final String ACCESS_SECRET = "user's access secret";

    public static void main(String[] stringArray) {
        DefaultClient defaultClient = new DefaultClient(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET);
        try {
            defaultClient.authorize(ACCESS_KEY, ACCESS_SECRET);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        ObjectFactory objectFactory2 = new ObjectFactory();
        HouseBuy houseBuy = objectFactory2.createHouseBuy();
        houseBuy.setExternalId("123");
        houseBuy.setGroupNumber(Integer.valueOf(1));
        houseBuy.setShowAddress(true);
        houseBuy.setAddress(objectFactory.createWgs84Address());
        houseBuy.getAddress().setStreet("Friedrichstra\u00dfe");
        houseBuy.getAddress().setHouseNumber("123");
        houseBuy.getAddress().setPostcode("12345");
        houseBuy.getAddress().setCity("Berlin");
        houseBuy.getAddress().setQuarter("Mitte");
        houseBuy.getAddress().setPreciseHouseNumber(Boolean.valueOf(true));
        houseBuy.getAddress().setWgs84Coordinate(objectFactory.createWgs84Coordinate());
        houseBuy.getAddress().getWgs84Coordinate().setLatitude(new BigDecimal("52.519444"));
        houseBuy.getAddress().getWgs84Coordinate().setLongitude(new BigDecimal("13.406667"));
        houseBuy.setTitle("a descriptive title for the object");
        houseBuy.setFurnishingNote("somes notes about furnishing");
        houseBuy.setLocationNote("somes notes about the location");
        houseBuy.setOtherNote("somes more notes");
        houseBuy.setPrice(objectFactory.createPrice());
        houseBuy.getPrice().setCurrency(Currency.EUR);
        houseBuy.getPrice().setMarketingType(MarketingType.PURCHASE);
        houseBuy.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        houseBuy.getPrice().setValue(new BigDecimal("749999.99"));
        houseBuy.setCourtage(objectFactory.createCourtageInfo());
        houseBuy.getCourtage().setCourtage("74999,99 EUR");
        houseBuy.getCourtage().setCourtageNote("10% of the purchase price");
        houseBuy.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        houseBuy.setContact(objectFactory2.createRealEstateContact());
        houseBuy.getContact().setExternalId("mycontact-123");
        houseBuy.setBuildingEnergyRatingType(BuildingEnergyRatingType.NO_INFORMATION);
        houseBuy.setBuildingType(BuildingType.MULTI_FAMILY_HOUSE);
        houseBuy.setCellar(YesNotApplicableType.YES);
        houseBuy.setCondition(RealEstateCondition.FIRST_TIME_USE_AFTER_REFURBISHMENT);
        houseBuy.setConstructionPhase(ConstructionPhaseType.NO_INFORMATION);
        houseBuy.setConstructionYear(Integer.valueOf(1973));
        houseBuy.setFreeFrom("from now on");
        houseBuy.setGuestToilet(YesNotApplicableType.YES);
        houseBuy.setHandicappedAccessible(YesNotApplicableType.NOT_APPLICABLE);
        houseBuy.setHeatingTypeEnev2014(HeatingTypeEnev2014.SOLAR_HEATING);
        houseBuy.setInteriorQuality(InteriorQuality.LUXURY);
        houseBuy.setLastRefurbishment(Integer.valueOf(1995));
        houseBuy.setListed(YesNotApplicableType.YES);
        houseBuy.setLivingSpace(new BigDecimal("123.45"));
        houseBuy.setNumberOfBathRooms(Integer.valueOf(2));
        houseBuy.setNumberOfBedRooms(Integer.valueOf(2));
        houseBuy.setNumberOfFloors(Integer.valueOf(3));
        houseBuy.setNumberOfParkingSpaces(Integer.valueOf(5));
        houseBuy.setNumberOfRooms(new BigDecimal("6"));
        houseBuy.setParkingSpacePrice(new BigDecimal("423"));
        houseBuy.setPlotArea(new BigDecimal("456.78"));
        houseBuy.setRentalIncome(new BigDecimal("54223.41"));
        houseBuy.setRented(YesNotApplicableType.YES);
        houseBuy.setSummerResidencePractical(YesNotApplicableType.YES);
        houseBuy.setUsableFloorSpace(new BigDecimal("456.78"));
        try {
            System.out.println("Send as new object to IS24");
            long l = ImportExport.RealEstateService.post((AbstractClient)defaultClient, (RealEstate)houseBuy);
            System.out.println("Object was created with IS24-ID #" + l);
            System.out.println("Send again as update to IS24");
            ImportExport.RealEstateService.putByIs24Id((AbstractClient)defaultClient, (RealEstate)houseBuy, (long)l);
            System.out.println("Remove object from IS24");
            ImportExport.RealEstateService.deleteByIs24Id((AbstractClient)defaultClient, (long)l);
        }
        catch (RequestFailedException requestFailedException) {
            throw new RuntimeException("Request failed with '" + requestFailedException.statusMessage + "' (" + requestFailedException.statusCode + ")!", requestFailedException);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("XML processing failed!", jAXBException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Communication failed!", iOException);
        }
    }
}

