/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.IOException;
import java.util.ArrayList;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.utils.ExportHandler;
import org.openestate.is24.restapi.utils.ExportPool;
import org.openestate.is24.restapi.utils.RandomRealEstateFactory;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.realestates.RealEstate;

public class BulkUploadExample {
    private static final String WEBSERVICE_URL = "https://rest.immobilienscout24.de/restapi";
    private static final String CONSUMER_KEY = "my consumer key";
    private static final String CONSUMER_SECRET = "my consumer secret";
    private static final String ACCESS_KEY = "user's access key";
    private static final String ACCESS_SECRET = "user's access secret";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        RandomRealEstateFactory randomRealEstateFactory = new RandomRealEstateFactory();
        ExportPool exportPool = new ExportPool();
        try {
            DefaultClient defaultClient;
            try {
                defaultClient = new ArrayList();
                int n = RandomUtils.nextInt((int)1, (int)5);
                for (int i = 0; i < n; ++i) {
                    RealtorContactDetails realtorContactDetails = randomRealEstateFactory.createRandomContact();
                    realtorContactDetails.setExternalId("TEST_" + i);
                    defaultClient.add(realtorContactDetails.getExternalId());
                    exportPool.putContact(realtorContactDetails);
                }
                for (RandomRealEstateFactory.Type type : RandomRealEstateFactory.Type.values()) {
                    RealEstate object = randomRealEstateFactory.createRandomObject(type);
                    object.setExternalId("TEST_" + type.name());
                    object.setContact(new RealEstate.Contact());
                    object.getContact().setExternalId((String)defaultClient.get(RandomUtils.nextInt((int)0, (int)defaultClient.size())));
                    exportPool.putObject(object);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't build export pool!", iOException);
            }
            defaultClient = new DefaultClient(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET);
            try {
                defaultClient.authorize(ACCESS_KEY, ACCESS_SECRET);
            }
            catch (OAuthException oAuthException) {
                throw new RuntimeException("Authorization failed!", oAuthException);
            }
            try {
                ExportHandler exportHandler = new ExportHandler();
                Object[] objectArray = exportHandler.export((AbstractClient)defaultClient, exportPool, true, false);
                if (ArrayUtils.isEmpty((Object[])objectArray)) {
                    System.out.println("No messages were received.");
                } else {
                    System.out.println(objectArray.length + " messages received.");
                    for (Object object : objectArray) {
                        String string = object.getLevel().name();
                        String string2 = object.getCode().name();
                        if (!StringUtils.isBlank((CharSequence)object.getObjectId())) {
                            System.out.println(string + " for real estate " + "'" + object.getObjectId() + "'");
                        } else if (!StringUtils.isBlank((CharSequence)object.getContactId())) {
                            System.out.println(string + " for contact person " + "'" + object.getContactId() + "'");
                        } else {
                            System.out.println("general " + string);
                        }
                        System.out.println("> " + string2);
                        System.out.println("> " + object.getMessage());
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't send export pool to the Webservice!", iOException);
            }
        }
        finally {
            exportPool.cleanup();
        }
    }
}

