/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import oauth.signpost.exception.OAuthException;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.GIS;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.common.City;
import org.openestate.is24.restapi.xml.common.Continent;
import org.openestate.is24.restapi.xml.common.Country;
import org.openestate.is24.restapi.xml.common.Quarter;
import org.openestate.is24.restapi.xml.common.Region;
import org.openestate.is24.restapi.xml.gis.Cities;
import org.openestate.is24.restapi.xml.gis.Continents;
import org.openestate.is24.restapi.xml.gis.Countries;
import org.openestate.is24.restapi.xml.gis.Quarters;
import org.openestate.is24.restapi.xml.gis.Regions;

public class GISExample {
    private static final String WEBSERVICE_URL = "https://rest.immobilienscout24.de/restapi";
    private static final String CONSUMER_KEY = "my consumer key";
    private static final String CONSUMER_SECRET = "my consumer secret";
    private static final String ACCESS_KEY = "user's access key";
    private static final String ACCESS_SECRET = "user's access secret";
    private static final int EUROPE = 1;
    private static final int GERMANY = 276;

    public static void main(String[] stringArray) {
        DefaultClient defaultClient = new DefaultClient(WEBSERVICE_URL, CONSUMER_KEY, CONSUMER_SECRET);
        try {
            defaultClient.authorize(ACCESS_KEY, ACCESS_SECRET);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        try {
            System.out.println("------------------");
            System.out.println("Get continents");
            Continents continents = GIS.ContinentService.getAll((AbstractClient)defaultClient);
            if (continents == null) {
                System.out.println("Can't find continents!");
                return;
            }
            String string = XmlUtils.marshal((Object)continents, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            System.out.println("------------------");
            System.out.println("Get continent #1");
            Continent continent = GIS.ContinentService.get((AbstractClient)defaultClient, (long)1L);
            if (continent == null) {
                System.out.println("Can't find continent!");
                return;
            }
            string = XmlUtils.marshal((Object)continent, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            System.out.println("------------------");
            System.out.println("Get countries for continent #1");
            Countries countries = GIS.CountryService.getAll((AbstractClient)defaultClient, (long)1L);
            if (countries == null) {
                System.out.println("Can't find countries!");
                return;
            }
            string = XmlUtils.marshal((Object)countries, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            System.out.println("------------------");
            System.out.println("Get country #276");
            Country country = GIS.CountryService.get((AbstractClient)defaultClient, (long)1L, (long)276L);
            if (country == null) {
                System.out.println("Can't find country!");
                return;
            }
            string = XmlUtils.marshal((Object)country, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            System.out.println("------------------");
            System.out.println("Get regions for country #276");
            Regions regions = GIS.RegionService.getAll((AbstractClient)defaultClient, (long)1L, (long)276L);
            if (regions == null) {
                System.out.println("Can't find regions!");
                return;
            }
            string = XmlUtils.marshal((Object)regions, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            long l = ((Regions.Region)regions.getRegion().get(0)).getId();
            System.out.println("------------------");
            System.out.println("Get region #" + l);
            Region region = GIS.RegionService.get((AbstractClient)defaultClient, (long)1L, (long)276L, (long)l);
            if (region == null) {
                System.out.println("Can't find region!");
                return;
            }
            string = XmlUtils.marshal((Object)region, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            System.out.println("------------------");
            System.out.println("Get cities for region #" + l);
            Cities cities = GIS.CityService.getAll((AbstractClient)defaultClient, (long)1L, (long)276L, (long)l);
            if (cities == null) {
                System.out.println("Can't find cities!");
                return;
            }
            string = XmlUtils.marshal((Object)cities, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            long l2 = ((Cities.City)cities.getCity().get(0)).getId();
            System.out.println("------------------");
            System.out.println("Get city #" + l2);
            City city = GIS.CityService.get((AbstractClient)defaultClient, (long)1L, (long)276L, (long)l, (long)l2);
            if (city == null) {
                System.out.println("Can't find city!");
                return;
            }
            string = XmlUtils.marshal((Object)city, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            System.out.println("------------------");
            System.out.println("Get quarters for city #" + l2);
            Quarters quarters = GIS.QuarterService.getAll((AbstractClient)defaultClient, (long)1L, (long)276L, (long)l, (long)l2);
            if (quarters == null) {
                System.out.println("Can't find quarters!");
                return;
            }
            string = XmlUtils.marshal((Object)quarters, (String)"UTF-8", (boolean)true);
            System.out.println(string);
            long l3 = ((Quarters.Quarter)quarters.getQuarter().get(0)).getId();
            System.out.println("------------------");
            System.out.println("Get quarter #" + l3);
            Quarter quarter = GIS.QuarterService.get((AbstractClient)defaultClient, (long)1L, (long)276L, (long)l, (long)l2, (long)l3);
            if (quarter == null) {
                System.out.println("Can't find quarter!");
                return;
            }
            string = XmlUtils.marshal((Object)quarter, (String)"UTF-8", (boolean)true);
            System.out.println(string);
        }
        catch (RequestFailedException requestFailedException) {
            throw new RuntimeException("Request failed with '" + requestFailedException.statusMessage + "' (" + requestFailedException.statusCode + ")!", requestFailedException);
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException("Authorization failed!", oAuthException);
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("XML processing failed!", jAXBException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Communication failed!", iOException);
        }
    }
}

