/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.openestate.is24.restapi.utils.RandomRealEstateFactory;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.realestates.RealEstate;

public class XmlWritingExample {
    private static final String ENCODING = "UTF-8";
    private static final boolean PRETTY_PRINT = true;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        RandomRealEstateFactory randomRealEstateFactory = new RandomRealEstateFactory();
        FileOutputStream fileOutputStream = null;
        RealtorContactDetails realtorContactDetails = randomRealEstateFactory.createRandomContact();
        File file = File.createTempFile("example-contact-", ".xml");
        fileOutputStream = new FileOutputStream(file);
        XmlUtils.writeXml((RealtorContactDetails)realtorContactDetails, (String)ENCODING, (boolean)true, (OutputStream)fileOutputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        try {
            realtorContactDetails = randomRealEstateFactory.createRandomObject();
            file = File.createTempFile("example-object-", ".xml");
            fileOutputStream = new FileOutputStream(file);
            XmlUtils.writeXml((RealEstate)realtorContactDetails, (String)ENCODING, (boolean)true, (OutputStream)fileOutputStream);
            return;
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException("Can't build XML file!", jAXBException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't write XML file!", iOException);
        }
        catch (JAXBException jAXBException) {
            try {
                throw new RuntimeException("Can't build XML file!", jAXBException);
                catch (IOException iOException) {
                    throw new RuntimeException("Can't write XML file!", iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }
}

