/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.hc42;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.hc42.InputStreamBodyWithLength;
import org.openestate.is24.restapi.utils.RequestMethod;
import org.openestate.is24.restapi.utils.Response;

public class HttpComponents42Client
extends AbstractClient {
    private transient HttpClient httpClient = null;

    public HttpComponents42Client(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public HttpComponents42Client(String string, String string2, String string3, HttpClient httpClient) {
        super(string, string2, string3);
        this.httpClient = httpClient;
    }

    protected OAuthConsumer buildOAuthConsumer(String string, String string2) {
        return new CommonsHttpOAuthConsumer(string, string2);
    }

    protected OAuthProvider buildOAuthProvider(String string) {
        if (this.httpClient == null) {
            this.setDefaultHttpClient();
        }
        return new CommonsHttpOAuthProvider(string + "/security/oauth/request_token", string + "/security/oauth/access_token", string + "/security/oauth/confirm_access", this.httpClient);
    }

    public void close() throws IOException {
        super.close();
        if (this.httpClient instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)this.httpClient));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response createResponse(HttpResponse httpResponse) throws IOException {
        Response response;
        HttpEntity httpEntity = null;
        FilterInputStream filterInputStream = null;
        try {
            String string;
            String string2;
            StatusLine statusLine = httpResponse.getStatusLine();
            httpEntity = httpResponse.getEntity();
            String string3 = httpEntity.getContentType() != null ? StringUtils.trimToNull((String)httpEntity.getContentType().getValue()) : null;
            ContentType contentType = string3 != null ? ContentType.parse((String)string3) : null;
            String string4 = string2 = contentType != null && contentType.getCharset() != null ? contentType.getCharset().name() : null;
            if (string2 == null) {
                string2 = HttpComponents42Client.getEncoding();
            }
            filterInputStream = new BufferedInputStream(httpEntity.getContent());
            String string5 = string = httpEntity.getContentEncoding() != null ? httpEntity.getContentEncoding().getValue() : null;
            if ("gzip".equalsIgnoreCase(string)) {
                filterInputStream = new GZIPInputStream(filterInputStream);
            }
            Header header = httpResponse.getFirstHeader("L-IS24-RequestRefnum");
            response = new Response(statusLine.getStatusCode(), statusLine.getReasonPhrase(), header != null ? header.getValue() : null, IOUtils.toString((InputStream)filterInputStream, (String)string2));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(filterInputStream);
            EntityUtils.consume((HttpEntity)httpEntity);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)filterInputStream);
        EntityUtils.consume((HttpEntity)httpEntity);
        return response;
    }

    protected Response sendJsonRequest(URL uRL, RequestMethod requestMethod, String string) throws IOException, OAuthException {
        return this._sendRequest(uRL, requestMethod, string, "application/json");
    }

    protected Response sendXmlRequest(URL uRL, RequestMethod requestMethod, String string) throws IOException, OAuthException {
        return this._sendRequest(uRL, requestMethod, string, "application/xml");
    }

    protected Response sendXmlAttachmentRequest(URL uRL, RequestMethod requestMethod, String string, InputStream inputStream, String string2, String string3) throws IOException, OAuthException {
        InputStreamBody inputStreamBody;
        if (requestMethod == null) {
            requestMethod = RequestMethod.POST;
        }
        if (!RequestMethod.POST.equals((Object)requestMethod) && !RequestMethod.PUT.equals((Object)requestMethod)) {
            throw new IllegalArgumentException("Invalid request method!");
        }
        string = RequestMethod.POST.equals((Object)requestMethod) || RequestMethod.PUT.equals((Object)requestMethod) ? StringUtils.trimToNull((String)string) : null;
        HttpPost httpPost = null;
        if (RequestMethod.POST.equals((Object)requestMethod)) {
            httpPost = new HttpPost(uRL.toString());
        } else if (RequestMethod.PUT.equals((Object)requestMethod)) {
            httpPost = new HttpPut(uRL.toString());
        } else {
            throw new IOException("Unsupported request method '" + requestMethod + "'!");
        }
        MultipartEntity multipartEntity = new MultipartEntity();
        httpPost.addHeader(multipartEntity.getContentType());
        httpPost.setHeader("Content-Language", "en-US");
        httpPost.setHeader("Accept", "application/xml");
        if (string != null) {
            inputStreamBody = new InputStreamBody((InputStream)new ByteArrayInputStream(string.getBytes(HttpComponents42Client.getEncoding())), "application/xml", "body.xml");
            multipartEntity.addPart("metadata", (ContentBody)inputStreamBody);
        }
        if (inputStream != null) {
            if ((string3 = StringUtils.trimToNull((String)string3)) == null) {
                string3 = "application/octet-stream";
            }
            if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
                string2 = "upload.bin";
            }
            inputStreamBody = new InputStreamBody(inputStream, string3, string2);
            multipartEntity.addPart("attachment", (ContentBody)inputStreamBody);
        }
        ((HttpEntityEnclosingRequest)httpPost).setEntity((HttpEntity)multipartEntity);
        this.getAuthConsumer().sign((Object)httpPost);
        inputStreamBody = this.httpClient.execute((HttpUriRequest)httpPost);
        return this.createResponse((HttpResponse)inputStreamBody);
    }

    protected Response sendVideoUploadRequest(URL uRL, RequestMethod requestMethod, String string, InputStream inputStream, String string2, long l) throws IOException, OAuthException {
        Object object;
        if (requestMethod == null) {
            requestMethod = RequestMethod.POST;
        }
        if (!RequestMethod.POST.equals((Object)requestMethod) && !RequestMethod.PUT.equals((Object)requestMethod)) {
            throw new IllegalArgumentException("Invalid request method!");
        }
        HttpPost httpPost = null;
        if (RequestMethod.POST.equals((Object)requestMethod)) {
            httpPost = new HttpPost(uRL.toString());
        } else if (RequestMethod.PUT.equals((Object)requestMethod)) {
            httpPost = new HttpPut(uRL.toString());
        } else {
            throw new IOException("Unsupported request method '" + requestMethod + "'!");
        }
        MultipartEntity multipartEntity = new MultipartEntity();
        httpPost.setHeader("MIME-Version", "1.0");
        httpPost.addHeader(multipartEntity.getContentType());
        httpPost.setHeader("Content-Language", "en-US");
        httpPost.setHeader("Accept-Charset", "UTF-8");
        httpPost.setHeader("Accept-Encoding", "gzip,deflate");
        httpPost.setHeader("Connection", "close");
        string = StringUtils.trimToNull((String)string);
        if (string != null) {
            object = new StringBody(string, Charset.forName(HttpComponents42Client.getEncoding()));
            multipartEntity.addPart("auth", (ContentBody)object);
        }
        if (inputStream != null) {
            if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
                string2 = "upload.bin";
            }
            object = new InputStreamBodyWithLength(inputStream, string2, l);
            multipartEntity.addPart("videofile", (ContentBody)object);
        }
        ((HttpEntityEnclosingRequest)httpPost).setEntity((HttpEntity)multipartEntity);
        object = this.httpClient.execute((HttpUriRequest)httpPost);
        return this.createResponse((HttpResponse)object);
    }

    private Response _sendRequest(URL uRL, RequestMethod requestMethod, String string, String string2) throws IOException, OAuthException {
        ContentType contentType;
        if (this.httpClient == null) {
            throw new IOException("No HTTP client was specified!");
        }
        if (requestMethod == null) {
            requestMethod = RequestMethod.GET;
        }
        string = RequestMethod.POST.equals((Object)requestMethod) || RequestMethod.PUT.equals((Object)requestMethod) ? StringUtils.trimToNull((String)string) : null;
        HttpGet httpGet = null;
        if (RequestMethod.GET.equals((Object)requestMethod)) {
            httpGet = new HttpGet(uRL.toString());
        } else if (RequestMethod.POST.equals((Object)requestMethod)) {
            httpGet = new HttpPost(uRL.toString());
        } else if (RequestMethod.PUT.equals((Object)requestMethod)) {
            httpGet = new HttpPut(uRL.toString());
        } else if (RequestMethod.DELETE.equals((Object)requestMethod)) {
            httpGet = new HttpDelete(uRL.toString());
        } else {
            throw new IOException("Unsupported request method '" + requestMethod + "'!");
        }
        if (string != null && httpGet instanceof HttpEntityEnclosingRequest) {
            contentType = ContentType.create((String)string2, (String)HttpComponents42Client.getEncoding());
            httpGet.setHeader("Content-Type", contentType.toString());
            httpGet.setHeader("Content-Language", "en-US");
            StringEntity stringEntity = new StringEntity(string, contentType);
            ((HttpEntityEnclosingRequest)httpGet).setEntity((HttpEntity)stringEntity);
        }
        httpGet.setHeader("Accept", string2);
        this.getAuthConsumer().sign((Object)httpGet);
        contentType = this.httpClient.execute((HttpUriRequest)httpGet);
        return this.createResponse((HttpResponse)contentType);
    }

    public void setDefaultHttpClient() {
        this.setDefaultHttpClient(30000);
    }

    public void setDefaultHttpClient(int n) {
        if (n < 0) {
            n = 0;
        }
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)HttpComponents42Client.getEncoding());
        HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)n);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)n);
        this.setHttpClient((HttpClient)new DefaultHttpClient((HttpParams)basicHttpParams));
    }

    public synchronized void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        try {
            OAuthProvider oAuthProvider = this.getAuthProvider();
            if (oAuthProvider instanceof CommonsHttpOAuthProvider) {
                ((CommonsHttpOAuthProvider)oAuthProvider).setHttpClient(httpClient);
            }
        }
        catch (OAuthNotAuthorizedException oAuthNotAuthorizedException) {
            // empty catch block
        }
    }
}

