/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.hc43;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.hc43.InputStreamBodyWithLength;
import org.openestate.is24.restapi.utils.RequestMethod;
import org.openestate.is24.restapi.utils.Response;

public class HttpComponents43Client
extends AbstractClient {
    private transient HttpClient httpClient = null;

    public HttpComponents43Client(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public HttpComponents43Client(String string, String string2, String string3, HttpClient httpClient) {
        super(string, string2, string3);
        this.httpClient = httpClient;
    }

    protected OAuthConsumer buildOAuthConsumer(String string, String string2) {
        return new CommonsHttpOAuthConsumer(string, string2);
    }

    protected OAuthProvider buildOAuthProvider(String string) {
        if (this.httpClient == null) {
            this.setDefaultHttpClient();
        }
        return new CommonsHttpOAuthProvider(string + "/security/oauth/request_token", string + "/security/oauth/access_token", string + "/security/oauth/confirm_access", this.httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response createResponse(HttpResponse httpResponse) throws IOException {
        Response response;
        HttpEntity httpEntity = null;
        FilterInputStream filterInputStream = null;
        try {
            String string;
            String string2;
            StatusLine statusLine = httpResponse.getStatusLine();
            httpEntity = httpResponse.getEntity();
            String string3 = httpEntity.getContentType() != null ? StringUtils.trimToNull((String)httpEntity.getContentType().getValue()) : null;
            ContentType contentType = string3 != null ? ContentType.parse((String)string3) : null;
            String string4 = string2 = contentType != null && contentType.getCharset() != null ? contentType.getCharset().name() : null;
            if (string2 == null) {
                string2 = HttpComponents43Client.getEncoding();
            }
            filterInputStream = new BufferedInputStream(httpEntity.getContent());
            String string5 = string = httpEntity.getContentEncoding() != null ? httpEntity.getContentEncoding().getValue() : null;
            if ("gzip".equalsIgnoreCase(string)) {
                filterInputStream = new GZIPInputStream(filterInputStream);
            }
            Header header = httpResponse.getFirstHeader("L-IS24-RequestRefnum");
            response = new Response(statusLine.getStatusCode(), statusLine.getReasonPhrase(), header != null ? header.getValue() : null, IOUtils.toString((InputStream)filterInputStream, (String)string2));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(filterInputStream);
            EntityUtils.consume((HttpEntity)httpEntity);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)filterInputStream);
        EntityUtils.consume((HttpEntity)httpEntity);
        return response;
    }

    protected Response sendXmlRequest(URL uRL, RequestMethod requestMethod, String string) throws IOException, OAuthException {
        ContentType contentType;
        if (this.httpClient == null) {
            throw new IOException("No HTTP client was specified!");
        }
        if (requestMethod == null) {
            requestMethod = RequestMethod.GET;
        }
        string = RequestMethod.POST.equals((Object)requestMethod) || RequestMethod.PUT.equals((Object)requestMethod) ? StringUtils.trimToNull((String)string) : null;
        HttpGet httpGet = null;
        if (RequestMethod.GET.equals((Object)requestMethod)) {
            httpGet = new HttpGet(uRL.toString());
        } else if (RequestMethod.POST.equals((Object)requestMethod)) {
            httpGet = new HttpPost(uRL.toString());
        } else if (RequestMethod.PUT.equals((Object)requestMethod)) {
            httpGet = new HttpPut(uRL.toString());
        } else if (RequestMethod.DELETE.equals((Object)requestMethod)) {
            httpGet = new HttpDelete(uRL.toString());
        } else {
            throw new IOException("Unsupported request method '" + requestMethod + "'!");
        }
        if (string != null && httpGet instanceof HttpEntityEnclosingRequest) {
            contentType = ContentType.create((String)"application/xml", (String)HttpComponents43Client.getEncoding());
            httpGet.setHeader("Content-Type", contentType.toString());
            httpGet.setHeader("Content-Language", "en-US");
            StringEntity stringEntity = new StringEntity(string, contentType);
            ((HttpEntityEnclosingRequest)httpGet).setEntity((HttpEntity)stringEntity);
        }
        httpGet.setHeader("Accept", "application/xml");
        this.getAuthConsumer().sign((Object)httpGet);
        contentType = this.httpClient.execute((HttpUriRequest)httpGet);
        return this.createResponse((HttpResponse)contentType);
    }

    protected Response sendXmlAttachmentRequest(URL uRL, RequestMethod requestMethod, String string, InputStream inputStream, String string2, String string3) throws IOException, OAuthException {
        if (requestMethod == null) {
            requestMethod = RequestMethod.POST;
        }
        if (!RequestMethod.POST.equals((Object)requestMethod) && !RequestMethod.PUT.equals((Object)requestMethod)) {
            throw new IllegalArgumentException("Invalid request method!");
        }
        string = RequestMethod.POST.equals((Object)requestMethod) || RequestMethod.PUT.equals((Object)requestMethod) ? StringUtils.trimToNull((String)string) : null;
        HttpPost httpPost = null;
        if (RequestMethod.POST.equals((Object)requestMethod)) {
            httpPost = new HttpPost(uRL.toString());
        } else if (RequestMethod.PUT.equals((Object)requestMethod)) {
            httpPost = new HttpPut(uRL.toString());
        } else {
            throw new IOException("Unsupported request method '" + requestMethod + "'!");
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        if (string != null) {
            multipartEntityBuilder.addTextBody("metadata", string, ContentType.create((String)"application/xml", (String)HttpComponents43Client.getEncoding()));
        }
        if (inputStream != null) {
            if ((string3 = StringUtils.trimToNull((String)string3)) == null) {
                string3 = "application/octet-stream";
            }
            if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
                string2 = "upload.bin";
            }
            multipartEntityBuilder.addBinaryBody("attachment", inputStream, ContentType.create((String)string3), string2);
        }
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.addHeader(httpEntity.getContentType());
        httpPost.setHeader("Content-Language", "en-US");
        httpPost.setHeader("Accept", "application/xml");
        ((HttpEntityEnclosingRequest)httpPost).setEntity(httpEntity);
        this.getAuthConsumer().sign((Object)httpPost);
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
        return this.createResponse(httpResponse);
    }

    protected Response sendVideoUploadRequest(URL uRL, RequestMethod requestMethod, String string, InputStream inputStream, String string2, long l) throws IOException, OAuthException {
        Object object;
        if (requestMethod == null) {
            requestMethod = RequestMethod.POST;
        }
        if (!RequestMethod.POST.equals((Object)requestMethod) && !RequestMethod.PUT.equals((Object)requestMethod)) {
            throw new IllegalArgumentException("Invalid request method!");
        }
        HttpPost httpPost = null;
        if (RequestMethod.POST.equals((Object)requestMethod)) {
            httpPost = new HttpPost(uRL.toString());
        } else if (RequestMethod.PUT.equals((Object)requestMethod)) {
            httpPost = new HttpPut(uRL.toString());
        } else {
            throw new IOException("Unsupported request method '" + requestMethod + "'!");
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        string = StringUtils.trimToNull((String)string);
        if (string != null) {
            multipartEntityBuilder.addTextBody("auth", string, ContentType.create((String)"text/plain", (String)HttpComponents43Client.getEncoding()));
        }
        if (inputStream != null) {
            if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
                string2 = "upload.bin";
            }
            object = new InputStreamBodyWithLength(inputStream, string2, l);
            multipartEntityBuilder.addPart("videofile", (ContentBody)object);
        }
        object = multipartEntityBuilder.build();
        httpPost.setHeader("MIME-Version", "1.0");
        httpPost.addHeader(object.getContentType());
        httpPost.setHeader("Content-Language", "en-US");
        httpPost.setHeader("Accept-Charset", "UTF-8");
        httpPost.setHeader("Accept-Encoding", "gzip,deflate");
        httpPost.setHeader("Connection", "close");
        ((HttpEntityEnclosingRequest)httpPost).setEntity(object);
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
        return this.createResponse(httpResponse);
    }

    public void setDefaultHttpClient() {
        this.setDefaultHttpClient(30000);
    }

    public void setDefaultHttpClient(int n) {
        if (n < 0) {
            n = 0;
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n).build());
        this.setHttpClient((HttpClient)httpClientBuilder.build());
    }

    public synchronized void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        try {
            OAuthProvider oAuthProvider = this.getAuthProvider();
            if (oAuthProvider instanceof CommonsHttpOAuthProvider) {
                ((CommonsHttpOAuthProvider)oAuthProvider).setHttpClient(httpClient);
            }
        }
        catch (OAuthNotAuthorizedException oAuthNotAuthorizedException) {
            // empty catch block
        }
    }
}

