/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.webapp;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.DefaultClient;
import org.openestate.is24.restapi.utils.Authorization;
import org.openestate.is24.restapi.utils.SslUtils;
import org.openestate.is24.restapi.utils.Verification;
import org.openestate.is24.restapi.webapp.VerificationServlet;

public class VerificationServlet
extends HttpServlet {
    private static final long serialVersionUID = 4320407955026600846L;
    private final VerificationMap verifications = new VerificationMap(null);
    private String webserviceUrl = null;
    private String consumerKey = null;
    private String consumerSecret = null;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = StringUtils.trimToNull((String)httpServletRequest.getParameter("state"));
        String string2 = StringUtils.trimToNull((String)httpServletRequest.getParameter("oauth_token"));
        String string3 = StringUtils.trimToNull((String)httpServletRequest.getParameter("oauth_verifier"));
        if (string == null && string2 == null && string3 == null) {
            this.doVerificationRequest(httpServletRequest, httpServletResponse);
        } else {
            this.doVerificationResponse(string, string2, string3, httpServletRequest, httpServletResponse);
        }
    }

    protected void doVerificationRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Verification verification = null;
        try {
            verification = this.getWebserviceVerification(httpServletRequest);
        }
        catch (OAuthException oAuthException) {
            throw new IOException("Can't fetch verification!", oAuthException);
        }
        this.storeVerification(verification);
        httpServletRequest.setAttribute("url", (Object)verification.verificationUrl);
        httpServletRequest.setAttribute("token", (Object)verification.requestToken);
        httpServletRequest.setAttribute("secret", (Object)verification.requestTokenSecret);
        httpServletResponse.setCharacterEncoding("UTF-8");
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("/WEB-INF/views/verification-request.jsp");
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doVerificationResponse(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String string4;
            if (!"authorized".equalsIgnoreCase(string)) {
                httpServletRequest.setAttribute("authorized", (Object)false);
            } else {
                httpServletRequest.setAttribute("authorized", (Object)true);
                string4 = this.fetchVerificationSecret(string2);
                if (string2 == null || string4 == null) {
                    httpServletRequest.setAttribute("valid", (Object)false);
                } else {
                    Authorization authorization = null;
                    try {
                        authorization = this.getWebserviceAuthorization(string2, string4, string3, httpServletRequest);
                    }
                    catch (OAuthException oAuthException) {
                        throw new IOException("Can't fetch authorization!", oAuthException);
                    }
                    httpServletRequest.setAttribute("valid", (Object)true);
                    httpServletRequest.setAttribute("token", (Object)authorization.accessToken);
                    httpServletRequest.setAttribute("secret", (Object)authorization.accessTokenSecret);
                }
            }
            httpServletResponse.setCharacterEncoding("UTF-8");
            string4 = httpServletRequest.getRequestDispatcher("/WEB-INF/views/verification-response.jsp");
            string4.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            this.removeVerificationSecret(string2);
        }
    }

    protected String fetchVerificationSecret(String string) {
        return (String)this.verifications.get((Object)string);
    }

    protected AbstractClient getClient() {
        return new DefaultClient(this.webserviceUrl, this.consumerKey, this.consumerSecret);
    }

    protected Authorization getWebserviceAuthorization(String string, String string2, String string3, HttpServletRequest httpServletRequest) throws OAuthException {
        AbstractClient abstractClient = this.getClient();
        return abstractClient.authorizeAfterVerification(string, string2, string3);
    }

    protected Verification getWebserviceVerification(HttpServletRequest httpServletRequest) throws OAuthException {
        AbstractClient abstractClient = this.getClient();
        return abstractClient.fetchVerification(httpServletRequest.getRequestURL().toString());
    }

    public void init() throws ServletException {
        super.init();
        ServletContext servletContext = this.getServletContext();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.webserviceUrl = StringUtils.trimToNull((String)servletContext.getInitParameter("WebserviceUrl"));
        if (this.webserviceUrl == null) {
            arrayList.add("No 'WebserviceUrl' is configured.");
        }
        this.consumerKey = StringUtils.trimToNull((String)servletContext.getInitParameter("ConsumerKey"));
        if (this.consumerKey == null) {
            arrayList.add("No 'ConsumerKey' is configured.");
        }
        this.consumerSecret = StringUtils.trimToNull((String)servletContext.getInitParameter("ConsumerSecret"));
        if (this.consumerSecret == null) {
            arrayList.add("No 'ConsumerSecret' is configured.");
        }
        if (!arrayList.isEmpty()) {
            throw new ServletException("Can't init servlet: " + StringUtils.join(arrayList, (String)", "));
        }
        String string = StringUtils.trimToNull((String)servletContext.getInitParameter("TrustAllCertificates"));
        if ("1".equals(string) || "true".equalsIgnoreCase(string)) {
            try {
                SslUtils.disableCertificateChecks();
                SslUtils.disableHostnameVerification();
            }
            catch (Exception exception) {
                throw new ServletException("Can't setup insecure SSL context!", (Throwable)exception);
            }
        }
    }

    protected void removeVerificationSecret(String string) {
        this.verifications.remove((Object)string);
    }

    protected void storeVerification(Verification verification) {
        this.verifications.put(verification);
    }
}

