/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.ImportExport;
import org.openestate.is24.restapi.utils.AlphanumComparator;
import org.openestate.is24.restapi.utils.ExportMessage;
import org.openestate.is24.restapi.utils.ExportPool;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.utils.Resource;
import org.openestate.is24.restapi.xml.common.AbstractRealEstateForList;
import org.openestate.is24.restapi.xml.common.Attachment;
import org.openestate.is24.restapi.xml.common.Attachments;
import org.openestate.is24.restapi.xml.common.Link;
import org.openestate.is24.restapi.xml.common.Message;
import org.openestate.is24.restapi.xml.common.MessageCode;
import org.openestate.is24.restapi.xml.common.Messages;
import org.openestate.is24.restapi.xml.common.PDFDocument;
import org.openestate.is24.restapi.xml.common.Picture;
import org.openestate.is24.restapi.xml.common.PublishChannel;
import org.openestate.is24.restapi.xml.common.PublishChannels;
import org.openestate.is24.restapi.xml.common.PublishObject;
import org.openestate.is24.restapi.xml.common.PublishObjects;
import org.openestate.is24.restapi.xml.common.RealEstateState;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.common.StreamingVideo;
import org.openestate.is24.restapi.xml.offerlistelement.OfferRealEstateForList;
import org.openestate.is24.restapi.xml.offerlistelement.RealEstateList;
import org.openestate.is24.restapi.xml.realestates.ObjectFactory;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.openestate.is24.restapi.xml.realestates.RealEstates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportHandler.class);
    private final List<ExportMessage> messages = new ArrayList<ExportMessage>();
    private final List<String> savedContactIds = new ArrayList<String>();
    private final Map<String, Long> duplicatedContactIds = new HashMap<String, Long>();
    private AbstractClient client = null;
    private ExportPool pool = null;
    private long progress = 0L;
    private long totalProgress = 0L;
    private boolean useNewEnergySourceEnev2014Values = true;

    protected final void addProgress(long l) {
        this.setProgress(this.progress + Math.abs(l));
    }

    protected boolean canIgnoreContact(RealtorContactDetails realtorContactDetails, String string) {
        return false;
    }

    protected boolean canIgnoreObject(RealEstate realEstate, String string) {
        return false;
    }

    protected final void doArchiveObject(String string) throws IOException {
        RealEstate realEstate;
        try {
            realEstate = ImportExport.RealEstateService.getByExternalId(this.client, string);
            if (realEstate == null) {
                this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_FOUND_FOR_ARCHIVING, "Property '" + string + "' is not available anymore at the Webservice!");
                return;
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (RequestFailedException requestFailedException) {
            LOGGER.error("Can't get property '" + string + "' from the Webservice!");
            if (requestFailedException.requestRefNumber != null) {
                LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
            }
            this.logMessagesAsError(requestFailedException.responseMessages);
            LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
            this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_FOUND_FOR_ARCHIVING, requestFailedException);
            return;
        }
        this.doArchiveObject(realEstate);
    }

    protected final void doArchiveObject(long l, String string) throws IOException {
        RealEstate realEstate;
        try {
            realEstate = ImportExport.RealEstateService.getByIs24Id(this.client, l);
            if (realEstate == null) {
                if (!StringUtils.isBlank((CharSequence)string)) {
                    this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_FOUND_FOR_ARCHIVING, "Property '" + string + "' is not available anymore at the Webservice!");
                } else {
                    this.putGeneralMessage(ExportMessage.Code.OBJECT_NOT_FOUND_FOR_ARCHIVING, "Property (" + l + ") is not available anymore at the Webservice!");
                }
                return;
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (RequestFailedException requestFailedException) {
            if (!StringUtils.isBlank((CharSequence)string)) {
                LOGGER.error("Can't get property '" + string + "' (" + l + ") from the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_FOUND_FOR_ARCHIVING, requestFailedException);
            } else {
                LOGGER.error("Can't get property (" + l + ") from the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putGeneralMessage(ExportMessage.Code.OBJECT_NOT_FOUND_FOR_ARCHIVING, requestFailedException);
            }
            return;
        }
        this.doArchiveObject(realEstate);
    }

    protected void doArchiveObject(RealEstate realEstate) throws IOException {
        try {
            Long l = realEstate.getId();
            String string = StringUtils.trimToNull((String)realEstate.getExternalId());
            PublishObjects publishObjects = null;
            try {
                publishObjects = ImportExport.PublishService.get(this.client, l, 0L);
            }
            catch (RequestFailedException requestFailedException) {
                if (!StringUtils.isBlank((CharSequence)string)) {
                    LOGGER.error("Can't get publishings of property '" + string + "' (" + l + ") from the Webservice!");
                    if (requestFailedException.requestRefNumber != null) {
                        LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                    }
                    this.logMessagesAsError(requestFailedException.responseMessages);
                    LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                    this.putObjectMessage(string, ExportMessage.Code.OBJECT_PUBLISHINGS_NOT_FOUND, requestFailedException);
                }
                LOGGER.error("Can't get publishings of property (" + l + ") from the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putGeneralMessage(ExportMessage.Code.OBJECT_PUBLISHINGS_NOT_FOUND, requestFailedException);
            }
            if (publishObjects == null) {
                if (!StringUtils.isBlank((CharSequence)string)) {
                    this.putObjectMessage(string, ExportMessage.Code.OBJECT_PUBLISHINGS_NOT_FOUND, "Can't get publishings of property '" + string + "' (" + l + ") from the Webservice!");
                } else {
                    this.putGeneralMessage(ExportMessage.Code.OBJECT_PUBLISHINGS_NOT_FOUND, "Can't get publishings of property (" + l + ") from the Webservice!");
                }
            } else {
                for (PublishObject publishObject : publishObjects.getPublishObject()) {
                    Long l2 = publishObject.getPublishChannel().getId();
                    String string2 = StringUtils.trimToNull((String)publishObject.getId());
                    try {
                        ImportExport.PublishService.delete(this.client, string2);
                    }
                    catch (RequestFailedException requestFailedException) {
                        if (!StringUtils.isBlank((CharSequence)string)) {
                            LOGGER.error("Can't unpublish property '" + string + "' (" + l + ") " + "in channel '" + publishObject.getPublishChannel().getTitle() + "' (" + l2 + ") at the Webservice!");
                            if (requestFailedException.requestRefNumber != null) {
                                LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                            }
                            this.logMessagesAsError(requestFailedException.responseMessages);
                            LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                            this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_UNPUBLISHED, requestFailedException);
                            continue;
                        }
                        LOGGER.error("Can't unpublish property (" + l + ") " + "in channel '" + publishObject.getPublishChannel().getTitle() + "' (" + l2 + ") at the Webservice!");
                        this.logMessagesAsError(requestFailedException.responseMessages);
                        LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                        this.putGeneralMessage(ExportMessage.Code.OBJECT_NOT_UNPUBLISHED, requestFailedException);
                    }
                }
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File doDownloadFile(URL uRL) throws IOException {
        File file;
        if (uRL == null) {
            return null;
        }
        LOGGER.info("downloading " + uRL);
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = uRL.openStream();
            File file2 = File.createTempFile("is24-export-attachment-", ".bin");
            file2.deleteOnExit();
            fileOutputStream = new FileOutputStream(file2);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            file = file2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return file;
    }

    protected Map<Long, String> doListUntouchedObjects() throws IOException {
        try {
            TreeMap<Long, String> treeMap = new TreeMap<Long, String>();
            int n = 1;
            while (true) {
                RealEstateList realEstateList;
                RealEstates realEstates;
                try {
                    realEstates = ImportExport.RealEstateService.getAll(this.client, null, null, 0, n, false);
                    if (realEstates == null) {
                        this.putGeneralMessage(ExportMessage.Code.OBJECTS_NOT_FOUND, "Can't get available properties from the Webservice!");
                        return new HashMap<Long, String>();
                    }
                }
                catch (RequestFailedException requestFailedException) {
                    LOGGER.error("Can't get available properties from the Webservice!");
                    if (requestFailedException.requestRefNumber != null) {
                        LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                    }
                    this.logMessagesAsError(requestFailedException.responseMessages);
                    LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                    this.putGeneralMessage(ExportMessage.Code.OBJECTS_NOT_FOUND, requestFailedException);
                    return new HashMap<Long, String>();
                }
                Long l = realEstates.getPaging().getNumberOfPages();
                if (l == null) {
                    l = 0L;
                }
                if ((realEstateList = realEstates.getRealEstateList()) != null && !realEstateList.getRealEstateElement().isEmpty()) {
                    for (OfferRealEstateForList offerRealEstateForList : realEstateList.getRealEstateElement()) {
                        boolean bl;
                        boolean bl2 = bl = RealEstateState.ACTIVE.equals((Object)offerRealEstateForList.getState()) || RealEstateState.ACTIVE.equals((Object)offerRealEstateForList.getRealEstateState());
                        if (!bl) continue;
                        long l2 = offerRealEstateForList.getId();
                        String string = offerRealEstateForList.getExternalId();
                        if (treeMap.containsKey(l2) || this.pool.hasObjectForExport(string)) continue;
                        treeMap.put(l2, string);
                    }
                }
                if ((long)n >= l) break;
                ++n;
            }
            return treeMap;
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
        }
    }

    protected PublishChannels doLoadPublishChannels() throws IOException {
        try {
            return ImportExport.PublishChannelService.get(this.client);
        }
        catch (RequestFailedException requestFailedException) {
            LOGGER.error("Can't get publish channels from the Webservice!");
            if (requestFailedException.requestRefNumber != null) {
                LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
            }
            this.logMessagesAsError(requestFailedException.responseMessages);
            LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
            this.putGeneralMessage(ExportMessage.Code.PUBLISH_CHANNELS_NOT_FOUND, requestFailedException);
            return null;
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
        }
    }

    protected void doPublishObject(long l, String string, PublishChannels publishChannels) throws IOException {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        try {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            try {
                PublishObjects publishObjects = ImportExport.PublishService.get(this.client, l, 0L);
                if (publishObjects != null) {
                    for (PublishObject publishObject : publishObjects.getPublishObject()) {
                        arrayList.add(publishObject.getPublishChannel().getId());
                    }
                }
            }
            catch (RequestFailedException requestFailedException) {
                LOGGER.error("Can't get publishings of property '" + string + "' (" + l + ") from the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putObjectMessage(string, ExportMessage.Code.OBJECT_PUBLISHINGS_NOT_FOUND, requestFailedException);
            }
            if (publishChannels == null) {
                this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_PUBLISHED, "No channels for publishing found!");
            } else {
                for (PublishChannel publishChannel : publishChannels.getPublishChannel()) {
                    Long l2 = publishChannel.getId();
                    if (arrayList.contains(l2)) continue;
                    PublishObject publishObject = objectFactory.createPublishObject();
                    publishObject.setPublishChannel(publishChannel);
                    publishObject.setRealEstate(objectFactory.createPublishObjectRealEstate());
                    publishObject.getRealEstate().setId(l);
                    try {
                        ImportExport.PublishService.post(this.client, publishObject);
                    }
                    catch (RequestFailedException requestFailedException) {
                        LOGGER.error("Can't publish property '" + string + "' (" + l + ") " + "in channel '" + publishChannel.getTitle() + "' (" + l2 + ")!");
                        if (requestFailedException.requestRefNumber != null) {
                            LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                        }
                        this.logMessagesAsError(requestFailedException.responseMessages);
                        LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                        this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_PUBLISHED, requestFailedException);
                    }
                }
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
        }
    }

    protected void doRemoveObject(String string) throws IOException {
        try {
            try {
                ImportExport.RealEstateService.deleteByExternalId(this.client, string);
            }
            catch (RequestFailedException requestFailedException) {
                LOGGER.error("Can't delete property '" + string + "' at the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_REMOVED, requestFailedException);
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
        }
    }

    protected void doRemoveObject(long l, String string) throws IOException {
        block9: {
            try {
                try {
                    ImportExport.RealEstateService.deleteByIs24Id(this.client, l);
                }
                catch (RequestFailedException requestFailedException) {
                    if (!StringUtils.isBlank((CharSequence)string)) {
                        LOGGER.error("Can't delete property '" + string + "' (" + l + ") at the Webservice!");
                        if (requestFailedException.requestRefNumber != null) {
                            LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                        }
                        this.logMessagesAsError(requestFailedException.responseMessages);
                        LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                        this.putObjectMessage(string, ExportMessage.Code.OBJECT_NOT_REMOVED, requestFailedException);
                        break block9;
                    }
                    LOGGER.error("Can't delete property (" + l + ") at the Webservice!");
                    if (requestFailedException.requestRefNumber != null) {
                        LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                    }
                    this.logMessagesAsError(requestFailedException.responseMessages);
                    LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                    this.putGeneralMessage(ExportMessage.Code.OBJECT_NOT_REMOVED, requestFailedException);
                }
            }
            catch (JAXBException jAXBException) {
                throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
            }
            catch (OAuthException oAuthException) {
                throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
            }
            catch (IOException iOException) {
                throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long doUpdateContact(RealtorContactDetails realtorContactDetails, String string) throws IOException {
        Long l;
        RealtorContactDetails realtorContactDetails2;
        String string2 = realtorContactDetails.getExternalId();
        try {
            realtorContactDetails2 = ImportExport.ContactAddressService.getByExternalId(this.client, string2);
        }
        catch (RequestFailedException requestFailedException) {
            LOGGER.error("Can't get contact person '" + string2 + "' from the Webservice!");
            if (requestFailedException.requestRefNumber != null) {
                LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
            }
            this.logMessagesAsError(requestFailedException.responseMessages);
            LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
            this.putContactMessage(string2, ExportMessage.Code.CONTACT_NOT_FOUND, requestFailedException);
            Long l2 = null;
            this.addProgress(this.pool.getContactSize(string, true));
            return l2;
        }
        if (realtorContactDetails2 == null) {
            try {
                l = ImportExport.ContactAddressService.post(this.client, realtorContactDetails);
            }
            catch (RequestFailedException requestFailedException) {
                Resource resource = Resource.getMessageResource(requestFailedException.responseMessages);
                if (resource != null && "duplicated contactDetails".equalsIgnoreCase(resource.type) && resource.id > 0L) {
                    LOGGER.info("contact '" + string2 + "' is already " + "available at the Webservice with ID " + resource.id + ".");
                    this.duplicatedContactIds.put(string2, resource.id);
                    l = resource.id;
                }
                LOGGER.error("Can't add contact person '" + string2 + "' to the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putContactMessage(string2, ExportMessage.Code.CONTACT_NOT_SAVED, requestFailedException);
                Long l3 = null;
                this.addProgress(this.pool.getContactSize(string, true));
                return l3;
            }
        }
        l = realtorContactDetails2.getId();
        {
            catch (JAXBException jAXBException) {
                throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
            }
            catch (OAuthException oAuthException) {
                throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
            }
            catch (IOException iOException) {
                throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
            }
            realtorContactDetails.setId(l);
            try {
                ImportExport.ContactAddressService.putByIs24Id(this.client, realtorContactDetails, l);
            }
            catch (RequestFailedException requestFailedException) {}
            Resource resource = Resource.getMessageResource(requestFailedException.responseMessages);
            if (resource != null && "duplicated contactDetails".equalsIgnoreCase(resource.type) && resource.id > 0L) {
                LOGGER.info("contact '" + string2 + "' is already " + "available at the Webservice with ID " + resource.id + ".");
                this.duplicatedContactIds.put(string2, resource.id);
                Long l4 = resource.id;
                this.addProgress(this.pool.getContactSize(string, true));
                return l4;
            }
            LOGGER.error("Can't update contact person '" + string2 + "' at the Webservice!");
            if (requestFailedException.requestRefNumber != null) {
                LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
            }
            this.logMessagesAsError(requestFailedException.responseMessages);
            LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
            this.putContactMessage(string2, ExportMessage.Code.CONTACT_NOT_SAVED, requestFailedException);
            Long l5 = null;
            this.addProgress(this.pool.getContactSize(string, true));
            return l5;
        }
        this.savedContactIds.add(string2);
        return l;
        finally {
            this.addProgress(this.pool.getContactSize(string, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long doUpdateObject(RealEstate realEstate, String string) throws IOException {
        Object object;
        Long l;
        String string2 = realEstate.getExternalId();
        ObjectFactory objectFactory = new ObjectFactory();
        org.openestate.is24.restapi.xml.attachmentsorder.ObjectFactory objectFactory2 = new org.openestate.is24.restapi.xml.attachmentsorder.ObjectFactory();
        realEstate.setRealEstateState(RealEstateState.ACTIVE);
        Long l2 = l = realEstate.getContact() != null ? realEstate.getContact().getId() : null;
        if (l == null || l < 1L) {
            Object object2 = object = realEstate.getContact() != null ? StringUtils.trimToNull((String)realEstate.getContact().getExternalId()) : null;
            if (object != null && this.duplicatedContactIds.containsKey(object)) {
                l = this.duplicatedContactIds.get(object);
                if (realEstate.getContact() == null) {
                    realEstate.setContact(objectFactory.createRealEstateContact());
                }
                realEstate.getContact().setId(l);
                realEstate.getContact().setExternalId(null);
            } else if (object != null && !this.savedContactIds.contains(object)) {
                this.putObjectMessage(string2, ExportMessage.Code.OBJECT_WITHOUT_CONTACT, "The contact '" + (String)object + "' was not saved during the export process.");
                realEstate.setContact(null);
            }
        }
        try {
            String[] stringArray;
            Cloneable cloneable;
            Long l3;
            try {
                object = ImportExport.RealEstateService.getByExternalId(this.client, string2);
            }
            catch (RequestFailedException requestFailedException) {
                LOGGER.error("Can't get property '" + string2 + "' from the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putObjectMessage(string2, ExportMessage.Code.OBJECT_NOT_FOUND, requestFailedException);
                this.addProgress(this.pool.getObjectSize(string, true));
                return null;
            }
            if (object != null && !object.getClass().getName().equals(realEstate.getClass().getName())) {
                try {
                    ImportExport.RealEstateService.deleteByIs24Id(this.client, ((AbstractRealEstateForList)object).getId());
                    object = null;
                }
                catch (RequestFailedException requestFailedException) {
                    LOGGER.error("Can't delete property '" + string2 + "' (" + ((AbstractRealEstateForList)object).getId() + ") at the Webservice!");
                    if (requestFailedException.requestRefNumber != null) {
                        LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                    }
                    this.logMessagesAsError(requestFailedException.responseMessages);
                    LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                    this.putObjectMessage(string2, ExportMessage.Code.OBJECT_NOT_SAVED, requestFailedException);
                    this.addProgress(this.pool.getObjectSize(string, true));
                    return null;
                }
            }
            if (object == null) {
                try {
                    l3 = ImportExport.RealEstateService.post(this.client, realEstate, this.isUseNewEnergySourceEnev2014Values());
                }
                catch (RequestFailedException requestFailedException) {
                    LOGGER.error("Can't add property '" + string2 + "' to the Webservice!");
                    if (requestFailedException.requestRefNumber != null) {
                        LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                    }
                    this.logMessagesAsError(requestFailedException.responseMessages);
                    LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                    this.putObjectMessage(string2, ExportMessage.Code.OBJECT_NOT_SAVED, requestFailedException);
                    this.addProgress(this.pool.getObjectSize(string, true));
                    return null;
                }
            }
            l3 = ((AbstractRealEstateForList)object).getId();
            realEstate.setId(l3);
            try {
                ImportExport.RealEstateService.putByIs24Id(this.client, realEstate, l3, this.isUseNewEnergySourceEnev2014Values());
            }
            catch (RequestFailedException requestFailedException) {
                LOGGER.error("Can't update property '" + string2 + "' (" + l3 + ") at the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putObjectMessage(string2, ExportMessage.Code.OBJECT_NOT_SAVED, requestFailedException);
                this.addProgress(this.pool.getObjectSize(string, true));
                return null;
            }
            this.addProgress(this.pool.getObjectSize(string, false));
            HashMap<String, Attachment> hashMap = new HashMap<String, Attachment>();
            boolean bl = false;
            try {
                cloneable = ImportExport.AttachmentService.getAll(this.client, string2);
                if (cloneable != null && !((Attachments)cloneable).getAttachment().isEmpty()) {
                    for (Attachment cloneable2 : ((Attachments)cloneable).getAttachment()) {
                        stringArray = cloneable2.getId();
                        String string3 = StringUtils.trimToNull((String)cloneable2.getExternalId());
                        if (string3 != null && !hashMap.containsKey(string3)) {
                            hashMap.put(string3, cloneable2);
                            continue;
                        }
                        try {
                            ImportExport.AttachmentService.deleteById(this.client, string2, stringArray.longValue());
                        }
                        catch (RequestFailedException requestFailedException) {
                            LOGGER.error("Can't remove old attachment (" + stringArray + ") " + "of property '" + string2 + "' (" + l3 + ") from the Webservice!");
                            if (requestFailedException.requestRefNumber != null) {
                                LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                            }
                            this.logMessagesAsError(requestFailedException.responseMessages);
                            LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                            this.putObjectMessage(string2, ExportMessage.Code.OBJECT_OLD_ATTACHMENT_NOT_REMOVED, requestFailedException);
                        }
                    }
                }
            }
            catch (RequestFailedException requestFailedException) {
                LOGGER.error("Can't get attachments of property '" + string2 + "' (" + l3 + ") from the Webservice!");
                if (requestFailedException.requestRefNumber != null) {
                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                }
                this.logMessagesAsError(requestFailedException.responseMessages);
                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                this.putObjectMessage(string2, ExportMessage.Code.OBJECT_WITHOUT_ATTACHMENTS, requestFailedException);
                bl = true;
            }
            if (bl) {
                long l4 = this.pool.getObjectSize(string, true) - this.pool.getObjectSize(string, false);
                this.addProgress(l4);
            } else {
                Object object3;
                Object object4;
                Object object5;
                cloneable = new ArrayList();
                TreeMap treeMap = new TreeMap(new AlphanumComparator());
                HashMap<String, File> hashMap2 = new HashMap<String, File>();
                for (String string4 : this.pool.getObjectAttachmentIds(string)) {
                    Object object6;
                    Attachment attachment = this.pool.getObjectAttachment(string, string4);
                    if (attachment == null) {
                        LOGGER.error("Can't read the XML file for attachment!");
                        this.putObjectMessage(string2, ExportMessage.Code.OBJECT_ATTACHMENT_NOT_SAVED, "Can't read the XML file for attachment!");
                        this.addProgress(this.pool.getObjectAttachmentSize(string, string4));
                        continue;
                    }
                    if (attachment instanceof Link) {
                        object5 = (Link)attachment;
                        object4 = ((Link)object5).getUrl();
                        Object object7 = object6 = object4 != null ? DigestUtils.sha1Hex((String)(l3 + "-" + ((URL)object4).toString())) : DigestUtils.sha1Hex((String)(l3 + "-" + string4));
                        if (cloneable.contains(object6)) continue;
                        cloneable.add(object6);
                        ((Attachment)object5).setExternalId((String)object6);
                    } else {
                        object5 = this.pool.getObjectAttachmentFile(string, attachment);
                        if (object5 == null && (object4 = this.pool.getObjectAttachmentURL(string, string4)) != null) {
                            try {
                                object5 = this.doDownloadFile((URL)object4);
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Can't download file from URL: " + object4);
                                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            }
                        }
                        if (object5 == null || !((File)object5).isFile()) {
                            LOGGER.error("Can't find file for attachment!");
                            this.putObjectMessage(string2, ExportMessage.Code.OBJECT_ATTACHMENT_NOT_SAVED, "Can't find file for attachment!");
                            this.addProgress(this.pool.getObjectAttachmentSize(string, string4));
                            continue;
                        }
                        hashMap2.put(string4, ((File)object5).getAbsoluteFile());
                        object6 = null;
                        try {
                            object6 = new FileInputStream((File)object5);
                            object3 = DigestUtils.sha1Hex((InputStream)object6);
                            object4 = DigestUtils.sha1Hex((String)(l3 + "-" + (String)object3));
                            if (cloneable.contains(object4)) continue;
                            cloneable.add(object4);
                            attachment.setExternalId((String)object4);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)object6);
                        }
                    }
                    treeMap.put(string4, attachment);
                }
                stringArray = hashMap.keySet().toArray(new String[hashMap.size()]);
                for (String string5 : stringArray) {
                    if (cloneable.contains(string5)) continue;
                    object5 = (Attachment)hashMap.remove(string5);
                    object4 = ((Attachment)object5).getId();
                    try {
                        ImportExport.AttachmentService.deleteById(this.client, string2, ((Long)object4).longValue());
                    }
                    catch (RequestFailedException requestFailedException) {
                        LOGGER.error("Can't remove old attachment (" + object4 + ") " + "of property '" + string2 + "' (" + l3 + ") from the Webservice!");
                        if (requestFailedException.requestRefNumber != null) {
                            LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                        }
                        this.logMessagesAsError(requestFailedException.responseMessages);
                        LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                        this.putObjectMessage(string2, ExportMessage.Code.OBJECT_OLD_ATTACHMENT_NOT_REMOVED, requestFailedException);
                    }
                }
                TreeMap treeMap2 = new TreeMap();
                for (Map.Entry attachment : treeMap.entrySet()) {
                    FileInputStream fileInputStream;
                    long l4;
                    String string6;
                    block80: {
                        Object object8;
                        int n;
                        string6 = (String)attachment.getKey();
                        object5 = (Attachment)attachment.getValue();
                        object4 = ((Attachment)object5).getExternalId();
                        try {
                            n = Math.abs(Integer.parseInt(string6));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.warn("Can't read attachment position!");
                            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                            n = 999;
                        }
                        if (object5 instanceof Link) {
                            object3 = (Link)object5;
                            try {
                                if (hashMap.containsKey(object4)) {
                                    object8 = (Attachment)hashMap.get(object4);
                                    l4 = ((Attachment)object8).getId();
                                    ImportExport.AttachmentService.putById(this.client, l3, l4, (Attachment)object3);
                                    hashMap.remove(object4);
                                } else {
                                    ImportExport.AttachmentService.post(this.client, string2, (Attachment)object5, null, null, null);
                                }
                            }
                            catch (RequestFailedException requestFailedException) {
                                LOGGER.error("Can't save attachment of property '" + string2 + "' (" + l3 + ") to the Webservice!");
                                if (requestFailedException.requestRefNumber != null) {
                                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                                }
                                this.logMessagesAsError(requestFailedException.responseMessages);
                                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                                this.putObjectMessage(string2, ExportMessage.Code.OBJECT_ATTACHMENT_NOT_SAVED, requestFailedException);
                            }
                            this.addProgress(this.pool.getObjectAttachmentSize(string, string6));
                            continue;
                        }
                        object3 = (File)hashMap2.get(string6);
                        if (object3 == null || !((File)object3).isFile()) {
                            LOGGER.error("Can't find file for attachment!");
                            this.putObjectMessage(string2, ExportMessage.Code.OBJECT_ATTACHMENT_NOT_SAVED, "Can't find file for attachment!");
                            this.addProgress(this.pool.getObjectAttachmentSize(string, string6));
                            continue;
                        }
                        object8 = ((File)object3).getName();
                        l4 = ((File)object3).length();
                        fileInputStream = null;
                        try {
                            long l5;
                            Object object9;
                            if (hashMap.containsKey(object4)) {
                                object9 = (Attachment)hashMap.get(object4);
                                l5 = ((Attachment)object9).getId();
                                ImportExport.AttachmentService.putById(this.client, l3, l5, (Attachment)object5);
                                hashMap.remove(object4);
                                if (!StreamingVideo.class.isInstance(object5)) {
                                    while (treeMap2.containsKey(n)) {
                                        ++n;
                                    }
                                    treeMap2.put(n, l5);
                                }
                                break block80;
                            }
                            object9 = object5 instanceof PDFDocument ? "application/pdf" : (object5 instanceof Picture ? (((String)object8).toLowerCase().endsWith(".png") ? "image/png" : (((String)object8).toLowerCase().endsWith(".gif") ? "image/gif" : "image/jpeg")) : null);
                            fileInputStream = new FileInputStream((File)object3);
                            if (object5 instanceof StreamingVideo) {
                                String string7 = ImportExport.VideoUploadService.doVideoUpload(this.client, fileInputStream, (String)object8, l4);
                                StreamingVideo streamingVideo = (StreamingVideo)object5;
                                streamingVideo.setVideoId(string7);
                                ImportExport.AttachmentService.post(this.client, string2, (Attachment)streamingVideo, null, null, null);
                                break block80;
                            }
                            l5 = ImportExport.AttachmentService.post(this.client, string2, (Attachment)object5, (InputStream)fileInputStream, (String)object8, (String)object9);
                            while (treeMap2.containsKey(n)) {
                                ++n;
                            }
                            treeMap2.put(n, l5);
                        }
                        catch (RequestFailedException requestFailedException) {
                            try {
                                LOGGER.error("Can't save attachment of property '" + string2 + "' (" + l3 + ") to the Webservice!");
                                if (requestFailedException.requestRefNumber != null) {
                                    LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                                }
                                this.logMessagesAsError(requestFailedException.responseMessages);
                                LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                                this.putObjectMessage(string2, ExportMessage.Code.OBJECT_ATTACHMENT_NOT_SAVED, requestFailedException);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(fileInputStream);
                                this.addProgress(this.pool.getObjectAttachmentSize(string, string6) + l4);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)fileInputStream);
                            this.addProgress(this.pool.getObjectAttachmentSize(string, string6) + l4);
                            continue;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fileInputStream);
                    this.addProgress(this.pool.getObjectAttachmentSize(string, string6) + l4);
                }
                for (Attachment attachment : hashMap.values()) {
                    Long l6 = attachment.getId();
                    try {
                        ImportExport.AttachmentService.deleteById(this.client, string2, (long)l6);
                    }
                    catch (RequestFailedException requestFailedException) {
                        LOGGER.error("Can't remove untouched attachment (" + l6 + ") " + "of property '" + string2 + "' (" + l3 + ") from the Webservice!");
                        if (requestFailedException.requestRefNumber != null) {
                            LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                        }
                        this.logMessagesAsError(requestFailedException.responseMessages);
                        LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                        this.putObjectMessage(string2, ExportMessage.Code.OBJECT_OLD_ATTACHMENT_NOT_REMOVED, requestFailedException);
                    }
                }
                if (!treeMap2.isEmpty()) {
                    org.openestate.is24.restapi.xml.attachmentsorder.List list = objectFactory2.createList();
                    for (Long l7 : treeMap2.values()) {
                        list.getAttachmentId().add(l7);
                    }
                    try {
                        ImportExport.AttachmentsOrderService.put(this.client, string2, list);
                    }
                    catch (RequestFailedException requestFailedException) {
                        LOGGER.error("Can't order attachments of property '" + string2 + "' (" + l3 + ")!");
                        if (requestFailedException.requestRefNumber != null) {
                            LOGGER.error("> referring request: " + requestFailedException.requestRefNumber);
                        }
                        this.logMessagesAsError(requestFailedException.responseMessages);
                        LOGGER.error("> " + requestFailedException.getLocalizedMessage(), (Throwable)requestFailedException);
                        this.putObjectMessage(string2, ExportMessage.Code.OBJECT_UNORDERED_ATTACHMENTS, requestFailedException);
                    }
                }
            }
            return l3;
        }
        catch (JAXBException jAXBException) {
            throw new IOExceptionWithCause("Can't read / write XML while communicating with the Webservice!", (Throwable)jAXBException);
        }
        catch (OAuthException oAuthException) {
            throw new IOExceptionWithCause("Authorization failed!", (Throwable)oAuthException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWithCause("Communication failed!", (Throwable)iOException);
        }
    }

    public ExportMessage[] export(AbstractClient abstractClient, ExportPool exportPool, boolean bl, boolean bl2) throws IOException {
        ToString2 toString2;
        int n;
        this.client = abstractClient;
        this.pool = exportPool;
        this.messages.clear();
        this.savedContactIds.clear();
        this.duplicatedContactIds.clear();
        this.totalProgress = this.pool.getTotalSize();
        this.setProgress(0L);
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        Object[] objectArray = this.pool.getContactIds();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            LOGGER.info("updating contacts");
            n = 0;
            for (Object object : objectArray) {
                ++n;
                toString2 = this.pool.getContact((String)object);
                if (toString2 == null) {
                    this.addProgress(this.pool.getContactSize((String)object, true));
                    this.putGeneralMessage(ExportMessage.Code.XML_NOT_READABLE, "Can't read XML file for contact '" + (String)object + "'!");
                    continue;
                }
                if (this.canIgnoreContact((RealtorContactDetails)toString2, (String)object)) {
                    LOGGER.info("[" + n + " / " + objectArray.length + "] " + "ignoring contact '" + toString2.getExternalId() + "'");
                    this.savedContactIds.add(toString2.getExternalId());
                    this.addProgress(this.pool.getContactSize((String)object, true));
                    continue;
                }
                LOGGER.info("[" + n + " / " + objectArray.length + "] " + "updating contact '" + toString2.getExternalId() + "'");
                this.doUpdateContact((RealtorContactDetails)toString2, (String)object);
            }
        }
        if (!ArrayUtils.isEmpty((Object[])(objectArray = this.pool.getObjectIds()))) {
            LOGGER.info("updating objects");
            n = 0;
            for (Object object : objectArray) {
                ++n;
                toString2 = this.pool.getObject((String)object);
                if (toString2 == null) {
                    this.addProgress(this.pool.getObjectSize((String)object, true));
                    this.putGeneralMessage(ExportMessage.Code.XML_NOT_READABLE, "Can't read XML file for property '" + (String)object + "'!");
                    continue;
                }
                if (this.canIgnoreObject((RealEstate)toString2, (String)object)) {
                    LOGGER.info("[" + n + " / " + objectArray.length + "] " + "ignoring object '" + toString2.getExternalId() + "'");
                    this.addProgress(this.pool.getObjectSize((String)object, true));
                    continue;
                }
                LOGGER.info("[" + n + " / " + objectArray.length + "] " + "updating object '" + toString2.getExternalId() + "'");
                Long l = this.doUpdateObject((RealEstate)toString2, (String)object);
                if (l == null) continue;
                hashMap.put(l, StringUtils.trimToNull((String)toString2.getExternalId()));
            }
        }
        if (!ArrayUtils.isEmpty((Object[])(objectArray = this.pool.getObjectIdsForRemoval()))) {
            LOGGER.info("removing objects");
            n = 0;
            for (Object object : objectArray) {
                ++n;
                if (bl) {
                    LOGGER.info("[" + n + " / " + objectArray.length + "] " + "archiving object '" + (String)object + "'");
                    this.doArchiveObject((String)object);
                    continue;
                }
                LOGGER.info("[" + n + " / " + objectArray.length + "] " + "removing object '" + (String)object + "'");
                this.doRemoveObject((String)object);
            }
        }
        if (bl2) {
            LOGGER.info("looking for untouched objects");
            Map<Long, String> map = this.doListUntouchedObjects();
            int n2 = map.size();
            int n3 = 0;
            for (Map.Entry<Long, String> entry : map.entrySet()) {
                ++n3;
                long l = entry.getKey();
                String string = entry.getValue();
                if (bl) {
                    LOGGER.info("[" + n3 + " / " + n2 + "] " + "archiving untouched object '" + string + "' (" + l + ")");
                    this.doArchiveObject(l, string);
                    continue;
                }
                LOGGER.info("[" + n3 + " / " + n2 + "] " + "removing untouched object '" + string + "' (" + l + ")");
                this.doRemoveObject(l, string);
            }
        }
        if (!hashMap.isEmpty()) {
            LOGGER.info("loading publish channels");
            PublishChannels publishChannels = this.doLoadPublishChannels();
            LOGGER.info("publishing objects");
            int n4 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                Long l = (Long)entry.getKey();
                String string = (String)entry.getValue();
                LOGGER.info("[" + ++n4 + " / " + hashMap.size() + "] " + "publishing object '" + string + "' (" + l + ")");
                this.doPublishObject(l, string, publishChannels);
            }
        }
        return this.getMessages();
    }

    protected final AbstractClient getClient() {
        return this.client;
    }

    public final ExportMessage[] getMessages() {
        return this.messages.toArray(new ExportMessage[this.messages.size()]);
    }

    public final ExportMessage[] getMessagesForContact(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return new ExportMessage[0];
        }
        ArrayList<ExportMessage> arrayList = new ArrayList<ExportMessage>();
        for (ExportMessage exportMessage : this.messages) {
            if (!string.equals(exportMessage.getContactId())) continue;
            arrayList.add(exportMessage);
        }
        return arrayList.toArray(new ExportMessage[arrayList.size()]);
    }

    public final ExportMessage[] getMessagesForObject(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return new ExportMessage[0];
        }
        ArrayList<ExportMessage> arrayList = new ArrayList<ExportMessage>();
        for (ExportMessage exportMessage : this.messages) {
            if (!string.equals(exportMessage.getObjectId())) continue;
            arrayList.add(exportMessage);
        }
        return arrayList.toArray(new ExportMessage[arrayList.size()]);
    }

    public final ExportMessage[] getMessagesGeneral() {
        ArrayList<ExportMessage> arrayList = new ArrayList<ExportMessage>();
        for (ExportMessage exportMessage : this.messages) {
            if (!exportMessage.isGeneral()) continue;
            arrayList.add(exportMessage);
        }
        return arrayList.toArray(new ExportMessage[arrayList.size()]);
    }

    protected final ExportPool getPool() {
        return this.pool;
    }

    protected final long getProgress() {
        return this.progress;
    }

    protected final long getTotalProgress() {
        return this.totalProgress;
    }

    public boolean isUseNewEnergySourceEnev2014Values() {
        return this.useNewEnergySourceEnev2014Values;
    }

    private void logMessagesAsError(Messages messages) {
        if (messages == null || messages.getMessage().isEmpty()) {
            return;
        }
        for (Message message : messages.getMessage()) {
            LOGGER.error("> " + (Object)((Object)message.getMessageCode()) + " | " + message.getMessage());
        }
    }

    protected void progressUpdated(long l, long l2) {
    }

    protected final void putContactMessage(String string, ExportMessage.Code code, String string2) {
        this.putContactMessage(string, code, string2, null);
    }

    protected void putContactMessage(String string, ExportMessage.Code code, String string2, String string3) {
        this.messages.add(ExportMessage.newContactMessage(string, code, string2, string3));
    }

    protected final void putContactMessage(String string, ExportMessage.Code code, RequestFailedException requestFailedException) {
        if (requestFailedException == null || requestFailedException.responseMessages == null) {
            return;
        }
        for (Message message : requestFailedException.responseMessages.getMessage()) {
            MessageCode messageCode = message.getMessageCode();
            String string2 = StringUtils.trimToNull((String)message.getMessage());
            String string3 = "";
            if (messageCode != null) {
                string3 = string3 + messageCode.value();
            }
            if (string2 != null) {
                if (!StringUtils.isBlank((CharSequence)string3)) {
                    string3 = string3 + " | ";
                }
                string3 = string3 + string2;
            }
            this.putContactMessage(string, code, string3, requestFailedException.requestRefNumber);
        }
    }

    protected final void putGeneralMessage(ExportMessage.Code code, String string) {
        this.putGeneralMessage(code, string, null);
    }

    protected void putGeneralMessage(ExportMessage.Code code, String string, String string2) {
        this.messages.add(ExportMessage.newGeneralMessage(string, code, string2));
    }

    protected final void putGeneralMessage(ExportMessage.Code code, RequestFailedException requestFailedException) {
        if (requestFailedException == null || requestFailedException.responseMessages == null) {
            return;
        }
        for (Message message : requestFailedException.responseMessages.getMessage()) {
            MessageCode messageCode = message.getMessageCode();
            String string = StringUtils.trimToNull((String)message.getMessage());
            String string2 = "";
            if (messageCode != null) {
                string2 = string2 + messageCode.value();
            }
            if (string != null) {
                if (!StringUtils.isBlank((CharSequence)string2)) {
                    string2 = string2 + " | ";
                }
                string2 = string2 + string;
            }
            this.putGeneralMessage(code, string2, requestFailedException.requestRefNumber);
        }
    }

    protected final void putObjectMessage(String string, ExportMessage.Code code, String string2) {
        this.putObjectMessage(string, code, string2, null);
    }

    protected void putObjectMessage(String string, ExportMessage.Code code, String string2, String string3) {
        this.messages.add(ExportMessage.newObjectMessage(string, code, string2, string3));
    }

    protected final void putObjectMessage(String string, ExportMessage.Code code, RequestFailedException requestFailedException) {
        if (requestFailedException == null || requestFailedException.responseMessages == null) {
            return;
        }
        for (Message message : requestFailedException.responseMessages.getMessage()) {
            MessageCode messageCode = message.getMessageCode();
            String string2 = StringUtils.trimToNull((String)message.getMessage());
            String string3 = "";
            if (messageCode != null) {
                string3 = string3 + messageCode.value();
            }
            if (string2 != null) {
                if (!StringUtils.isBlank((CharSequence)string3)) {
                    string3 = string3 + " | ";
                }
                string3 = string3 + string2;
            }
            this.putObjectMessage(string, code, string3, requestFailedException.requestRefNumber);
        }
    }

    protected final void setProgress(long l) {
        this.progress = (l = Math.abs(l)) <= this.totalProgress ? l : this.totalProgress;
        this.progressUpdated(this.progress, this.totalProgress);
    }

    public void setUseNewEnergySourceEnev2014Values(boolean bl) {
        this.useNewEnergySourceEnev2014Values = bl;
    }
}

