/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.utils.RequestMethod;
import org.openestate.is24.restapi.utils.Response;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.attachmentsorder.List;
import org.openestate.is24.restapi.xml.attachmentsorder.ObjectFactory;
import org.openestate.is24.restapi.xml.common.Attachment;
import org.openestate.is24.restapi.xml.common.Attachments;
import org.openestate.is24.restapi.xml.common.Message;
import org.openestate.is24.restapi.xml.common.MessageCode;
import org.openestate.is24.restapi.xml.common.Messages;
import org.openestate.is24.restapi.xml.common.PublishChannels;
import org.openestate.is24.restapi.xml.common.PublishObject;
import org.openestate.is24.restapi.xml.common.PublishObjects;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.common.RealtorContactDetailsList;
import org.openestate.is24.restapi.xml.realestatecounts.RealEstateCounts;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.openestate.is24.restapi.xml.realestates.RealEstates;
import org.openestate.is24.restapi.xml.videoupload.VideoUploadTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportExport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportExport.class);
    public static final int PUBLISH_CHANNEL_IS24_ID = 10000;
    public static final String PUBLISH_CHANNEL_IS24_TITLE = "Immobilienscout24";
    public static final int PUBLISH_CHANNEL_HOMEPAGE_ID = 10001;
    public static final String PUBLISH_CHANNEL_HOMEPAGE_TITLE = "Homepage";
    public static final int MAXIMAL_FILES_PER_PROPERTY = 30;
    public static final int MAXIMAL_VIDEOS_PER_PROPERTY = 1;

    private ImportExport() {
    }

    public static final class VideoUploadService {
        private VideoUploadService() {
        }

        public static String doVideoUpload(AbstractClient abstractClient, InputStream inputStream, String string, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            VideoUploadTicket videoUploadTicket = VideoUploadService.get(abstractClient);
            if (videoUploadTicket == null) {
                throw new IOException("No upload ticket was found!");
            }
            Response response = abstractClient.sendVideoUploadRequest(videoUploadTicket.getUploadUrl(), RequestMethod.POST, videoUploadTicket.getAuth(), inputStream, string, l);
            if (response.statusCode == 200 || response.statusCode == 201) {
                return videoUploadTicket.getVideoId();
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static VideoUploadTicket get(AbstractClient abstractClient) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/videouploadticket";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (VideoUploadTicket)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }

    public static final class RealEstatesCountsService {
        public static RealEstateCounts get(AbstractClient abstractClient) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestatecounts";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (RealEstateCounts)XmlUtils.unmarshal(response.body);
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }

    public static final class RealEstateService {
        private RealEstateService() {
        }

        public static Messages deleteByExternalId(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string);
            return RealEstateService._delete(abstractClient, string2);
        }

        public static Messages deleteByIs24Id(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l;
            return RealEstateService._delete(abstractClient, string);
        }

        private static Messages _delete(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.DELETE, null);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static RealEstates getAll(AbstractClient abstractClient, String string, String string2, int n, int n2, boolean bl) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string3 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate";
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((string = AbstractClient.getUrlEncodedValue(string)) != null) {
                arrayList.add("publishchannel=" + string);
            }
            string2 = AbstractClient.getUrlEncodedValue(string2);
            if (string != null) {
                arrayList.add("notinpublishchannel=" + string2);
            }
            if (n >= 1 && n <= 100) {
                arrayList.add("pagesize=" + n);
            }
            if (n2 > 1) {
                arrayList.add("pagenumber=" + n2);
            }
            arrayList.add("archivedobjectsincluded=" + String.valueOf(bl));
            if (!arrayList.isEmpty()) {
                string3 = string3 + "?" + StringUtils.join(arrayList, (String)"&");
            }
            Response response = abstractClient.sendXmlRequest(new URL(string3), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (RealEstates)XmlUtils.unmarshal(response.body);
            }
            String string4 = StringUtils.trimToNull((String)response.statusMessage);
            if (string4 == null) {
                string4 = "Request failed!";
            }
            string4 = string4 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string4);
        }

        public static RealEstate getByExternalId(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string);
            return RealEstateService._get(abstractClient, string2);
        }

        public static RealEstate getByIs24Id(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l;
            return RealEstateService._get(abstractClient, string);
        }

        private static RealEstate _get(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (RealEstate)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static long post(AbstractClient abstractClient, RealEstate realEstate) throws IOException, OAuthException, JAXBException, RequestFailedException {
            return RealEstateService.post(abstractClient, realEstate, true);
        }

        public static long post(AbstractClient abstractClient, RealEstate realEstate, boolean bl) throws IOException, OAuthException, JAXBException, RequestFailedException {
            if (realEstate == null) {
                throw new NullPointerException("No property was provided!");
            }
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate";
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("usenewenergysourceenev2014values=true");
            }
            if (!arrayList.isEmpty()) {
                string = string + "?" + StringUtils.join(arrayList, (String)"&");
            }
            String string2 = XmlUtils.marshal(realEstate, AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.POST, string2);
            if (response.statusCode == 201) {
                Messages messages = (Messages)XmlUtils.unmarshal(response.body);
                if (messages != null) {
                    for (Message message : messages.getMessage()) {
                        String string3;
                        if (!MessageCode.MESSAGE_RESOURCE_CREATED.equals((Object)message.getMessageCode()) || (string3 = StringUtils.trimToNull((String)message.getId())) == null) continue;
                        try {
                            return Long.parseLong(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.warn("Can't determine ID of the created contact person!");
                            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                            return 0L;
                        }
                    }
                }
                LOGGER.warn("Can't determine ID of the created contact person!");
                return 0L;
            }
            String string4 = StringUtils.trimToNull((String)response.statusMessage);
            if (string4 == null) {
                string4 = "Request failed!";
            }
            string4 = string4 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string4);
        }

        public static Messages putByExternalId(AbstractClient abstractClient, RealEstate realEstate, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            return RealEstateService.putByExternalId(abstractClient, realEstate, string, true);
        }

        public static Messages putByExternalId(AbstractClient abstractClient, RealEstate realEstate, String string, boolean bl) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("usenewenergysourceenev2014values=true");
            }
            if (!arrayList.isEmpty()) {
                string2 = string2 + "?" + StringUtils.join(arrayList, (String)"&");
            }
            return RealEstateService._put(abstractClient, string2, realEstate);
        }

        public static Messages putByIs24Id(AbstractClient abstractClient, RealEstate realEstate, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            return RealEstateService.putByIs24Id(abstractClient, realEstate, l, true);
        }

        public static Messages putByIs24Id(AbstractClient abstractClient, RealEstate realEstate, long l, boolean bl) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("usenewenergysourceenev2014values=true");
            }
            if (!arrayList.isEmpty()) {
                string = string + "?" + StringUtils.join(arrayList, (String)"&");
            }
            return RealEstateService._put(abstractClient, string, realEstate);
        }

        private static Messages _put(AbstractClient abstractClient, String string, RealEstate realEstate) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = XmlUtils.marshal(realEstate, AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.PUT, string2);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }
    }

    public static final class PublishChannelService {
        private PublishChannelService() {
        }

        public static PublishChannels get(AbstractClient abstractClient) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/publishchannel";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (PublishChannels)XmlUtils.unmarshal(response.body);
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }

    public static final class PublishService {
        private PublishService() {
        }

        public static Messages delete(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/publish/" + AbstractClient.getUrlEncodedValue(string);
            Response response = abstractClient.sendXmlRequest(new URL(string2), RequestMethod.DELETE, null);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }

        public static PublishObjects delete(AbstractClient abstractClient, String[] stringArray) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/publish/list";
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (!ArrayUtils.isEmpty((Object[])stringArray)) {
                for (String string2 : stringArray) {
                    if ((string2 = StringUtils.trimToNull((String)string2)) == null) continue;
                    arrayList2.add(AbstractClient.getUrlEncodedValue(string2));
                }
            }
            if (arrayList2.isEmpty()) {
                return null;
            }
            arrayList.add("publishids=" + StringUtils.join(arrayList2, (String)","));
            if (!arrayList.isEmpty()) {
                string = string + "?" + StringUtils.join(arrayList, (String)"&");
            }
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.DELETE, null);
            if (response.statusCode == 200) {
                return (PublishObjects)XmlUtils.unmarshal(response.body);
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }

        public static PublishObjects get(AbstractClient abstractClient, long l, long l2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/publish";
            ArrayList<String> arrayList = new ArrayList<String>();
            if (l > 0L) {
                arrayList.add("realestate=" + l);
            }
            if (l2 > 0L) {
                arrayList.add("publishchannel=" + l2);
            }
            if (!arrayList.isEmpty()) {
                string = string + "?" + StringUtils.join(arrayList, (String)"&");
            }
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (PublishObjects)XmlUtils.unmarshal(response.body);
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static PublishObject getById(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/publish/" + AbstractClient.getUrlEncodedValue(string);
            Response response = abstractClient.sendXmlRequest(new URL(string2), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (PublishObject)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }

        public static String post(AbstractClient abstractClient, PublishObject publishObject) throws IOException, OAuthException, JAXBException, RequestFailedException {
            if (publishObject == null) {
                throw new NullPointerException("No object was provided for publishing!");
            }
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/publish";
            String string2 = XmlUtils.marshal(publishObject, AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.POST, string2);
            if (response.statusCode == 201) {
                Messages messages = (Messages)XmlUtils.unmarshal(response.body);
                if (messages != null) {
                    for (Message message : messages.getMessage()) {
                        String string3;
                        if (!MessageCode.MESSAGE_RESOURCE_CREATED.equals((Object)message.getMessageCode()) || (string3 = StringUtils.trimToNull((String)message.getId())) == null) continue;
                        return string3;
                    }
                }
                LOGGER.warn("Can't determine ID of the created publishing!");
                return null;
            }
            String string4 = StringUtils.trimToNull((String)response.statusMessage);
            if (string4 == null) {
                string4 = "Request failed!";
            }
            string4 = string4 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string4);
        }

        public static PublishObjects post(AbstractClient abstractClient, PublishObjects publishObjects) throws IOException, OAuthException, JAXBException, RequestFailedException {
            if (publishObjects == null) {
                throw new NullPointerException("No objects were provided for publishing!");
            }
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/publish/list";
            String string2 = XmlUtils.marshal(publishObjects, AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.POST, string2);
            if (response.statusCode == 201) {
                return (PublishObjects)XmlUtils.unmarshal(response.body);
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }
    }

    public static final class ContactAddressService {
        private ContactAddressService() {
        }

        public static Messages deleteByExternalId(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            return ContactAddressService.deleteByExternalId(abstractClient, string, null);
        }

        public static Messages deleteByExternalId(AbstractClient abstractClient, String string, String string2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string3 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact/ext-" + AbstractClient.getUrlEncodedValue(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((string2 = StringUtils.trimToNull((String)string2)) != null) {
                arrayList.add("assigntocontactid=" + AbstractClient.getUrlEncodedValue(string2));
            }
            if (!arrayList.isEmpty()) {
                string3 = string3 + "?" + StringUtils.join(arrayList, (String)"&");
            }
            return ContactAddressService._delete(abstractClient, string3);
        }

        public static Messages deleteByIs24Id(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            return ContactAddressService.deleteByIs24Id(abstractClient, l, 0L);
        }

        public static Messages deleteByIs24Id(AbstractClient abstractClient, long l, long l2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact/" + l;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (l2 > 0L) {
                arrayList.add("assigntocontactid=" + l2);
            }
            if (!arrayList.isEmpty()) {
                string = string + "?" + StringUtils.join(arrayList, (String)"&");
            }
            return ContactAddressService._delete(abstractClient, string);
        }

        private static Messages _delete(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.DELETE, null);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static RealtorContactDetailsList getAll(AbstractClient abstractClient) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (RealtorContactDetailsList)XmlUtils.unmarshal(response.body);
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static RealtorContactDetails getByExternalId(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact/ext-" + AbstractClient.getUrlEncodedValue(string);
            return ContactAddressService._get(abstractClient, string2);
        }

        public static RealtorContactDetails getByIs24Id(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact/" + l;
            return ContactAddressService._get(abstractClient, string);
        }

        private static RealtorContactDetails _get(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (RealtorContactDetails)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static long post(AbstractClient abstractClient, RealtorContactDetails realtorContactDetails) throws IOException, OAuthException, JAXBException, RequestFailedException {
            if (realtorContactDetails == null) {
                throw new NullPointerException("No contact was provided!");
            }
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact";
            String string2 = XmlUtils.marshal(realtorContactDetails, AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.POST, string2);
            if (response.statusCode == 201) {
                Messages messages = (Messages)XmlUtils.unmarshal(response.body);
                if (messages != null) {
                    for (Message message : messages.getMessage()) {
                        String string3;
                        if (!MessageCode.MESSAGE_RESOURCE_CREATED.equals((Object)message.getMessageCode()) || (string3 = StringUtils.trimToNull((String)message.getId())) == null) continue;
                        try {
                            return Long.parseLong(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.warn("Can't determine ID of the created contact person!");
                            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                            return 0L;
                        }
                    }
                }
                LOGGER.warn("Can't determine ID of the created contact person!");
                return 0L;
            }
            String string4 = StringUtils.trimToNull((String)response.statusMessage);
            if (string4 == null) {
                string4 = "Request failed!";
            }
            string4 = string4 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string4);
        }

        public static Messages putByExternalId(AbstractClient abstractClient, RealtorContactDetails realtorContactDetails, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact/ext-" + AbstractClient.getUrlEncodedValue(string);
            return ContactAddressService._put(abstractClient, string2, realtorContactDetails);
        }

        public static Messages putByIs24Id(AbstractClient abstractClient, RealtorContactDetails realtorContactDetails, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/contact/" + l;
            return ContactAddressService._put(abstractClient, string, realtorContactDetails);
        }

        private static Messages _put(AbstractClient abstractClient, String string, RealtorContactDetails realtorContactDetails) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = XmlUtils.marshal(realtorContactDetails, AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.PUT, string2);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }
    }

    public static final class AttachmentsOrderService {
        public static List get(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment/attachmentsorder";
            return AttachmentsOrderService._get(abstractClient, string2);
        }

        public static List get(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment/attachmentsorder";
            return AttachmentsOrderService._get(abstractClient, string);
        }

        private static List _get(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (List)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Messages put(AbstractClient abstractClient, String string, List list) throws IOException, OAuthException, JAXBException, RequestFailedException {
            if (list == null) {
                throw new NullPointerException("No object was provided for publishing!");
            }
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment/attachmentsorder";
            return AttachmentsOrderService._put(abstractClient, string2, list);
        }

        public static Messages put(AbstractClient abstractClient, long l, List list) throws IOException, OAuthException, JAXBException, RequestFailedException {
            if (list == null) {
                throw new NullPointerException("No object was provided for publishing!");
            }
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment/attachmentsorder";
            return AttachmentsOrderService._put(abstractClient, string, list);
        }

        private static Messages _put(AbstractClient abstractClient, String string, List list) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = XmlUtils.marshal(new ObjectFactory().createAttachmentsorder(list), AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.PUT, string2);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }
    }

    public static final class AttachmentService {
        private AttachmentService() {
        }

        public static Messages deleteById(AbstractClient abstractClient, String string, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment/" + l;
            return AttachmentService._deleteById(abstractClient, string2);
        }

        public static Messages deleteById(AbstractClient abstractClient, long l, long l2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment/" + l2;
            return AttachmentService._deleteById(abstractClient, string);
        }

        private static Messages _deleteById(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.DELETE, null);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Attachments getAll(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment";
            return AttachmentService._getAll(abstractClient, string2);
        }

        public static Attachments getAll(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment";
            return AttachmentService._getAll(abstractClient, string);
        }

        private static Attachments _getAll(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Attachments)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Attachment getById(AbstractClient abstractClient, String string, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment/" + l;
            return AttachmentService._getById(abstractClient, string2);
        }

        public static Attachment getById(AbstractClient abstractClient, String string, String string2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string3 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment?externalId=" + AbstractClient.getUrlEncodedValue(string2);
            return AttachmentService._getById(abstractClient, string3);
        }

        public static Attachment getById(AbstractClient abstractClient, long l, long l2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment/" + l2;
            return AttachmentService._getById(abstractClient, string);
        }

        public static Attachment getById(AbstractClient abstractClient, long l, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment?externalId=" + AbstractClient.getUrlEncodedValue(string);
            return AttachmentService._getById(abstractClient, string2);
        }

        private static Attachment _getById(AbstractClient abstractClient, String string) throws IOException, OAuthException, JAXBException, RequestFailedException {
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Attachment)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static long post(AbstractClient abstractClient, String string, Attachment attachment, InputStream inputStream, String string2, String string3) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string4 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment";
            return AttachmentService._post(abstractClient, string4, attachment, inputStream, string2, string3);
        }

        public static long post(AbstractClient abstractClient, long l, Attachment attachment, InputStream inputStream, String string, String string2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string3 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment";
            return AttachmentService._post(abstractClient, string3, attachment, inputStream, string, string2);
        }

        private static long _post(AbstractClient abstractClient, String string, Attachment attachment, InputStream inputStream, String string2, String string3) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string4 = XmlUtils.marshal(attachment, AbstractClient.getEncoding());
            Response response = inputStream != null ? abstractClient.sendXmlAttachmentRequest(new URL(string), RequestMethod.POST, string4, inputStream, string2, string3) : abstractClient.sendXmlRequest(new URL(string), RequestMethod.POST, string4);
            if (response.statusCode == 201) {
                Messages messages = (Messages)XmlUtils.unmarshal(response.body);
                if (messages != null) {
                    for (Message message : messages.getMessage()) {
                        String string5;
                        if (!MessageCode.MESSAGE_RESOURCE_CREATED.equals((Object)message.getMessageCode()) || (string5 = StringUtils.trimToNull((String)message.getId())) == null) continue;
                        try {
                            return Long.parseLong(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.warn("Can't determine ID of the created attachment!");
                            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                            return 0L;
                        }
                    }
                }
                LOGGER.warn("Can't determine ID of the created attachment!");
                return 0L;
            }
            String string6 = StringUtils.trimToNull((String)response.statusMessage);
            if (string6 == null) {
                string6 = "Request failed!";
            }
            string6 = string6 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string6);
        }

        public static Messages putById(AbstractClient abstractClient, String string, long l, Attachment attachment) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/ext-" + AbstractClient.getUrlEncodedValue(string) + "/attachment/" + l;
            return AttachmentService._putById(abstractClient, string2, attachment);
        }

        public static Messages putById(AbstractClient abstractClient, long l, long l2, Attachment attachment) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/offer/v1.0/user/me/realestate/" + l + "/attachment/" + l2;
            return AttachmentService._putById(abstractClient, string, attachment);
        }

        private static Messages _putById(AbstractClient abstractClient, String string, Attachment attachment) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string2 = XmlUtils.marshal(attachment, AbstractClient.getEncoding());
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.PUT, string2);
            if (response.statusCode == 200) {
                return (Messages)XmlUtils.unmarshal(response.body);
            }
            String string3 = StringUtils.trimToNull((String)response.statusMessage);
            if (string3 == null) {
                string3 = "Request failed!";
            }
            string3 = string3 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string3);
        }
    }
}

