/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi;

import java.io.IOException;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.utils.RequestMethod;
import org.openestate.is24.restapi.utils.Response;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.common.City;
import org.openestate.is24.restapi.xml.common.Continent;
import org.openestate.is24.restapi.xml.common.Country;
import org.openestate.is24.restapi.xml.common.Quarter;
import org.openestate.is24.restapi.xml.common.Region;
import org.openestate.is24.restapi.xml.gis.Cities;
import org.openestate.is24.restapi.xml.gis.Continents;
import org.openestate.is24.restapi.xml.gis.Countries;
import org.openestate.is24.restapi.xml.gis.Quarters;
import org.openestate.is24.restapi.xml.gis.Regions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GIS {
    private static final Logger LOGGER = LoggerFactory.getLogger(GIS.class);
    public static final int EUROPE = 1;
    public static final int ASIA = 2;
    public static final int AFRICA = 3;
    public static final int AMERICA = 4;
    public static final int AUSTRALIA = 5;
    public static final int ANTARCTICA = 6;

    private GIS() {
    }

    public static final class RegionService {
        private RegionService() {
        }

        public static Region get(AbstractClient abstractClient, long l, long l2, long l3) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country/" + l2 + "/region/" + l3;
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Region)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Regions getAll(AbstractClient abstractClient, long l, long l2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country/" + l2 + "/region";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Regions)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }

    public static final class QuarterService {
        private QuarterService() {
        }

        public static Quarter get(AbstractClient abstractClient, long l, long l2, long l3, long l4, long l5) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country/" + l2 + "/region/" + l3 + "/city/" + l4 + "/quarter/" + l5;
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Quarter)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Quarters getAll(AbstractClient abstractClient, long l, long l2, long l3, long l4) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country/" + l2 + "/region/" + l3 + "/city/" + l4 + "/quarter";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Quarters)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }

    public static final class CountryService {
        private CountryService() {
        }

        public static Country get(AbstractClient abstractClient, long l, long l2) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country/" + l2;
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Country)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Countries getAll(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Countries)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }

    public static final class ContinentService {
        private ContinentService() {
        }

        public static Continent get(AbstractClient abstractClient, long l) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l;
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Continent)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Continents getAll(AbstractClient abstractClient) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Continents)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }

    public static final class CityService {
        private CityService() {
        }

        public static City get(AbstractClient abstractClient, long l, long l2, long l3, long l4) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country/" + l2 + "/region/" + l3 + "/city/" + l4;
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (City)((JAXBElement)XmlUtils.unmarshal(response.body)).getValue();
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }

        public static Cities getAll(AbstractClient abstractClient, long l, long l2, long l3) throws IOException, OAuthException, JAXBException, RequestFailedException {
            String string = abstractClient.getApiBaseUrl() + "/api/gis/v1.0" + "/continent/" + l + "/country/" + l2 + "/region/" + l3 + "/city";
            Response response = abstractClient.sendXmlRequest(new URL(string), RequestMethod.GET, null);
            if (response.statusCode == 200) {
                return (Cities)XmlUtils.unmarshal(response.body);
            }
            if (response.statusCode == 404) {
                return null;
            }
            String string2 = StringUtils.trimToNull((String)response.statusMessage);
            if (string2 == null) {
                string2 = "Request failed!";
            }
            string2 = string2 + " (" + response.statusCode + ")";
            throw new RequestFailedException(response, string2);
        }
    }
}

