/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import com.thedeanda.lorem.LoremIpsum;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.xml.common.Address;
import org.openestate.is24.restapi.xml.common.AirConditioningType;
import org.openestate.is24.restapi.xml.common.ApartmentType;
import org.openestate.is24.restapi.xml.common.BalconyAvailableType;
import org.openestate.is24.restapi.xml.common.BuildingEnergyRatingType;
import org.openestate.is24.restapi.xml.common.BuildingType;
import org.openestate.is24.restapi.xml.common.CareLevelExpose;
import org.openestate.is24.restapi.xml.common.CareType;
import org.openestate.is24.restapi.xml.common.CommercializationType;
import org.openestate.is24.restapi.xml.common.CompulsoryAuctionType;
import org.openestate.is24.restapi.xml.common.ConstructionPhaseType;
import org.openestate.is24.restapi.xml.common.CountryCode;
import org.openestate.is24.restapi.xml.common.Currency;
import org.openestate.is24.restapi.xml.common.EnergyCertificateCreationDate;
import org.openestate.is24.restapi.xml.common.EnergyEfficiencyClass;
import org.openestate.is24.restapi.xml.common.EnergySourceEnev2014;
import org.openestate.is24.restapi.xml.common.EnergySourcesEnev2014;
import org.openestate.is24.restapi.xml.common.FacilityType;
import org.openestate.is24.restapi.xml.common.FlatMateGenderType;
import org.openestate.is24.restapi.xml.common.FlooringType;
import org.openestate.is24.restapi.xml.common.GarageType;
import org.openestate.is24.restapi.xml.common.GastronomyType;
import org.openestate.is24.restapi.xml.common.HeatingTypeEnev2014;
import org.openestate.is24.restapi.xml.common.HouseTypeBuildingType;
import org.openestate.is24.restapi.xml.common.HouseTypeConstructionMethodType;
import org.openestate.is24.restapi.xml.common.HouseTypeEnergyStandardType;
import org.openestate.is24.restapi.xml.common.HouseTypeStageOfCompletionType;
import org.openestate.is24.restapi.xml.common.IndustryType;
import org.openestate.is24.restapi.xml.common.InteriorQuality;
import org.openestate.is24.restapi.xml.common.InternetConnectionType;
import org.openestate.is24.restapi.xml.common.InvestmentType;
import org.openestate.is24.restapi.xml.common.ItInfrastructureType;
import org.openestate.is24.restapi.xml.common.LocationClassificationType;
import org.openestate.is24.restapi.xml.common.MarketingType;
import org.openestate.is24.restapi.xml.common.OfficeRentDuration;
import org.openestate.is24.restapi.xml.common.OfficeType;
import org.openestate.is24.restapi.xml.common.ParkingSituationType;
import org.openestate.is24.restapi.xml.common.ParkingSpaceType;
import org.openestate.is24.restapi.xml.common.PetsAllowedType;
import org.openestate.is24.restapi.xml.common.Price;
import org.openestate.is24.restapi.xml.common.PriceIntervalType;
import org.openestate.is24.restapi.xml.common.RealEstateCondition;
import org.openestate.is24.restapi.xml.common.RealEstateState;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.common.RoomType;
import org.openestate.is24.restapi.xml.common.SalutationType;
import org.openestate.is24.restapi.xml.common.ShortTermAccommodationType;
import org.openestate.is24.restapi.xml.common.SiteConstructibleType;
import org.openestate.is24.restapi.xml.common.SiteDevelopmentType;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseForTradeType;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseForTradeTypes;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseType;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseTypes;
import org.openestate.is24.restapi.xml.common.SmokingAllowedType;
import org.openestate.is24.restapi.xml.common.SpecialPurposeType;
import org.openestate.is24.restapi.xml.common.StoreType;
import org.openestate.is24.restapi.xml.common.SupplyType;
import org.openestate.is24.restapi.xml.common.TelephoneConnectionType;
import org.openestate.is24.restapi.xml.common.TvConnectionType;
import org.openestate.is24.restapi.xml.common.UtilizationTradeSite;
import org.openestate.is24.restapi.xml.common.Wgs84Address;
import org.openestate.is24.restapi.xml.common.YesNoNotApplicableType;
import org.openestate.is24.restapi.xml.common.YesNotApplicableType;
import org.openestate.is24.restapi.xml.realestates.ApartmentBuy;
import org.openestate.is24.restapi.xml.realestates.ApartmentRent;
import org.openestate.is24.restapi.xml.realestates.AssistedLiving;
import org.openestate.is24.restapi.xml.realestates.CompulsoryAuction;
import org.openestate.is24.restapi.xml.realestates.FlatShareRoom;
import org.openestate.is24.restapi.xml.realestates.GarageBuy;
import org.openestate.is24.restapi.xml.realestates.GarageRent;
import org.openestate.is24.restapi.xml.realestates.Gastronomy;
import org.openestate.is24.restapi.xml.realestates.HouseBuy;
import org.openestate.is24.restapi.xml.realestates.HouseRent;
import org.openestate.is24.restapi.xml.realestates.HouseType;
import org.openestate.is24.restapi.xml.realestates.Industry;
import org.openestate.is24.restapi.xml.realestates.Investment;
import org.openestate.is24.restapi.xml.realestates.LivingBuySite;
import org.openestate.is24.restapi.xml.realestates.LivingRentSite;
import org.openestate.is24.restapi.xml.realestates.ObjectFactory;
import org.openestate.is24.restapi.xml.realestates.Office;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.openestate.is24.restapi.xml.realestates.SeniorCare;
import org.openestate.is24.restapi.xml.realestates.ShortTermAccommodation;
import org.openestate.is24.restapi.xml.realestates.SpecialPurpose;
import org.openestate.is24.restapi.xml.realestates.Store;
import org.openestate.is24.restapi.xml.realestates.TradeSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomRealEstateFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomRealEstateFactory.class);
    private static final LoremIpsum LOREM = LoremIpsum.getInstance();
    private final org.openestate.is24.restapi.xml.common.ObjectFactory commonFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
    private final ObjectFactory realEstatesFactory = new ObjectFactory();

    public Address createRandomAddress() {
        Address address = this.commonFactory.createAddress();
        this.initAddress(address);
        return address;
    }

    public EnergySourcesEnev2014 createRandomEnergySourcesEnev2014() {
        EnergySourcesEnev2014 energySourcesEnev2014 = this.commonFactory.createEnergySourcesEnev2014();
        ArrayList<EnergySourceEnev2014> arrayList = new ArrayList<EnergySourceEnev2014>();
        arrayList.addAll(Arrays.asList(EnergySourceEnev2014.values()));
        int n = RandomRealEstateFactory.getRandomInt(arrayList.size()) + 1;
        int n2 = 0;
        while (n2 < n && !arrayList.isEmpty()) {
            int n3 = RandomRealEstateFactory.getRandomInt(arrayList.size());
            EnergySourceEnev2014 energySourceEnev2014 = (EnergySourceEnev2014)((Object)arrayList.remove(n3));
            if (!EnergySourceEnev2014.NO_INFORMATION.equals((Object)energySourceEnev2014)) {
                energySourcesEnev2014.getEnergySourceEnev2014().add(energySourceEnev2014);
                ++n2;
            }
            arrayList.trimToSize();
        }
        return energySourcesEnev2014;
    }

    public RealtorContactDetails createRandomContact() {
        RealtorContactDetails realtorContactDetails = this.commonFactory.createRealtorContactDetails();
        realtorContactDetails.setAdditionName(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)30));
        realtorContactDetails.setAddress(this.createRandomAddress());
        realtorContactDetails.setBusinessCardContact(false);
        realtorContactDetails.setCellPhoneNumber("+49 160 123456");
        realtorContactDetails.setCellPhoneNumberAreaCode("0160");
        realtorContactDetails.setCellPhoneNumberCountryCode("+49");
        realtorContactDetails.setCellPhoneNumberSubscriber("123456");
        realtorContactDetails.setCompany(StringUtils.abbreviate((String)LOREM.getWords(1, 15), (int)100));
        realtorContactDetails.setCountryCode(RandomRealEstateFactory.getRandomCountryCode());
        realtorContactDetails.setDefaultContact(false);
        realtorContactDetails.setEmail("test@test.org");
        realtorContactDetails.setFaxNumber("+49 30 123457");
        realtorContactDetails.setFaxNumberAreaCode("030");
        realtorContactDetails.setFaxNumberCountryCode("+49");
        realtorContactDetails.setFaxNumberSubscriber("123457");
        realtorContactDetails.setFirstname(LOREM.getFirstName());
        realtorContactDetails.setLastname(LOREM.getLastName());
        realtorContactDetails.setLocalPartnerContact(false);
        realtorContactDetails.setOfficeHours(StringUtils.abbreviate((String)LOREM.getWords(1, 50), (int)1000));
        realtorContactDetails.setPhoneNumber("+49 30 123456");
        realtorContactDetails.setPhoneNumberAreaCode("030");
        realtorContactDetails.setPhoneNumberCountryCode("+49");
        realtorContactDetails.setPhoneNumberSubscriber("123456");
        realtorContactDetails.setPosition(StringUtils.abbreviate((String)LOREM.getWords(1, 15), (int)100));
        realtorContactDetails.setSalutation(RandomRealEstateFactory.getRandomSalutationType());
        realtorContactDetails.setShowOnProfilePage(false);
        realtorContactDetails.setTitle(StringUtils.abbreviate((String)LOREM.getWords(1, 3), (int)15));
        try {
            realtorContactDetails.setHomepageUrl(new URL("http://test.org"));
            realtorContactDetails.setPortraitUrl(new URL("http://test.org/portrait.jpg"));
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Can't write URL!");
            LOGGER.warn("> " + malformedURLException.getLocalizedMessage(), (Throwable)malformedURLException);
        }
        return realtorContactDetails;
    }

    public RealEstate createRandomObject() {
        return this.createRandomObject(null);
    }

    public RealEstate createRandomObject(Type type) {
        if (type == null) {
            type = RandomRealEstateFactory.getRandomObjectType();
        }
        RealEstate realEstate = type.create();
        this.init(realEstate);
        return realEstate;
    }

    public Wgs84Address createRandomObjectAddress() {
        Wgs84Address wgs84Address = this.commonFactory.createWgs84Address();
        this.initAddress(wgs84Address);
        return wgs84Address;
    }

    public SiteRecommendedUseForTradeTypes createRandomSiteRecommendedUseForTradeTypes() {
        SiteRecommendedUseForTradeTypes siteRecommendedUseForTradeTypes = this.commonFactory.createSiteRecommendedUseForTradeTypes();
        ArrayList<SiteRecommendedUseForTradeType> arrayList = new ArrayList<SiteRecommendedUseForTradeType>();
        arrayList.addAll(Arrays.asList(SiteRecommendedUseForTradeType.values()));
        int n = RandomRealEstateFactory.getRandomInt(arrayList.size()) + 1;
        int n2 = 0;
        while (n2 < n && !arrayList.isEmpty()) {
            int n3 = RandomRealEstateFactory.getRandomInt(arrayList.size());
            SiteRecommendedUseForTradeType siteRecommendedUseForTradeType = (SiteRecommendedUseForTradeType)((Object)arrayList.remove(n3));
            if (!SiteRecommendedUseForTradeType.NO_INFORMATION.equals((Object)siteRecommendedUseForTradeType)) {
                siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(siteRecommendedUseForTradeType);
                ++n2;
            }
            arrayList.trimToSize();
        }
        return siteRecommendedUseForTradeTypes;
    }

    public SiteRecommendedUseTypes createRandomSiteRecommendedUseTypes() {
        SiteRecommendedUseTypes siteRecommendedUseTypes = this.commonFactory.createSiteRecommendedUseTypes();
        ArrayList<SiteRecommendedUseType> arrayList = new ArrayList<SiteRecommendedUseType>();
        arrayList.addAll(Arrays.asList(SiteRecommendedUseType.values()));
        int n = RandomRealEstateFactory.getRandomInt(arrayList.size()) + 1;
        int n2 = 0;
        while (n2 < n && !arrayList.isEmpty()) {
            int n3 = RandomRealEstateFactory.getRandomInt(arrayList.size());
            SiteRecommendedUseType siteRecommendedUseType = (SiteRecommendedUseType)((Object)arrayList.remove(n3));
            if (!SiteRecommendedUseType.NO_INFORMATION.equals((Object)siteRecommendedUseType)) {
                siteRecommendedUseTypes.getSiteRecommendedUseType().add(siteRecommendedUseType);
                ++n2;
            }
            arrayList.trimToSize();
        }
        return siteRecommendedUseTypes;
    }

    public Price getDefaultPrice() {
        Price price = this.commonFactory.createPrice();
        price.setCurrency(Currency.EUR);
        return price;
    }

    public static AirConditioningType getRandomAirConditioningType() {
        return (AirConditioningType)((Object)RandomRealEstateFactory.getRandomValue((Object[])AirConditioningType.values()));
    }

    public static ApartmentType getRandomApartmentType() {
        return (ApartmentType)((Object)RandomRealEstateFactory.getRandomValue((Object[])ApartmentType.values()));
    }

    public static BalconyAvailableType getRandomBalconyAvailableType() {
        return (BalconyAvailableType)((Object)RandomRealEstateFactory.getRandomValue((Object[])BalconyAvailableType.values()));
    }

    public static boolean getRandomBoolean() {
        return RandomUtils.nextInt((int)0, (int)2) == 1;
    }

    public static BuildingType getRandomBuildingType() {
        return (BuildingType)((Object)RandomRealEstateFactory.getRandomValue((Object[])BuildingType.values()));
    }

    public static Calendar getRandomCalendar() {
        return RandomRealEstateFactory.getRandomCalendar(1990, 2015);
    }

    public static Calendar getRandomCalendar(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, RandomRealEstateFactory.getRandomInt(n, n2));
        calendar.set(6, RandomRealEstateFactory.getRandomInt(1, 365));
        calendar.set(11, RandomRealEstateFactory.getRandomInt(24));
        calendar.set(12, RandomRealEstateFactory.getRandomInt(60));
        calendar.set(13, RandomRealEstateFactory.getRandomInt(60));
        calendar.set(14, RandomRealEstateFactory.getRandomInt(1000));
        return calendar;
    }

    public static CareLevelExpose getRandomCareLevel() {
        return (CareLevelExpose)((Object)RandomRealEstateFactory.getRandomValue((Object[])CareLevelExpose.values()));
    }

    public static CompulsoryAuctionType getRandomCompulsoryAuctionType() {
        return (CompulsoryAuctionType)((Object)RandomRealEstateFactory.getRandomValue((Object[])CompulsoryAuctionType.values()));
    }

    public static ConstructionPhaseType getRandomConstructionPhaseType() {
        return (ConstructionPhaseType)((Object)RandomRealEstateFactory.getRandomValue((Object[])ConstructionPhaseType.values()));
    }

    public static CountryCode getRandomCountryCode() {
        return (CountryCode)((Object)RandomRealEstateFactory.getRandomValue((Object[])CountryCode.values()));
    }

    public static Date getRandomDate() {
        return RandomRealEstateFactory.getRandomCalendar().getTime();
    }

    public static Date getRandomDate(int n, int n2) {
        return RandomRealEstateFactory.getRandomCalendar(n, n2).getTime();
    }

    public static BigDecimal getRandomDecimal(long l) {
        return RandomRealEstateFactory.getRandomDecimal(BigDecimal.ZERO, BigDecimal.valueOf(l));
    }

    public static BigDecimal getRandomDecimal(BigDecimal bigDecimal) {
        return RandomRealEstateFactory.getRandomDecimal(BigDecimal.ZERO, bigDecimal);
    }

    public static BigDecimal getRandomDecimal(long l, long l2) {
        return RandomRealEstateFactory.getRandomDecimal(BigDecimal.valueOf(l), BigDecimal.valueOf(l2));
    }

    public static BigDecimal getRandomDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal.compareTo(bigDecimal2) == 1) {
            throw new IllegalArgumentException("Minimum value is bigger than maximum value!");
        }
        if (bigDecimal.compareTo(bigDecimal2) == 0) {
            return bigDecimal;
        }
        return BigDecimal.valueOf(RandomUtils.nextDouble((double)bigDecimal.doubleValue(), (double)bigDecimal2.doubleValue()));
    }

    public static EnergyEfficiencyClass getRandomEnergyEfficiencyClass() {
        return (EnergyEfficiencyClass)((Object)RandomRealEstateFactory.getRandomValue((Object[])EnergyEfficiencyClass.values()));
    }

    public static FacilityType getRandomFacilityType() {
        return (FacilityType)((Object)RandomRealEstateFactory.getRandomValue((Object[])FacilityType.values()));
    }

    public static FlatMateGenderType getRandomFlatMateGenderType() {
        return (FlatMateGenderType)((Object)RandomRealEstateFactory.getRandomValue((Object[])FlatMateGenderType.values()));
    }

    public static FlooringType getRandomFlooringType() {
        return (FlooringType)((Object)RandomRealEstateFactory.getRandomValue((Object[])FlooringType.values()));
    }

    public static GarageType getRandomGarageType() {
        return (GarageType)((Object)RandomRealEstateFactory.getRandomValue((Object[])GarageType.values()));
    }

    public static GastronomyType getRandomGastronomyType() {
        return (GastronomyType)((Object)RandomRealEstateFactory.getRandomValue((Object[])GastronomyType.values()));
    }

    public static HeatingTypeEnev2014 getRandomHeatingTypeEnev2014() {
        return (HeatingTypeEnev2014)((Object)RandomRealEstateFactory.getRandomValue((Object[])HeatingTypeEnev2014.values()));
    }

    public static HouseTypeBuildingType getRandomHouseTypeBuildingType() {
        return (HouseTypeBuildingType)((Object)RandomRealEstateFactory.getRandomValue((Object[])HouseTypeBuildingType.values()));
    }

    public static HouseTypeConstructionMethodType getRandomHouseTypeConstructionMethodType() {
        return (HouseTypeConstructionMethodType)((Object)RandomRealEstateFactory.getRandomValue((Object[])HouseTypeConstructionMethodType.values()));
    }

    public static HouseTypeEnergyStandardType getRandomHouseTypeEnergyStandardType() {
        return (HouseTypeEnergyStandardType)((Object)RandomRealEstateFactory.getRandomValue((Object[])HouseTypeEnergyStandardType.values()));
    }

    public static HouseTypeStageOfCompletionType getRandomHouseTypeStageOfCompletionType() {
        return (HouseTypeStageOfCompletionType)((Object)RandomRealEstateFactory.getRandomValue((Object[])HouseTypeStageOfCompletionType.values()));
    }

    public static IndustryType getRandomIndustryType() {
        return (IndustryType)((Object)RandomRealEstateFactory.getRandomValue((Object[])IndustryType.values()));
    }

    public static int getRandomInt(int n) {
        return RandomRealEstateFactory.getRandomInt(0, n);
    }

    public static int getRandomInt(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("Minimum value is bigger than maximum value!");
        }
        if (n == n2) {
            return n;
        }
        return RandomUtils.nextInt((int)n, (int)n2);
    }

    public static long getRandomLong(long l) {
        return RandomRealEstateFactory.getRandomLong(0L, l);
    }

    public static long getRandomLong(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("Minimum value is bigger than maximum value!");
        }
        if (l == l2) {
            return l;
        }
        return RandomUtils.nextLong((long)l, (long)l2);
    }

    public static InteriorQuality getRandomInteriorQuality() {
        return (InteriorQuality)((Object)RandomRealEstateFactory.getRandomValue((Object[])InteriorQuality.values()));
    }

    public static InternetConnectionType getRandomInternetConnectionType() {
        return (InternetConnectionType)((Object)RandomRealEstateFactory.getRandomValue((Object[])InternetConnectionType.values()));
    }

    public static InvestmentType getRandomInvestmentType() {
        return (InvestmentType)((Object)RandomRealEstateFactory.getRandomValue((Object[])InvestmentType.values()));
    }

    public static ItInfrastructureType getRandomItInfrastructureType() {
        return (ItInfrastructureType)((Object)RandomRealEstateFactory.getRandomValue((Object[])ItInfrastructureType.values()));
    }

    public static LocationClassificationType getRandomLocationClassificationType() {
        return (LocationClassificationType)((Object)RandomRealEstateFactory.getRandomValue((Object[])LocationClassificationType.values()));
    }

    public static Type getRandomObjectType() {
        return (Type)((Object)RandomRealEstateFactory.getRandomValue((Object[])Type.values()));
    }

    public static OfficeType getRandomOfficeType() {
        return (OfficeType)((Object)RandomRealEstateFactory.getRandomValue((Object[])OfficeType.values()));
    }

    public static ParkingSituationType getRandomParkingSituationType() {
        return (ParkingSituationType)((Object)RandomRealEstateFactory.getRandomValue((Object[])ParkingSituationType.values()));
    }

    public static ParkingSpaceType getRandomParkingSpaceType() {
        return (ParkingSpaceType)((Object)RandomRealEstateFactory.getRandomValue((Object[])ParkingSpaceType.values()));
    }

    public static PetsAllowedType getRandomPetsAllowedType() {
        return (PetsAllowedType)((Object)RandomRealEstateFactory.getRandomValue((Object[])PetsAllowedType.values()));
    }

    public static RealEstateCondition getRandomRealEstateCondition() {
        return (RealEstateCondition)((Object)RandomRealEstateFactory.getRandomValue((Object[])RealEstateCondition.values()));
    }

    public static SalutationType getRandomSalutationType() {
        return (SalutationType)((Object)RandomRealEstateFactory.getRandomValue((Object[])SalutationType.values()));
    }

    public static RoomType getRandomRoomType() {
        return (RoomType)((Object)RandomRealEstateFactory.getRandomValue((Object[])RoomType.values()));
    }

    public static ShortTermAccommodationType getRandomShortTermAccommodationType() {
        return (ShortTermAccommodationType)((Object)RandomRealEstateFactory.getRandomValue((Object[])ShortTermAccommodationType.values()));
    }

    public static SiteConstructibleType getRandomSiteConstructibleType() {
        return (SiteConstructibleType)((Object)RandomRealEstateFactory.getRandomValue((Object[])SiteConstructibleType.values()));
    }

    public static SiteDevelopmentType getRandomSiteDevelopmentType() {
        return (SiteDevelopmentType)((Object)RandomRealEstateFactory.getRandomValue((Object[])SiteDevelopmentType.values()));
    }

    public static SmokingAllowedType getRandomSmokingAllowedType() {
        return (SmokingAllowedType)((Object)RandomRealEstateFactory.getRandomValue((Object[])SmokingAllowedType.values()));
    }

    public static SpecialPurposeType getRandomSpecialPurposeType() {
        return (SpecialPurposeType)((Object)RandomRealEstateFactory.getRandomValue((Object[])SpecialPurposeType.values()));
    }

    public static StoreType getRandomStoreType() {
        return (StoreType)((Object)RandomRealEstateFactory.getRandomValue((Object[])StoreType.values()));
    }

    public static SupplyType getRandomSupplyType() {
        return (SupplyType)((Object)RandomRealEstateFactory.getRandomValue((Object[])SupplyType.values()));
    }

    public static TelephoneConnectionType getRandomTelephoneConnectionType() {
        return (TelephoneConnectionType)((Object)RandomRealEstateFactory.getRandomValue((Object[])TelephoneConnectionType.values()));
    }

    public static TvConnectionType getRandomTvConnectionType() {
        return (TvConnectionType)((Object)RandomRealEstateFactory.getRandomValue((Object[])TvConnectionType.values()));
    }

    public static UtilizationTradeSite getRandomUtilizationTradeSite() {
        return (UtilizationTradeSite)((Object)RandomRealEstateFactory.getRandomValue((Object[])UtilizationTradeSite.values()));
    }

    public static YesNoNotApplicableType getRandomYesNo() {
        return RandomRealEstateFactory.getRandomBoolean() ? YesNoNotApplicableType.YES : YesNoNotApplicableType.NO;
    }

    public static YesNoNotApplicableType getRandomYesNoNotApplicableType() {
        return (YesNoNotApplicableType)((Object)RandomRealEstateFactory.getRandomValue((Object[])YesNoNotApplicableType.values()));
    }

    public static YesNotApplicableType getRandomYesNotApplicableType() {
        return (YesNotApplicableType)((Object)RandomRealEstateFactory.getRandomValue((Object[])YesNotApplicableType.values()));
    }

    public static Object getRandomValue(Object[] objectArray) {
        return !ArrayUtils.isEmpty((Object[])objectArray) ? objectArray[RandomUtils.nextInt((int)0, (int)objectArray.length)] : null;
    }

    public void init(RealEstate realEstate) {
        realEstate.setAddress(this.createRandomObjectAddress());
        realEstate.setDescriptionNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)2000));
        realEstate.setExternalId(String.valueOf(RandomRealEstateFactory.getRandomInt(1000)));
        realEstate.setFurnishingNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)2000));
        realEstate.setGroupNumber(RandomRealEstateFactory.getRandomInt(100));
        realEstate.setLastModificationDate(Calendar.getInstance());
        realEstate.setLocationNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)2000));
        realEstate.setOtherNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)2000));
        realEstate.setRealEstateState(RealEstateState.ACTIVE);
        realEstate.setShowAddress(RandomRealEstateFactory.getRandomBoolean());
        realEstate.setTitle(StringUtils.abbreviate((String)LOREM.getTitle(3, 15), (int)100));
        realEstate.setContact(this.realEstatesFactory.createRealEstateContact());
        realEstate.getContact().setExternalId(String.valueOf(RandomRealEstateFactory.getRandomInt(1000)));
        if (realEstate instanceof ApartmentBuy) {
            this.initRealEstate((ApartmentBuy)realEstate);
        } else if (realEstate instanceof ApartmentRent) {
            this.initRealEstate((ApartmentRent)realEstate);
        } else if (realEstate instanceof AssistedLiving) {
            this.initRealEstate((AssistedLiving)realEstate);
        } else if (realEstate instanceof CompulsoryAuction) {
            this.initRealEstate((CompulsoryAuction)realEstate);
        } else if (realEstate instanceof FlatShareRoom) {
            this.initRealEstate((FlatShareRoom)realEstate);
        } else if (realEstate instanceof GarageBuy) {
            this.initRealEstate((GarageBuy)realEstate);
        } else if (realEstate instanceof GarageRent) {
            this.initRealEstate((GarageRent)realEstate);
        } else if (realEstate instanceof Gastronomy) {
            this.initRealEstate((Gastronomy)realEstate);
        } else if (realEstate instanceof HouseBuy) {
            this.initRealEstate((HouseBuy)realEstate);
        } else if (realEstate instanceof HouseRent) {
            this.initRealEstate((HouseRent)realEstate);
        } else if (realEstate instanceof HouseType) {
            this.initRealEstate((HouseType)realEstate);
        } else if (realEstate instanceof Industry) {
            this.initRealEstate((Industry)realEstate);
        } else if (realEstate instanceof Investment) {
            this.initRealEstate((Investment)realEstate);
        } else if (realEstate instanceof LivingBuySite) {
            this.initRealEstate((LivingBuySite)realEstate);
        } else if (realEstate instanceof LivingRentSite) {
            this.initRealEstate((LivingRentSite)realEstate);
        } else if (realEstate instanceof Office) {
            this.initRealEstate((Office)realEstate);
        } else if (realEstate instanceof SeniorCare) {
            this.initRealEstate((SeniorCare)realEstate);
        } else if (realEstate instanceof ShortTermAccommodation) {
            this.initRealEstate((ShortTermAccommodation)realEstate);
        } else if (realEstate instanceof SpecialPurpose) {
            this.initRealEstate((SpecialPurpose)realEstate);
        } else if (realEstate instanceof Store) {
            this.initRealEstate((Store)realEstate);
        } else if (realEstate instanceof TradeSite) {
            this.initRealEstate((TradeSite)realEstate);
        }
    }

    protected void initAddress(Address address) {
        address.setCity("Berlin");
        address.setHouseNumber(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 1000)));
        address.setPostcode("13125");
        address.setStreet("Beispielstra\u00dfe");
    }

    protected void initAddress(Wgs84Address wgs84Address) {
        this.initAddress((Address)wgs84Address);
        wgs84Address.setPreciseHouseNumber(RandomRealEstateFactory.getRandomBoolean());
        wgs84Address.setQuarter(LOREM.getWords(1, 3));
        wgs84Address.setDescription(this.commonFactory.createWgs84AddressDescription());
        wgs84Address.getDescription().setText(StringUtils.abbreviate((String)LOREM.getWords(1, 15), (int)1000));
    }

    protected void initRealEstate(ApartmentBuy apartmentBuy) {
        apartmentBuy.setApartmentType(RandomRealEstateFactory.getRandomApartmentType());
        apartmentBuy.setBalcony(RandomRealEstateFactory.getRandomBoolean());
        apartmentBuy.setBuiltInKitchen(RandomRealEstateFactory.getRandomBoolean());
        apartmentBuy.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentBuy.setCertificateOfEligibilityNeeded(RandomRealEstateFactory.getRandomBoolean());
        apartmentBuy.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        apartmentBuy.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        apartmentBuy.setFloor(RandomRealEstateFactory.getRandomInt(5));
        apartmentBuy.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        apartmentBuy.setGarden(RandomRealEstateFactory.getRandomBoolean());
        apartmentBuy.setGuestToilet(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentBuy.setHandicappedAccessible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentBuy.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        apartmentBuy.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        apartmentBuy.setLastRefurbishment(RandomRealEstateFactory.getRandomInt(1990, 2014));
        apartmentBuy.setLift(RandomRealEstateFactory.getRandomBoolean());
        apartmentBuy.setListed(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentBuy.setLivingSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        apartmentBuy.setNumberOfBathRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentBuy.setNumberOfBedRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentBuy.setNumberOfFloors(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentBuy.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentBuy.setNumberOfRooms(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        apartmentBuy.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        apartmentBuy.setParkingSpaceType(RandomRealEstateFactory.getRandomParkingSpaceType());
        apartmentBuy.setRentalIncome(RandomRealEstateFactory.getRandomDecimal(9999L, 9999999L));
        apartmentBuy.setRented(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentBuy.setServiceCharge(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        apartmentBuy.setSummerResidencePractical(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentBuy.setUsableFloorSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            apartmentBuy.setConstructionYear(null);
            apartmentBuy.setConstructionYearUnknown(true);
        } else {
            apartmentBuy.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1960));
        }
        apartmentBuy.setCourtage(this.commonFactory.createCourtageInfo());
        apartmentBuy.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        apartmentBuy.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        apartmentBuy.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        apartmentBuy.setEnergyPerformanceCertificate(true);
        apartmentBuy.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            apartmentBuy.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                apartmentBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                apartmentBuy.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
                apartmentBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                apartmentBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                apartmentBuy.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                apartmentBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            apartmentBuy.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                apartmentBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                apartmentBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                apartmentBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                apartmentBuy.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                apartmentBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        apartmentBuy.setPrice(this.getDefaultPrice());
        apartmentBuy.getPrice().setMarketingType(MarketingType.PURCHASE);
        apartmentBuy.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        apartmentBuy.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(10000L, 9999999L));
    }

    protected void initRealEstate(ApartmentRent apartmentRent) {
        apartmentRent.setApartmentType(RandomRealEstateFactory.getRandomApartmentType());
        apartmentRent.setBalcony(RandomRealEstateFactory.getRandomBoolean());
        apartmentRent.setBaseRent(RandomRealEstateFactory.getRandomDecimal(200L, 2500L));
        apartmentRent.setBuiltInKitchen(RandomRealEstateFactory.getRandomBoolean());
        apartmentRent.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentRent.setCertificateOfEligibilityNeeded(RandomRealEstateFactory.getRandomBoolean());
        apartmentRent.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        apartmentRent.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        apartmentRent.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        apartmentRent.setFloor(RandomRealEstateFactory.getRandomInt(5));
        apartmentRent.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        apartmentRent.setGarden(RandomRealEstateFactory.getRandomBoolean());
        apartmentRent.setGuestToilet(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentRent.setHandicappedAccessible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        apartmentRent.setHeatingCosts(RandomRealEstateFactory.getRandomDecimal(100L, 500L));
        apartmentRent.setHeatingCostsInServiceCharge(RandomRealEstateFactory.getRandomYesNo());
        apartmentRent.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        apartmentRent.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        apartmentRent.setLastRefurbishment(RandomRealEstateFactory.getRandomInt(1990, 2014));
        apartmentRent.setLift(RandomRealEstateFactory.getRandomBoolean());
        apartmentRent.setLivingSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        apartmentRent.setNumberOfBathRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentRent.setNumberOfBedRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentRent.setNumberOfFloors(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentRent.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomInt(1, 10));
        apartmentRent.setNumberOfRooms(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        apartmentRent.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        apartmentRent.setParkingSpaceType(RandomRealEstateFactory.getRandomParkingSpaceType());
        apartmentRent.setPetsAllowed(RandomRealEstateFactory.getRandomPetsAllowedType());
        apartmentRent.setServiceCharge(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        apartmentRent.setTotalRent(RandomRealEstateFactory.getRandomDecimal(500L, 3000L));
        apartmentRent.setUsableFloorSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        apartmentRent.setUseAsFlatshareRoom(RandomRealEstateFactory.getRandomYesNotApplicableType());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            apartmentRent.setConstructionYear(null);
            apartmentRent.setConstructionYearUnknown(true);
        } else {
            apartmentRent.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1980));
        }
        apartmentRent.setCourtage(this.commonFactory.createCourtageInfo());
        apartmentRent.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        apartmentRent.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        apartmentRent.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        apartmentRent.setEnergyPerformanceCertificate(true);
        apartmentRent.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            apartmentRent.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                apartmentRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                apartmentRent.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
                apartmentRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                apartmentRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                apartmentRent.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                apartmentRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            apartmentRent.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                apartmentRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                apartmentRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                apartmentRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                apartmentRent.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                apartmentRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        apartmentRent.setPrice(this.getDefaultPrice());
        apartmentRent.getPrice().setMarketingType(MarketingType.RENT);
        apartmentRent.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
        apartmentRent.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(200L, 9999L));
    }

    protected void initRealEstate(AssistedLiving assistedLiving) {
        assistedLiving.setAmbulantNursingServiceAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setBalconyAvailable(RandomRealEstateFactory.getRandomBalconyAvailableType());
        assistedLiving.setBarrierFree(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setBranchEntry(RandomRealEstateFactory.getRandomBoolean());
        assistedLiving.setCleaningServiceAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setCommonRoomsAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setCookingFacilitiesAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setCounselingAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setCulturalProgramAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setEmergencyCallInRoomAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        assistedLiving.setFacilityType(RandomRealEstateFactory.getRandomFacilityType());
        assistedLiving.setFitnessAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setGardenAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setGuestApartmentsAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setHandicappedAccessible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        assistedLiving.setHomeHelpAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setLeisureActivitiesAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setLivingSpaceFrom(RandomRealEstateFactory.getRandomDecimal(20L, 50L));
        assistedLiving.setLivingSpaceTo(RandomRealEstateFactory.getRandomDecimal(50L, 150L));
        assistedLiving.setLoansAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setMedicalAssistanceAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setNumberOfLookedAfterApartments(RandomRealEstateFactory.getRandomLong(1L, 10L));
        assistedLiving.setNumberOfNursingPlaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        assistedLiving.setNumberOfRoomsFrom(RandomRealEstateFactory.getRandomDecimal(1L, 2L));
        assistedLiving.setNumberOfRoomsTo(RandomRealEstateFactory.getRandomDecimal(3L, 5L));
        assistedLiving.setOwnFurniturePossible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setParkingAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setPetsAllowed(RandomRealEstateFactory.getRandomPetsAllowedType());
        assistedLiving.setPoolAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setPublicTransportationAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setReceptionManned(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setReligiousOfferingsAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setRestaurantAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setSecurity24Hours(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setShoppingFacilitiesAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        assistedLiving.setShortDescription(StringUtils.abbreviate((String)LOREM.getWords(3, 15), (int)200));
        assistedLiving.setTrialLivingPossible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            assistedLiving.setConstructionYear(null);
            assistedLiving.setConstructionYearUnknown(true);
        } else {
            assistedLiving.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        }
        assistedLiving.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            assistedLiving.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                assistedLiving.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                assistedLiving.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
                assistedLiving.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                assistedLiving.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                assistedLiving.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                assistedLiving.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            assistedLiving.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                assistedLiving.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                assistedLiving.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                assistedLiving.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                assistedLiving.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                assistedLiving.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        if (RandomRealEstateFactory.getRandomBoolean()) {
            assistedLiving.setMarketingType(MarketingType.RENT);
            assistedLiving.setMinBaseRent(this.getDefaultPrice());
            assistedLiving.getMinBaseRent().setMarketingType(MarketingType.RENT);
            assistedLiving.getMinBaseRent().setPriceIntervalType(PriceIntervalType.MONTH);
            assistedLiving.getMinBaseRent().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
        } else {
            assistedLiving.setMarketingType(MarketingType.PURCHASE);
            assistedLiving.setMinPurchasePrice(this.getDefaultPrice());
            assistedLiving.getMinPurchasePrice().setMarketingType(MarketingType.PURCHASE);
            assistedLiving.getMinPurchasePrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            assistedLiving.getMinPurchasePrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
        }
    }

    protected void initRealEstate(CompulsoryAuction compulsoryAuction) {
        compulsoryAuction.setArea(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        compulsoryAuction.setAuctionObjectType(RandomRealEstateFactory.getRandomCompulsoryAuctionType());
        compulsoryAuction.setCancellationDate(RandomRealEstateFactory.getRandomCalendar());
        compulsoryAuction.setDateOfAuction(RandomRealEstateFactory.getRandomCalendar());
        compulsoryAuction.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        compulsoryAuction.setFileReferenceAtCountyCourt(RandomStringUtils.randomAlphanumeric((int)8));
        compulsoryAuction.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        compulsoryAuction.setLastChangeDate(RandomRealEstateFactory.getRandomCalendar());
        compulsoryAuction.setNumberOfFolio(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 10)));
        compulsoryAuction.setOwner(LOREM.getName());
        compulsoryAuction.setRecordationDate(RandomRealEstateFactory.getRandomCalendar());
        compulsoryAuction.setRecurrenceAppointment(RandomRealEstateFactory.getRandomBoolean());
        compulsoryAuction.setSplittingAuction(RandomRealEstateFactory.getRandomBoolean());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            compulsoryAuction.setConstructionYear(null);
            compulsoryAuction.setConstructionYearUnknown(true);
        } else {
            compulsoryAuction.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1980));
        }
        compulsoryAuction.setCountyCourt(this.commonFactory.createCountyCourt());
        compulsoryAuction.getCountyCourt().setCourtNumber(RandomStringUtils.randomNumeric((int)5));
        compulsoryAuction.getCountyCourt().setName(LOREM.getWords(3));
        compulsoryAuction.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            compulsoryAuction.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                compulsoryAuction.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                compulsoryAuction.getEnergyCertificate().setElectricityConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                compulsoryAuction.getEnergyCertificate().setHeatingConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                compulsoryAuction.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
                compulsoryAuction.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
            } else {
                compulsoryAuction.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                compulsoryAuction.getEnergyCertificate().setEnergyConsumptionElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                compulsoryAuction.getEnergyCertificate().setEnergyConsumptionHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                compulsoryAuction.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                compulsoryAuction.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            compulsoryAuction.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                compulsoryAuction.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                compulsoryAuction.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                compulsoryAuction.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                compulsoryAuction.getEnergyCertificate().setThermalCharacteristicElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                compulsoryAuction.getEnergyCertificate().setThermalCharacteristicHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                compulsoryAuction.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                compulsoryAuction.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        compulsoryAuction.setLowestBid(this.getDefaultPrice());
        compulsoryAuction.getLowestBid().setMarketingType(MarketingType.PURCHASE);
        compulsoryAuction.getLowestBid().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        compulsoryAuction.getLowestBid().setValue(RandomRealEstateFactory.getRandomDecimal(10000L, 250000L));
        compulsoryAuction.setMarketValue(this.getDefaultPrice());
        compulsoryAuction.getMarketValue().setMarketingType(MarketingType.PURCHASE);
        compulsoryAuction.getMarketValue().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        compulsoryAuction.getMarketValue().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 500000L));
    }

    protected void initRealEstate(FlatShareRoom flatShareRoom) {
        flatShareRoom.setAgeOfFlatMatesFrom(RandomRealEstateFactory.getRandomLong(16L, 30L));
        flatShareRoom.setAgeOfFlatMatesTo(RandomRealEstateFactory.getRandomLong(30L, 50L));
        flatShareRoom.setAgeOfRequestedFrom(RandomRealEstateFactory.getRandomLong(16L, 30L));
        flatShareRoom.setAgeOfRequestedTo(RandomRealEstateFactory.getRandomLong(30L, 50L));
        flatShareRoom.setApartmentType(RandomRealEstateFactory.getRandomApartmentType());
        flatShareRoom.setBalcony(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setBarrierFree(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setBaseRent(RandomRealEstateFactory.getRandomDecimal(200L, 1000L));
        flatShareRoom.setBathHasShower(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setBathHasTub(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setBathHasWc(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        flatShareRoom.setDishwasher(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        flatShareRoom.setFlatShareSize(RandomRealEstateFactory.getRandomInt(2, 8));
        flatShareRoom.setFloor(RandomRealEstateFactory.getRandomInt(5));
        flatShareRoom.setFlooringType(RandomRealEstateFactory.getRandomFlooringType());
        flatShareRoom.setFreeFrom(RandomRealEstateFactory.getRandomCalendar());
        flatShareRoom.setFreeUntil(RandomRealEstateFactory.getRandomCalendar());
        flatShareRoom.setFurnishing(RandomRealEstateFactory.getRandomYesNoNotApplicableType());
        flatShareRoom.setGarden(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setGuestToilet(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setHeatingCosts(RandomRealEstateFactory.getRandomDecimal(100L, 500L));
        flatShareRoom.setHeatingCostsInServiceCharge(RandomRealEstateFactory.getRandomYesNo());
        flatShareRoom.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        flatShareRoom.setInternetConnection(RandomRealEstateFactory.getRandomInternetConnectionType());
        flatShareRoom.setLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setMinimumTermOfLease(RandomRealEstateFactory.getRandomLong(1L, 12L));
        flatShareRoom.setNumberOfBathRooms(RandomRealEstateFactory.getRandomLong(1L, 10L));
        flatShareRoom.setNumberOfFemaleFlatMates(RandomRealEstateFactory.getRandomLong(1L, 10L));
        flatShareRoom.setNumberOfFloors(RandomRealEstateFactory.getRandomLong(1L, 10L));
        flatShareRoom.setNumberOfMaleFlatMates(RandomRealEstateFactory.getRandomLong(1L, 10L));
        flatShareRoom.setNumberOfRequestedFlatMates(RandomRealEstateFactory.getRandomLong(1L, 10L));
        flatShareRoom.setNumberOfRooms(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        flatShareRoom.setOven(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setParkingSituation(RandomRealEstateFactory.getRandomParkingSituationType());
        flatShareRoom.setPetsAllowed(RandomRealEstateFactory.getRandomPetsAllowedType());
        flatShareRoom.setRefrigerator(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setRequestedGender(RandomRealEstateFactory.getRandomFlatMateGenderType());
        flatShareRoom.setRoomSize(RandomRealEstateFactory.getRandomDecimal(4L, 20L));
        flatShareRoom.setServiceCharge(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        flatShareRoom.setSmokingAllowed(RandomRealEstateFactory.getRandomSmokingAllowedType());
        flatShareRoom.setStove(RandomRealEstateFactory.getRandomYesNotApplicableType());
        flatShareRoom.setTelephoneConnection(RandomRealEstateFactory.getRandomTelephoneConnectionType());
        flatShareRoom.setTotalRent(RandomRealEstateFactory.getRandomDecimal(500L, 3000L));
        flatShareRoom.setTotalSpace(RandomRealEstateFactory.getRandomDecimal(40L, 250L));
        flatShareRoom.setTvConnection(RandomRealEstateFactory.getRandomTvConnectionType());
        flatShareRoom.setWashingMachine(RandomRealEstateFactory.getRandomYesNotApplicableType());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            flatShareRoom.setConstructionYear(null);
            flatShareRoom.setConstructionYearUnknown(true);
        } else {
            flatShareRoom.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1980));
        }
        flatShareRoom.setCourtage(this.commonFactory.createCourtageInfo());
        flatShareRoom.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        flatShareRoom.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        flatShareRoom.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        flatShareRoom.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            flatShareRoom.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                flatShareRoom.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                flatShareRoom.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
                flatShareRoom.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                flatShareRoom.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                flatShareRoom.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                flatShareRoom.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            flatShareRoom.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                flatShareRoom.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                flatShareRoom.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                flatShareRoom.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                flatShareRoom.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                flatShareRoom.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
    }

    protected void initRealEstate(GarageBuy garageBuy) {
        garageBuy.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        garageBuy.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1980));
        garageBuy.setGarageType(RandomRealEstateFactory.getRandomGarageType());
        garageBuy.setHeightGarage(RandomRealEstateFactory.getRandomDecimal(1L, 3L));
        garageBuy.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        garageBuy.setLengthGarage(RandomRealEstateFactory.getRandomDecimal(3L, 6L));
        garageBuy.setUsableFloorSpace(RandomRealEstateFactory.getRandomDecimal(5L, 50L));
        garageBuy.setWidthGarage(RandomRealEstateFactory.getRandomDecimal(3L, 6L));
        garageBuy.setCourtage(this.commonFactory.createCourtageInfo());
        garageBuy.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        garageBuy.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        garageBuy.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        garageBuy.setPrice(this.getDefaultPrice());
        garageBuy.getPrice().setMarketingType(MarketingType.PURCHASE);
        garageBuy.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        garageBuy.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(1000L, 9999L));
    }

    protected void initRealEstate(GarageRent garageRent) {
        garageRent.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        garageRent.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1980));
        garageRent.setFreeFrom(RandomRealEstateFactory.getRandomCalendar());
        garageRent.setFreeUntil(RandomRealEstateFactory.getRandomCalendar());
        garageRent.setGarageType(RandomRealEstateFactory.getRandomGarageType());
        garageRent.setHeightGarage(RandomRealEstateFactory.getRandomDecimal(1L, 3L));
        garageRent.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        garageRent.setLengthGarage(RandomRealEstateFactory.getRandomDecimal(3L, 6L));
        garageRent.setUsableFloorSpace(RandomRealEstateFactory.getRandomDecimal(5L, 50L));
        garageRent.setWidthGarage(RandomRealEstateFactory.getRandomDecimal(3L, 6L));
        garageRent.setCourtage(this.commonFactory.createCourtageInfo());
        garageRent.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        garageRent.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        garageRent.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        garageRent.setPrice(this.getDefaultPrice());
        garageRent.getPrice().setMarketingType(MarketingType.RENT);
        garageRent.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
        garageRent.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50L, 999L));
    }

    protected void initRealEstate(Gastronomy gastronomy) {
        gastronomy.setAdditionalArea(RandomRealEstateFactory.getRandomDecimal(10L, 500L));
        gastronomy.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        gastronomy.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        gastronomy.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        gastronomy.setDistanceToAirport(RandomRealEstateFactory.getRandomLong(5L, 50L));
        gastronomy.setDistanceToFM(RandomRealEstateFactory.getRandomLong(5L, 50L));
        gastronomy.setDistanceToMRS(RandomRealEstateFactory.getRandomLong(5L, 50L));
        gastronomy.setDistanceToPT(RandomRealEstateFactory.getRandomLong(5L, 50L));
        gastronomy.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        gastronomy.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        gastronomy.setGastronomyType(RandomRealEstateFactory.getRandomGastronomyType());
        gastronomy.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        gastronomy.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        gastronomy.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        gastronomy.setLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        gastronomy.setListed(RandomRealEstateFactory.getRandomYesNotApplicableType());
        gastronomy.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(100L, 250L));
        gastronomy.setNetFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 5000L));
        gastronomy.setNumberBeds(RandomRealEstateFactory.getRandomLong(10L, 500L));
        gastronomy.setNumberOfFloors(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 10)));
        gastronomy.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        gastronomy.setNumberSeats(RandomRealEstateFactory.getRandomLong(50L, 500L));
        gastronomy.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        gastronomy.setTerrace(RandomRealEstateFactory.getRandomYesNotApplicableType());
        gastronomy.setTotalFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            gastronomy.setConstructionYear(null);
            gastronomy.setConstructionYearUnknown(true);
        } else {
            gastronomy.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        }
        gastronomy.setCourtage(this.commonFactory.createCourtageInfo());
        gastronomy.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        gastronomy.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        gastronomy.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        gastronomy.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            gastronomy.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                gastronomy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                gastronomy.getEnergyCertificate().setElectricityConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                gastronomy.getEnergyCertificate().setHeatingConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                gastronomy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
                gastronomy.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
            } else {
                gastronomy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                gastronomy.getEnergyCertificate().setEnergyConsumptionElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                gastronomy.getEnergyCertificate().setEnergyConsumptionHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                gastronomy.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                gastronomy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            gastronomy.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                gastronomy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                gastronomy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                gastronomy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                gastronomy.getEnergyCertificate().setThermalCharacteristicElectricity(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                gastronomy.getEnergyCertificate().setThermalCharacteristicHeating(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                gastronomy.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                gastronomy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        if (RandomRealEstateFactory.getRandomBoolean()) {
            gastronomy.setCommercializationType(CommercializationType.RENT);
            gastronomy.setPrice(this.getDefaultPrice());
            gastronomy.getPrice().setMarketingType(MarketingType.RENT);
            gastronomy.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
            gastronomy.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(1000L, 50000L));
        } else {
            gastronomy.setCommercializationType(CommercializationType.BUY);
            gastronomy.setPrice(this.getDefaultPrice());
            gastronomy.getPrice().setMarketingType(MarketingType.PURCHASE);
            gastronomy.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            gastronomy.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 9999999L));
        }
        gastronomy.setAdditionalCosts(this.getDefaultPrice());
        gastronomy.getAdditionalCosts().setPriceIntervalType(PriceIntervalType.MONTH);
        gastronomy.getAdditionalCosts().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
    }

    protected void initRealEstate(HouseBuy houseBuy) {
        houseBuy.setBuildingType(RandomRealEstateFactory.getRandomBuildingType());
        houseBuy.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseBuy.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        houseBuy.setConstructionPhase(RandomRealEstateFactory.getRandomConstructionPhaseType());
        houseBuy.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        houseBuy.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        houseBuy.setGuestToilet(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseBuy.setHandicappedAccessible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseBuy.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        houseBuy.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        houseBuy.setLastRefurbishment(RandomRealEstateFactory.getRandomInt(1990, 2014));
        houseBuy.setListed(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseBuy.setLivingSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        houseBuy.setLodgerFlat(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseBuy.setNumberOfBathRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        houseBuy.setNumberOfBedRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        houseBuy.setNumberOfFloors(RandomRealEstateFactory.getRandomInt(1, 10));
        houseBuy.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomInt(1, 10));
        houseBuy.setNumberOfRooms(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        houseBuy.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        houseBuy.setParkingSpaceType(RandomRealEstateFactory.getRandomParkingSpaceType());
        houseBuy.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        houseBuy.setRentalIncome(RandomRealEstateFactory.getRandomDecimal(9999L, 9999999L));
        houseBuy.setRented(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseBuy.setSummerResidencePractical(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseBuy.setUsableFloorSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            houseBuy.setConstructionYear(null);
            houseBuy.setConstructionYearUnknown(true);
        } else {
            houseBuy.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1980));
        }
        houseBuy.setCourtage(this.commonFactory.createCourtageInfo());
        houseBuy.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        houseBuy.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseBuy.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        houseBuy.setEnergyPerformanceCertificate(true);
        houseBuy.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            houseBuy.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                houseBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                houseBuy.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
                houseBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                houseBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                houseBuy.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                houseBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            houseBuy.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                houseBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                houseBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                houseBuy.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                houseBuy.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                houseBuy.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        houseBuy.setPrice(this.getDefaultPrice());
        houseBuy.getPrice().setMarketingType(MarketingType.PURCHASE);
        houseBuy.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        houseBuy.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(10000L, 9999999L));
    }

    protected void initRealEstate(HouseRent houseRent) {
        houseRent.setBaseRent(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
        houseRent.setBuildingType(RandomRealEstateFactory.getRandomBuildingType());
        houseRent.setBuiltInKitchen(RandomRealEstateFactory.getRandomBoolean());
        houseRent.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseRent.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        houseRent.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        houseRent.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        houseRent.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        houseRent.setGuestToilet(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseRent.setHandicappedAccessible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        houseRent.setHeatingCosts(RandomRealEstateFactory.getRandomDecimal(100L, 500L));
        houseRent.setHeatingCostsInServiceCharge(RandomRealEstateFactory.getRandomYesNo());
        houseRent.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        houseRent.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        houseRent.setLastRefurbishment(RandomRealEstateFactory.getRandomInt(1990, 2014));
        houseRent.setLivingSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        houseRent.setNumberOfBathRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        houseRent.setNumberOfBedRooms(RandomRealEstateFactory.getRandomInt(1, 10));
        houseRent.setNumberOfFloors(RandomRealEstateFactory.getRandomInt(1, 10));
        houseRent.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomInt(1, 10));
        houseRent.setNumberOfRooms(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        houseRent.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        houseRent.setParkingSpaceType(RandomRealEstateFactory.getRandomParkingSpaceType());
        houseRent.setPetsAllowed(RandomRealEstateFactory.getRandomPetsAllowedType());
        houseRent.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        houseRent.setServiceCharge(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        houseRent.setTotalRent(RandomRealEstateFactory.getRandomDecimal(1000L, 5000L));
        houseRent.setUsableFloorSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        houseRent.setUseAsFlatshareRoom(RandomRealEstateFactory.getRandomYesNotApplicableType());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            houseRent.setConstructionYear(null);
            houseRent.setConstructionYearUnknown(true);
        } else {
            houseRent.setConstructionYear(RandomRealEstateFactory.getRandomInt(1900, 1980));
        }
        houseRent.setCourtage(this.commonFactory.createCourtageInfo());
        houseRent.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        houseRent.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseRent.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        houseRent.setEnergyPerformanceCertificate(true);
        houseRent.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            houseRent.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                houseRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                houseRent.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
                houseRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                houseRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                houseRent.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                houseRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            houseRent.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                houseRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                houseRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                houseRent.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                houseRent.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                houseRent.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        houseRent.setPrice(this.getDefaultPrice());
        houseRent.getPrice().setMarketingType(MarketingType.RENT);
        houseRent.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
        houseRent.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(250L, 9999L));
    }

    protected void initRealEstate(HouseType houseType) {
        houseType.setAddress(this.commonFactory.createWgs84Address());
        houseType.setBaseArea(RandomRealEstateFactory.getRandomDecimal(100L, 1000L));
        houseType.setBuildingType(RandomRealEstateFactory.getRandomHouseTypeBuildingType());
        houseType.setConstructionMethod(RandomRealEstateFactory.getRandomHouseTypeConstructionMethodType());
        houseType.setContructionPriceInformationNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseType.setEnergyStandardType(RandomRealEstateFactory.getRandomHouseTypeEnergyStandardType());
        houseType.setFloorInformationNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseType.setLivingSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        houseType.setModelInformationNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseType.setNumberOfRooms(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        houseType.setRoofInformationNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseType.setStageOfCompletionType(RandomRealEstateFactory.getRandomHouseTypeStageOfCompletionType());
        houseType.setTotalArea(RandomRealEstateFactory.getRandomDecimal(250L, 2500L));
        houseType.setTypeInformationNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseType.setUValue(RandomRealEstateFactory.getRandomDecimal(10L));
        houseType.setCourtage(this.commonFactory.createCourtageInfo());
        houseType.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        houseType.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        houseType.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        houseType.setPrice(this.getDefaultPrice());
        houseType.getPrice().setMarketingType(MarketingType.PURCHASE);
        houseType.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        houseType.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(10000L, 9999999L));
    }

    protected void initRealEstate(Industry industry) {
        industry.setAdditionalArea(RandomRealEstateFactory.getRandomDecimal(250L, 5000L));
        industry.setAutoLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        industry.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        industry.setConnectedLoad(RandomRealEstateFactory.getRandomLong(1L, 500L));
        industry.setCraneRunway(RandomRealEstateFactory.getRandomYesNotApplicableType());
        industry.setCraneRunwayLoad(RandomRealEstateFactory.getRandomDecimal(500L, 50000L));
        industry.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        industry.setDistanceToAirport(RandomRealEstateFactory.getRandomLong(5L, 50L));
        industry.setDistanceToFM(RandomRealEstateFactory.getRandomLong(5L, 50L));
        industry.setDistanceToMRS(RandomRealEstateFactory.getRandomLong(5L, 50L));
        industry.setDistanceToPT(RandomRealEstateFactory.getRandomLong(5L, 50L));
        industry.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        industry.setFloorLoad(RandomRealEstateFactory.getRandomDecimal(500L, 50000L));
        industry.setFlooringType(RandomRealEstateFactory.getRandomFlooringType());
        industry.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        industry.setGoodsLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        industry.setGoodsLiftLoad(RandomRealEstateFactory.getRandomDecimal(500L, 50000L));
        industry.setHallHeight(RandomRealEstateFactory.getRandomDecimal(3L, 15L));
        industry.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        industry.setIndustryType(RandomRealEstateFactory.getRandomIndustryType());
        industry.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        industry.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        industry.setLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        industry.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
        industry.setNetFloorSpace(RandomRealEstateFactory.getRandomDecimal(100L, 10000L));
        industry.setNumberOfFloors(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 10)));
        industry.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        industry.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        industry.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        industry.setRamp(RandomRealEstateFactory.getRandomYesNotApplicableType());
        industry.setTotalFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            industry.setConstructionYear(null);
            industry.setConstructionYearUnknown(true);
        } else {
            industry.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        }
        industry.setCourtage(this.commonFactory.createCourtageInfo());
        industry.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        industry.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        industry.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        industry.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            industry.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                industry.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                industry.getEnergyCertificate().setElectricityConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                industry.getEnergyCertificate().setHeatingConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                industry.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
                industry.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
            } else {
                industry.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                industry.getEnergyCertificate().setEnergyConsumptionElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                industry.getEnergyCertificate().setEnergyConsumptionHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                industry.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                industry.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            industry.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                industry.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                industry.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                industry.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                industry.getEnergyCertificate().setThermalCharacteristicElectricity(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                industry.getEnergyCertificate().setThermalCharacteristicHeating(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                industry.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                industry.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        if (RandomRealEstateFactory.getRandomBoolean()) {
            industry.setCommercializationType(CommercializationType.RENT);
            industry.setPrice(this.getDefaultPrice());
            industry.getPrice().setMarketingType(MarketingType.RENT);
            industry.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
            industry.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
        } else {
            industry.setCommercializationType(CommercializationType.BUY);
            industry.setPrice(this.getDefaultPrice());
            industry.getPrice().setMarketingType(MarketingType.PURCHASE);
            industry.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            industry.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
        }
        industry.setAdditionalCosts(this.getDefaultPrice());
        industry.getAdditionalCosts().setPriceIntervalType(PriceIntervalType.MONTH);
        industry.getAdditionalCosts().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
    }

    protected void initRealEstate(Investment investment) {
        investment.setAdditionalArea(RandomRealEstateFactory.getRandomDecimal(250L, 5000L));
        investment.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        investment.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        investment.setDistanceToAirport(RandomRealEstateFactory.getRandomLong(5L, 50L));
        investment.setDistanceToFM(RandomRealEstateFactory.getRandomLong(5L, 50L));
        investment.setDistanceToMRS(RandomRealEstateFactory.getRandomLong(5L, 50L));
        investment.setDistanceToPT(RandomRealEstateFactory.getRandomLong(5L, 50L));
        investment.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        investment.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        investment.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        investment.setIndustrialArea(RandomRealEstateFactory.getRandomDecimal(500L, 50000L));
        investment.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        investment.setInvestmentType(RandomRealEstateFactory.getRandomInvestmentType());
        investment.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        investment.setLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        investment.setListed(RandomRealEstateFactory.getRandomYesNotApplicableType());
        investment.setLivingSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        investment.setNetFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 5000L));
        investment.setNumberOfFloors(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 10)));
        investment.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        investment.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        investment.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        investment.setPriceMultiplier(RandomRealEstateFactory.getRandomDecimal(1L, 50L));
        investment.setTotalFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        investment.setCourtage(this.commonFactory.createCourtageInfo());
        investment.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        investment.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        investment.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        investment.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            investment.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                investment.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                investment.getEnergyCertificate().setElectricityConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                investment.getEnergyCertificate().setHeatingConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                investment.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
                investment.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
            } else {
                investment.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                investment.getEnergyCertificate().setEnergyConsumptionElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                investment.getEnergyCertificate().setEnergyConsumptionHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                investment.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                investment.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            investment.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                investment.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                investment.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                investment.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                investment.getEnergyCertificate().setThermalCharacteristicElectricity(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                investment.getEnergyCertificate().setThermalCharacteristicHeating(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                investment.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                investment.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        investment.setPrice(this.getDefaultPrice());
        investment.getPrice().setMarketingType(MarketingType.PURCHASE);
        investment.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        investment.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(10000L, 9999999L));
        investment.setAdditionalCosts(this.getDefaultPrice());
        investment.getAdditionalCosts().setPriceIntervalType(PriceIntervalType.MONTH);
        investment.getAdditionalCosts().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
        investment.setOtherCosts(this.getDefaultPrice());
        investment.getOtherCosts().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 10000L));
        investment.setPricePerSQM(this.getDefaultPrice());
        investment.getPricePerSQM().setValue(RandomRealEstateFactory.getRandomDecimal(1L, 500L));
        investment.setRentalIncomeActual(this.getDefaultPrice());
        investment.getRentalIncomeActual().setPriceIntervalType(PriceIntervalType.YEAR);
        investment.getRentalIncomeActual().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 9999999L));
        investment.setRentalIncomeTarget(this.getDefaultPrice());
        investment.getRentalIncomeTarget().setPriceIntervalType(PriceIntervalType.YEAR);
        investment.getRentalIncomeTarget().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 9999999L));
    }

    protected void initRealEstate(LivingBuySite livingBuySite) {
        livingBuySite.setBuildingPermission(RandomRealEstateFactory.getRandomBoolean());
        livingBuySite.setDemolition(RandomRealEstateFactory.getRandomBoolean());
        livingBuySite.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        livingBuySite.setGfz(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        livingBuySite.setGrz(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        livingBuySite.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
        livingBuySite.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        livingBuySite.setRecommendedUseTypes(this.createRandomSiteRecommendedUseTypes());
        livingBuySite.setShortTermConstructible(RandomRealEstateFactory.getRandomBoolean());
        livingBuySite.setSiteConstructibleType(RandomRealEstateFactory.getRandomSiteConstructibleType());
        livingBuySite.setSiteDevelopmentType(RandomRealEstateFactory.getRandomSiteDevelopmentType());
        livingBuySite.setTenancy(RandomRealEstateFactory.getRandomLong(100L));
        livingBuySite.setCourtage(this.commonFactory.createCourtageInfo());
        livingBuySite.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        livingBuySite.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        livingBuySite.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        livingBuySite.setCommercializationType(CommercializationType.BUY);
        livingBuySite.setPrice(this.getDefaultPrice());
        livingBuySite.getPrice().setMarketingType(MarketingType.PURCHASE);
        livingBuySite.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        livingBuySite.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
    }

    protected void initRealEstate(LivingRentSite livingRentSite) {
        livingRentSite.setBuildingPermission(RandomRealEstateFactory.getRandomBoolean());
        livingRentSite.setDemolition(RandomRealEstateFactory.getRandomBoolean());
        livingRentSite.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        livingRentSite.setGfz(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        livingRentSite.setGrz(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        livingRentSite.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
        livingRentSite.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        livingRentSite.setRecommendedUseTypes(this.createRandomSiteRecommendedUseTypes());
        livingRentSite.setShortTermConstructible(RandomRealEstateFactory.getRandomBoolean());
        livingRentSite.setSiteConstructibleType(RandomRealEstateFactory.getRandomSiteConstructibleType());
        livingRentSite.setSiteDevelopmentType(RandomRealEstateFactory.getRandomSiteDevelopmentType());
        livingRentSite.setTenancy(RandomRealEstateFactory.getRandomLong(100L));
        livingRentSite.setCourtage(this.commonFactory.createCourtageInfo());
        livingRentSite.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        livingRentSite.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        livingRentSite.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        livingRentSite.setCommercializationType(CommercializationType.LEASE);
        livingRentSite.setPrice(this.getDefaultPrice());
        livingRentSite.getPrice().setMarketingType(MarketingType.LEASE);
        livingRentSite.getPrice().setPriceIntervalType(PriceIntervalType.YEAR);
        livingRentSite.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 999999L));
    }

    protected void initRealEstate(Office office) {
        office.setAdditionalArea(RandomRealEstateFactory.getRandomDecimal(250L, 5000L));
        office.setAirConditioning(RandomRealEstateFactory.getRandomAirConditioningType());
        office.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        office.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        office.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        office.setDistanceToAirport(RandomRealEstateFactory.getRandomLong(5L, 50L));
        office.setDistanceToFM(RandomRealEstateFactory.getRandomLong(5L, 50L));
        office.setDistanceToMRS(RandomRealEstateFactory.getRandomLong(5L, 50L));
        office.setDistanceToPT(RandomRealEstateFactory.getRandomLong(5L, 50L));
        office.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        office.setFlooringType(RandomRealEstateFactory.getRandomFlooringType());
        office.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        office.setHandicappedAccessible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        office.setHasCanteen(RandomRealEstateFactory.getRandomYesNotApplicableType());
        office.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        office.setHighVoltage(RandomRealEstateFactory.getRandomYesNotApplicableType());
        office.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        office.setKitchenComplete(RandomRealEstateFactory.getRandomYesNotApplicableType());
        office.setLanCables(RandomRealEstateFactory.getRandomItInfrastructureType());
        office.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        office.setLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        office.setListed(RandomRealEstateFactory.getRandomYesNotApplicableType());
        office.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
        office.setNetFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 5000L));
        office.setNumberOfFloors(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 10)));
        office.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        office.setOfficeType(RandomRealEstateFactory.getRandomOfficeType());
        office.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        office.setTotalFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            office.setConstructionYear(null);
            office.setConstructionYearUnknown(true);
        } else {
            office.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        }
        office.setCourtage(this.commonFactory.createCourtageInfo());
        office.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        office.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        office.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        office.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            office.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                office.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                office.getEnergyCertificate().setElectricityConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                office.getEnergyCertificate().setHeatingConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                office.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
                office.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
            } else {
                office.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                office.getEnergyCertificate().setEnergyConsumptionElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                office.getEnergyCertificate().setEnergyConsumptionHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                office.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                office.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            office.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                office.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                office.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                office.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                office.getEnergyCertificate().setThermalCharacteristicElectricity(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                office.getEnergyCertificate().setThermalCharacteristicHeating(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                office.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                office.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        office.setOfficeRentDurations(this.realEstatesFactory.createOfficeOfficeRentDurations());
        office.getOfficeRentDurations().getOfficeRentDuration().addAll(Arrays.asList(OfficeRentDuration.values()));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            office.setCommercializationType(CommercializationType.RENT);
            office.setPrice(this.getDefaultPrice());
            office.getPrice().setMarketingType(MarketingType.RENT);
            office.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
            office.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
        } else {
            office.setCommercializationType(CommercializationType.BUY);
            office.setPrice(this.getDefaultPrice());
            office.getPrice().setMarketingType(MarketingType.PURCHASE);
            office.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            office.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
        }
        office.setAdditionalCosts(this.getDefaultPrice());
        office.getAdditionalCosts().setPriceIntervalType(PriceIntervalType.MONTH);
        office.getAdditionalCosts().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
    }

    protected void initRealEstate(SeniorCare seniorCare) {
        seniorCare.setBalconyAvailable(RandomRealEstateFactory.getRandomBalconyAvailableType());
        seniorCare.setBarrierFree(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setBranchEntry(RandomRealEstateFactory.getRandomBoolean());
        seniorCare.setCareLevel(RandomRealEstateFactory.getRandomCareLevel());
        seniorCare.setCareOfAlzheimer(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCareOfArtificialRespiration(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCareOfComaVigil(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCareOfDementia(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCareOfMultipleSclerosis(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCareOfParkinson(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCareOfStroke(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCleaningServiceAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCookingFacilitiesAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCulturalProgramAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setGuestApartmentsAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setHandicappedAccessible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setKitchenAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setLeisureActivitiesAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setLivingSpaceFrom(RandomRealEstateFactory.getRandomDecimal(20L, 50L));
        seniorCare.setLivingSpaceTo(RandomRealEstateFactory.getRandomDecimal(50L, 150L));
        seniorCare.setNumberOfBeds(RandomRealEstateFactory.getRandomLong(1L, 10L));
        seniorCare.setNumberOfLookedAfterApartments(RandomRealEstateFactory.getRandomLong(1L, 10L));
        seniorCare.setNumberOfNursingPlaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        seniorCare.setOpening(RandomRealEstateFactory.getRandomCalendar());
        seniorCare.setOwnFurniturePossible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setPetsAllowed(RandomRealEstateFactory.getRandomPetsAllowedType());
        seniorCare.setReligiousOfferingsAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setRestaurantAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setRoomType(RandomRealEstateFactory.getRandomRoomType());
        seniorCare.setSecurity24Hours(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setShoppingFacilitiesAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setShortDescription(StringUtils.abbreviate((String)LOREM.getWords(3, 15), (int)200));
        seniorCare.setTherapyOfferingsAvailable(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setTrialLivingPossible(RandomRealEstateFactory.getRandomYesNotApplicableType());
        seniorCare.setCareTypes(this.commonFactory.createCareTypes());
        seniorCare.getCareTypes().getCareType().addAll(Arrays.asList(CareType.values()));
        seniorCare.setPrice(this.getDefaultPrice());
        seniorCare.getPrice().setMarketingType(MarketingType.RENT);
        seniorCare.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
        seniorCare.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 9999L));
    }

    protected void initRealEstate(ShortTermAccommodation shortTermAccommodation) {
        shortTermAccommodation.setBalcony(RandomRealEstateFactory.getRandomBoolean());
        shortTermAccommodation.setBaseRent(RandomRealEstateFactory.getRandomDecimal(200L, 1500L));
        shortTermAccommodation.setCellar(RandomRealEstateFactory.getRandomBoolean());
        shortTermAccommodation.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        shortTermAccommodation.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        shortTermAccommodation.setEndRentalDate(RandomRealEstateFactory.getRandomCalendar());
        shortTermAccommodation.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        shortTermAccommodation.setFloor(String.valueOf(RandomRealEstateFactory.getRandomLong(5L)));
        shortTermAccommodation.setGarden(RandomRealEstateFactory.getRandomBoolean());
        shortTermAccommodation.setGender(RandomRealEstateFactory.getRandomFlatMateGenderType());
        shortTermAccommodation.setGuestToilet(RandomRealEstateFactory.getRandomBoolean());
        shortTermAccommodation.setHandicappedAccessible(RandomRealEstateFactory.getRandomBoolean());
        shortTermAccommodation.setHasFurniture(RandomRealEstateFactory.getRandomYesNoNotApplicableType());
        shortTermAccommodation.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        shortTermAccommodation.setLift(RandomRealEstateFactory.getRandomBoolean());
        shortTermAccommodation.setLivingSpace(RandomRealEstateFactory.getRandomDecimal(20L, 300L));
        shortTermAccommodation.setMaxNumberOfPersons(RandomRealEstateFactory.getRandomLong(4L, 10L));
        shortTermAccommodation.setMaxRentalTime(RandomRealEstateFactory.getRandomDecimal(12L, 24L));
        shortTermAccommodation.setMinRentalTime(RandomRealEstateFactory.getRandomDecimal(3L, 12L));
        shortTermAccommodation.setNonSmoker(RandomRealEstateFactory.getRandomBoolean());
        shortTermAccommodation.setNumberOfFloors(RandomRealEstateFactory.getRandomLong(1L, 10L));
        shortTermAccommodation.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        shortTermAccommodation.setNumberOfRooms(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        shortTermAccommodation.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        shortTermAccommodation.setParkingSpaceType(RandomRealEstateFactory.getRandomParkingSpaceType());
        shortTermAccommodation.setPetsAllowed(RandomRealEstateFactory.getRandomPetsAllowedType());
        shortTermAccommodation.setServiceCharge(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        shortTermAccommodation.setShortTermAccomodationType(RandomRealEstateFactory.getRandomShortTermAccommodationType());
        shortTermAccommodation.setStartRentalDate(RandomRealEstateFactory.getRandomCalendar());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            shortTermAccommodation.setConstructionYear(null);
            shortTermAccommodation.setConstructionYearUnknown(true);
        } else {
            shortTermAccommodation.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        }
        shortTermAccommodation.setCourtage(this.commonFactory.createCourtageInfo());
        shortTermAccommodation.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        shortTermAccommodation.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        shortTermAccommodation.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        shortTermAccommodation.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            shortTermAccommodation.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                shortTermAccommodation.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                shortTermAccommodation.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
                shortTermAccommodation.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                shortTermAccommodation.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                shortTermAccommodation.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                shortTermAccommodation.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            shortTermAccommodation.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                shortTermAccommodation.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                shortTermAccommodation.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                shortTermAccommodation.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                shortTermAccommodation.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                shortTermAccommodation.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        shortTermAccommodation.setPrice(this.getDefaultPrice());
        shortTermAccommodation.getPrice().setMarketingType(MarketingType.RENT);
        shortTermAccommodation.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
        shortTermAccommodation.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(200L, 9999L));
    }

    protected void initRealEstate(SpecialPurpose specialPurpose) {
        specialPurpose.setAdditionalArea(RandomRealEstateFactory.getRandomDecimal(250L, 5000L));
        specialPurpose.setBasement(RandomRealEstateFactory.getRandomYesNotApplicableType());
        specialPurpose.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        specialPurpose.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        specialPurpose.setDistanceToAirport(RandomRealEstateFactory.getRandomLong(5L, 50L));
        specialPurpose.setDistanceToFM(RandomRealEstateFactory.getRandomLong(5L, 50L));
        specialPurpose.setDistanceToMRS(RandomRealEstateFactory.getRandomLong(5L, 50L));
        specialPurpose.setDistanceToPT(RandomRealEstateFactory.getRandomLong(5L, 50L));
        specialPurpose.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        specialPurpose.setFlooringType(RandomRealEstateFactory.getRandomFlooringType());
        specialPurpose.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        specialPurpose.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        specialPurpose.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        specialPurpose.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        specialPurpose.setLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        specialPurpose.setListed(RandomRealEstateFactory.getRandomYesNotApplicableType());
        specialPurpose.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
        specialPurpose.setNetFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 5000L));
        specialPurpose.setNumberOfFloors(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 10)));
        specialPurpose.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        specialPurpose.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        specialPurpose.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        specialPurpose.setSpecialPurposePropertyType(RandomRealEstateFactory.getRandomSpecialPurposeType());
        specialPurpose.setTotalFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            specialPurpose.setConstructionYear(null);
            specialPurpose.setConstructionYearUnknown(true);
        } else {
            specialPurpose.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        }
        specialPurpose.setCourtage(this.commonFactory.createCourtageInfo());
        specialPurpose.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        specialPurpose.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        specialPurpose.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        specialPurpose.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            specialPurpose.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                specialPurpose.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                specialPurpose.getEnergyCertificate().setElectricityConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                specialPurpose.getEnergyCertificate().setHeatingConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                specialPurpose.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
                specialPurpose.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
            } else {
                specialPurpose.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                specialPurpose.getEnergyCertificate().setEnergyConsumptionElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                specialPurpose.getEnergyCertificate().setEnergyConsumptionHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                specialPurpose.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                specialPurpose.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            specialPurpose.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                specialPurpose.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                specialPurpose.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                specialPurpose.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                specialPurpose.getEnergyCertificate().setThermalCharacteristicElectricity(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                specialPurpose.getEnergyCertificate().setThermalCharacteristicHeating(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                specialPurpose.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                specialPurpose.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        if (RandomRealEstateFactory.getRandomBoolean()) {
            specialPurpose.setCommercializationType(CommercializationType.RENT);
            specialPurpose.setPrice(this.getDefaultPrice());
            specialPurpose.getPrice().setMarketingType(MarketingType.RENT);
            specialPurpose.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
            specialPurpose.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
        } else {
            specialPurpose.setCommercializationType(CommercializationType.BUY);
            specialPurpose.setPrice(this.getDefaultPrice());
            specialPurpose.getPrice().setMarketingType(MarketingType.PURCHASE);
            specialPurpose.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            specialPurpose.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
        }
        specialPurpose.setAdditionalCosts(this.getDefaultPrice());
        specialPurpose.getAdditionalCosts().setPriceIntervalType(PriceIntervalType.MONTH);
        specialPurpose.getAdditionalCosts().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
    }

    protected void initRealEstate(Store store) {
        store.setAdditionalArea(RandomRealEstateFactory.getRandomDecimal(250L, 5000L));
        store.setCellar(RandomRealEstateFactory.getRandomYesNotApplicableType());
        store.setCondition(RandomRealEstateFactory.getRandomRealEstateCondition());
        store.setDeposit(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        store.setDistanceToAirport(RandomRealEstateFactory.getRandomLong(5L, 50L));
        store.setDistanceToFM(RandomRealEstateFactory.getRandomLong(5L, 50L));
        store.setDistanceToMRS(RandomRealEstateFactory.getRandomLong(5L, 50L));
        store.setDistanceToPT(RandomRealEstateFactory.getRandomLong(5L, 50L));
        store.setEnergySourcesEnev2014(this.createRandomEnergySourcesEnev2014());
        store.setFloorLoad(RandomRealEstateFactory.getRandomDecimal(500L, 50000L));
        store.setFlooringType(RandomRealEstateFactory.getRandomFlooringType());
        store.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        store.setGoodsLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        store.setGoodsLiftLoad(RandomRealEstateFactory.getRandomDecimal(500L, 50000L));
        store.setHeatingTypeEnev2014(RandomRealEstateFactory.getRandomHeatingTypeEnev2014());
        store.setInteriorQuality(RandomRealEstateFactory.getRandomInteriorQuality());
        store.setLastRefurbishment(RandomRealEstateFactory.getRandomLong(1990L, 2014L));
        store.setLift(RandomRealEstateFactory.getRandomYesNotApplicableType());
        store.setListed(RandomRealEstateFactory.getRandomYesNotApplicableType());
        store.setLocationClassificationType(RandomRealEstateFactory.getRandomLocationClassificationType());
        store.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
        store.setNetFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 5000L));
        store.setNumberOfFloors(String.valueOf(RandomRealEstateFactory.getRandomInt(1, 10)));
        store.setNumberOfParkingSpaces(RandomRealEstateFactory.getRandomLong(1L, 10L));
        store.setParkingSpacePrice(RandomRealEstateFactory.getRandomDecimal(30L, 300L));
        store.setRamp(RandomRealEstateFactory.getRandomYesNotApplicableType());
        store.setShopWindowLength(RandomRealEstateFactory.getRandomDecimal(2L, 15L));
        store.setStoreType(RandomRealEstateFactory.getRandomStoreType());
        store.setSupplyType(RandomRealEstateFactory.getRandomSupplyType());
        store.setTotalFloorSpace(RandomRealEstateFactory.getRandomDecimal(50L, 500L));
        if (RandomRealEstateFactory.getRandomBoolean()) {
            store.setConstructionYear(null);
            store.setConstructionYearUnknown(true);
        } else {
            store.setConstructionYear(RandomRealEstateFactory.getRandomLong(1900L, 1980L));
        }
        store.setCourtage(this.commonFactory.createCourtageInfo());
        store.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        store.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        store.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        store.setEnergyCertificate(this.commonFactory.createEnergyPerformanceCertificate());
        if (RandomRealEstateFactory.getRandomBoolean()) {
            store.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_CONSUMPTION);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                store.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                store.getEnergyCertificate().setElectricityConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                store.getEnergyCertificate().setHeatingConsumption(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                store.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
                store.setEnergyConsumptionContainsWarmWater(RandomRealEstateFactory.getRandomYesNotApplicableType());
            } else {
                store.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                store.getEnergyCertificate().setEnergyConsumptionElectricity(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                store.getEnergyCertificate().setEnergyConsumptionHeating(RandomRealEstateFactory.getRandomDecimal(10L, 250L));
                store.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                store.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        } else {
            store.setBuildingEnergyRatingType(BuildingEnergyRatingType.ENERGY_REQUIRED);
            if (RandomRealEstateFactory.getRandomBoolean()) {
                store.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.BEFORE_01_MAY_2014);
                store.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            } else {
                store.getEnergyCertificate().setEnergyCertificateCreationDate(EnergyCertificateCreationDate.FROM_01_MAY_2014);
                store.getEnergyCertificate().setThermalCharacteristicElectricity(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                store.getEnergyCertificate().setThermalCharacteristicHeating(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
                store.getEnergyCertificate().setEnergyEfficiencyClass(RandomRealEstateFactory.getRandomEnergyEfficiencyClass());
                store.setThermalCharacteristic(RandomRealEstateFactory.getRandomDecimal(20L, 500L));
            }
        }
        if (RandomRealEstateFactory.getRandomBoolean()) {
            store.setCommercializationType(CommercializationType.RENT);
            store.setPrice(this.getDefaultPrice());
            store.getPrice().setMarketingType(MarketingType.RENT);
            store.getPrice().setPriceIntervalType(PriceIntervalType.MONTH);
            store.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
        } else {
            store.setCommercializationType(CommercializationType.BUY);
            store.setPrice(this.getDefaultPrice());
            store.getPrice().setMarketingType(MarketingType.PURCHASE);
            store.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            store.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
        }
        store.setAdditionalCosts(this.getDefaultPrice());
        store.getAdditionalCosts().setPriceIntervalType(PriceIntervalType.MONTH);
        store.getAdditionalCosts().setValue(RandomRealEstateFactory.getRandomDecimal(500L, 5000L));
    }

    protected void initRealEstate(TradeSite tradeSite) {
        tradeSite.setBuildingPermission(RandomRealEstateFactory.getRandomBoolean());
        tradeSite.setDemolition(RandomRealEstateFactory.getRandomBoolean());
        tradeSite.setFreeFrom(StringUtils.abbreviate((String)LOREM.getWords(1, 10), (int)50));
        tradeSite.setGfz(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        tradeSite.setGrz(RandomRealEstateFactory.getRandomDecimal(1L, 10L));
        tradeSite.setMinDivisible(RandomRealEstateFactory.getRandomDecimal(500L, 2500L));
        tradeSite.setPlotArea(RandomRealEstateFactory.getRandomDecimal(100L, 5000L));
        tradeSite.setRecommendedUseTypes(this.createRandomSiteRecommendedUseForTradeTypes());
        tradeSite.setShortTermConstructible(RandomRealEstateFactory.getRandomBoolean());
        tradeSite.setSiteConstructibleType(RandomRealEstateFactory.getRandomSiteConstructibleType());
        tradeSite.setSiteDevelopmentType(RandomRealEstateFactory.getRandomSiteDevelopmentType());
        tradeSite.setTenancy(RandomRealEstateFactory.getRandomLong(100L));
        tradeSite.setUtilizationTradeSite(RandomRealEstateFactory.getRandomUtilizationTradeSite());
        tradeSite.setCourtage(this.commonFactory.createCourtageInfo());
        tradeSite.getCourtage().setCourtage(StringUtils.abbreviate((String)LOREM.getWords(1, 5), (int)100));
        tradeSite.getCourtage().setCourtageNote(StringUtils.abbreviate((String)LOREM.getParagraphs(2, 10), (int)1000));
        tradeSite.getCourtage().setHasCourtage(YesNoNotApplicableType.YES);
        if (RandomRealEstateFactory.getRandomBoolean()) {
            tradeSite.setCommercializationType(CommercializationType.LEASE);
            tradeSite.setPrice(this.getDefaultPrice());
            tradeSite.getPrice().setMarketingType(MarketingType.LEASE);
            tradeSite.getPrice().setPriceIntervalType(PriceIntervalType.YEAR);
            tradeSite.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
        } else {
            tradeSite.setCommercializationType(CommercializationType.BUY);
            tradeSite.setPrice(this.getDefaultPrice());
            tradeSite.getPrice().setMarketingType(MarketingType.PURCHASE);
            tradeSite.getPrice().setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            tradeSite.getPrice().setValue(RandomRealEstateFactory.getRandomDecimal(50000L, 999999L));
        }
    }

    public static enum Type {
        APARTMENT_BUY(ApartmentBuy.class),
        APARTMENT_RENT(ApartmentRent.class),
        ASSISTED_LIVING(AssistedLiving.class),
        COMPULSORY_AUCTION(CompulsoryAuction.class),
        FLAT_SHARE_ROOM(FlatShareRoom.class),
        GARAGE_BUY(GarageBuy.class),
        GARAGE_RENT(GarageRent.class),
        GASTRONOMY(Gastronomy.class),
        HOUSE_BUY(HouseBuy.class),
        HOUSE_RENT(HouseRent.class),
        HOUSE_TYPE(HouseType.class),
        INDUSTRY(Industry.class),
        INVESTMENT(Investment.class),
        LIVING_BUY_SITE(LivingBuySite.class),
        LIVING_RENT_SITE(LivingRentSite.class),
        OFFICE(Office.class),
        SENIOR_CARE(SeniorCare.class),
        SHORT_TERM_ACCOMODATION(ShortTermAccommodation.class),
        SPECIAL_PURPOSE(SpecialPurpose.class),
        STORE(Store.class),
        TRADE_SITE(TradeSite.class);

        private final Class typeClass;

        private Type(Class clazz) {
            this.typeClass = clazz;
        }

        public RealEstate create() {
            try {
                return (RealEstate)this.typeClass.newInstance();
            }
            catch (Exception exception) {
                LOGGER.error("Can't create real estate object for " + this.name() + "!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                return null;
            }
        }

        public Class getTypeClass() {
            return this.typeClass;
        }
    }
}

