/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.xml.common.Message;
import org.openestate.is24.restapi.xml.common.MessageCode;
import org.openestate.is24.restapi.xml.common.Messages;

public class Resource {
    private static Pattern CREATED_PATTERN = null;
    private static Pattern MESSAGE_PATTERN = null;
    public final String type;
    public final long id;

    public Resource(String string, long l) {
        this.type = string;
        this.id = l;
    }

    public static Resource getCreatedResource(Messages messages) {
        return messages != null && !messages.getMessage().isEmpty() ? Resource.getCreatedResource(messages.getMessage().get(0)) : null;
    }

    public static Resource getCreatedResource(Message message) {
        Matcher matcher;
        if (message == null) {
            return null;
        }
        if (!MessageCode.MESSAGE_RESOURCE_CREATED.equals((Object)message.getMessageCode())) {
            return null;
        }
        String string = StringUtils.trimToNull((String)message.getMessage());
        if (string == null) {
            return null;
        }
        if (CREATED_PATTERN == null) {
            CREATED_PATTERN = Pattern.compile("^.*\\[([\\w]+)\\].*\\[([\\d]+)\\].*");
        }
        if (!(matcher = CREATED_PATTERN.matcher(string)).find()) {
            return null;
        }
        return new Resource(StringUtils.trimToNull((String)matcher.group(1)), Long.parseLong((String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToNull((String)matcher.group(2)), (CharSequence)"0")));
    }

    public static Resource getMessageResource(Messages messages) {
        return messages != null && !messages.getMessage().isEmpty() ? Resource.getMessageResource(messages.getMessage().get(0)) : null;
    }

    public static Resource getMessageResource(Message message) {
        Matcher matcher;
        if (message == null) {
            return null;
        }
        String string = StringUtils.trimToNull((String)message.getMessage());
        if (string == null) {
            return null;
        }
        if (MESSAGE_PATTERN == null) {
            MESSAGE_PATTERN = Pattern.compile("^.*\\[MESSAGE:([^\\]]*):([\\d]+)\\].*");
        }
        if (!(matcher = MESSAGE_PATTERN.matcher(string)).find()) {
            return null;
        }
        return new Resource(StringUtils.trimToNull((String)matcher.group(1)), Long.parseLong((String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToNull((String)matcher.group(2)), (CharSequence)"0")));
    }
}

