/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils.validator;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openestate.is24.restapi.utils.validator.DomainValidator;
import org.openestate.is24.restapi.utils.validator.InetAddressValidator;

public class EmailValidator
implements Serializable {
    private static final long serialVersionUID = 1705927040799295880L;
    private static final String SPECIAL_CHARS = "\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]";
    private static final String VALID_CHARS = "[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]";
    private static final String QUOTED_USER = "(\"[^\"]*\")";
    private static final String WORD = "(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))";
    private static final String LEGAL_ASCII_REGEX = "^\\p{ASCII}+$";
    private static final String EMAIL_REGEX = "^\\s*?(.+)@(.+?)\\s*$";
    private static final String IP_DOMAIN_REGEX = "^\\[(.*)\\]$";
    private static final String USER_REGEX = "^\\s*(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))(\\.(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\")))*$";
    private static final Pattern MATCH_ASCII_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^\\s*?(.+)@(.+?)\\s*$");
    private static final Pattern IP_DOMAIN_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final Pattern USER_PATTERN = Pattern.compile("^\\s*(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))(\\.(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\")))*$");
    private final boolean allowLocal;
    private static final EmailValidator EMAIL_VALIDATOR = new EmailValidator(false);
    private static final EmailValidator EMAIL_VALIDATOR_WITH_LOCAL = new EmailValidator(true);

    public static EmailValidator getInstance() {
        return EMAIL_VALIDATOR;
    }

    public static EmailValidator getInstance(boolean bl) {
        if (bl) {
            return EMAIL_VALIDATOR_WITH_LOCAL;
        }
        return EMAIL_VALIDATOR;
    }

    protected EmailValidator(boolean bl) {
        this.allowLocal = bl;
    }

    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = MATCH_ASCII_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        Matcher matcher2 = EMAIL_PATTERN.matcher(string);
        if (!matcher2.matches()) {
            return false;
        }
        if (string.endsWith(".")) {
            return false;
        }
        if (!this.isValidUser(matcher2.group(1))) {
            return false;
        }
        return this.isValidDomain(matcher2.group(2));
    }

    protected boolean isValidDomain(String string) {
        Matcher matcher = IP_DOMAIN_PATTERN.matcher(string);
        if (matcher.matches()) {
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            return inetAddressValidator.isValid(matcher.group(1));
        }
        DomainValidator domainValidator = DomainValidator.getInstance(this.allowLocal);
        return domainValidator.isValid(string);
    }

    protected boolean isValidUser(String string) {
        return USER_PATTERN.matcher(string).matches();
    }
}

