/**
 * Generated by Gas3 v2.2.0 (Granite Data Services).
 *
 * NOTE: this file is only generated if it does not exist. You may safely put
 * your custom code here.
 */

package org.openforis.collect.model.proxy {
	import mx.collections.ArrayCollection;
	import mx.collections.IList;
	
	import org.openforis.collect.metamodel.proxy.EntityDefinitionProxy;
	import org.openforis.collect.metamodel.proxy.NodeDefinitionProxy;
	import org.openforis.collect.util.MathUtil;

	/**
	 * @author S. Ricci
	 */
    [Bindable]
    [RemoteClass(alias="org.openforis.collect.model.proxy.NodeProxy")]
    public class NodeProxy extends NodeProxyBase {
		
		private var _record:RecordProxy;
		private var _definition:NodeDefinitionProxy;
		private var _parent:EntityProxy;
		private var _index:int;
		
		public function init():void {
			updateIndex();
			setParentReferencesOnChildren();
		}

		public function get record():RecordProxy {
			return _record;
		}
		
		public function set record(record:RecordProxy):void {
			_record = record;
		}
		
		public function get name():String {
			return _definition.name;
		}
		
		public function hasErrors():Boolean {
			return false;
		}
		
		public function get empty():Boolean {
			return true;
		}
		
		public function get index():int {
			return _index;
		}
		
		public function set index(value:int):void {
			_index = value;
		}
		
		public function updateIndex():void {
			index = calculateIndex();
		}
		
		protected function calculateIndex():int {
			if ( parent == null ) {
				return 0;
			} else {
				var siblings:IList = getSiblings();
				var idx:int = siblings.getItemIndex(this);
				return idx;
			}
		}
		
		public function getNextSibling(offset:int = 1):NodeProxy {
			return getSibling(offset);
		}
		
		public function getPreviousSibling(offset:int = 1):NodeProxy {
			return getSibling(-offset);
		}

		public function getSibling(offset:int, circularLookup:Boolean = false):NodeProxy {
			var result:NodeProxy = null;
			var siblings:IList = getSiblings();
			if ( siblings != null ) {
				var itemIndex:int = siblings.getItemIndex(this);
				var numSiblings:int = siblings.length;
				var resultIndex:int = itemIndex + offset;
				if ( circularLookup ) {
					resultIndex = MathUtil.module(resultIndex, numSiblings);
				} else if ( resultIndex < 0 ) {
					resultIndex = 0;
				} else if ( resultIndex >= numSiblings ) {
					resultIndex = numSiblings - 1;
				}
				if ( resultIndex != itemIndex ) {
					result = NodeProxy(siblings.getItemAt(resultIndex));
				}
			}
			return result;
		}
		
		protected function setParentReferencesOnChildren():void {
			//to be implemented in subclasses
		}
		
		/**
		 * Returns the nearest multiple entity ancestor or the root entity 
		 */
		public function getParentMultipleEntity():EntityProxy {
			var currentParent:NodeProxy = parent;
			while ( currentParent != null ) {
				if ( currentParent is EntityProxy && ( 
						currentParent.definition.multiple ||
						currentParent.parent == null
					)) {
					return EntityProxy(currentParent);
				}
				currentParent = currentParent.parent;
			}
			return null;
		}
		
		public function get cousins():IList {
			var nearestMultipleEntity:EntityProxy = getParentMultipleEntity();
			var result:IList = nearestMultipleEntity.getDescendantCousins(definition);
			return result;
		}
		
		public function get allCousinsNotRelevant():Boolean {
			var allNotRelevant:Boolean = true;
			for each (var cousin:NodeProxy in cousins) {
				if ( ! cousin.relevant ) {
					allNotRelevant = false;
					break;
				}
			}
			return allNotRelevant;
		}
		
		public function getSiblings():IList {
			if ( parent == null ) {
				return null;
			} else {
				return parent.getChildren(definition);
			}
		}
		
		public function get ancestors():IList {
			var result:IList = new ArrayCollection();
			var currentParent:EntityProxy = parent;
			while (currentParent != null) {
				result.addItemAt(currentParent, 0);
				currentParent = currentParent.parent;
			}
			return result;
		}

		public function getIndex():int {
			var siblings:IList = getSiblings();
			var result:int = siblings.getItemIndex(this);
			return result;
		}
		
		public function get relevant():Boolean {
			var result:Boolean = parent.isRelevant(definition);
			return result;
		}
		
		public function get definition():NodeDefinitionProxy {
			return _definition;
		}
		
		public function set definition(value:NodeDefinitionProxy):void {
			_definition = value;
		}

		public function get parent():EntityProxy {
			return _parent;
		}
		
		public function set parent(parent:EntityProxy):void {
			this._parent = parent;
		}
    }

}
