/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.controlpanel;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.openforis.web.server.ApplicationServer;
import org.openforis.web.server.JndiDataSourceConfiguration;

public abstract class JettyApplicationServer
implements ApplicationServer {
    private static final Logger LOG = LogManager.getLogger(JettyApplicationServer.class);
    private static final String LOCALHOST_ADDRESS = "localhost";
    protected int port;
    protected JndiDataSourceConfiguration[] jndiDsConfigurations;
    private Server server;
    protected File webappsFolder;

    public JettyApplicationServer(int port, File webappsFolder, JndiDataSourceConfiguration ... jndiDsConfigurations) {
        this.port = port;
        this.webappsFolder = webappsFolder;
        this.jndiDsConfigurations = jndiDsConfigurations;
    }

    @Override
    public void initialize() throws IOException {
        this.printClasspath();
    }

    private void printClasspath() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)cl).getURLs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            sb.append(url.getFile());
            if (i >= urls.length - 1) continue;
            sb.append(';');
        }
        LOG.info("Classpath: " + sb.toString());
    }

    @Override
    public void start() throws Exception {
        if (!this.portAvailable()) {
            String message = String.format("Port %d already in use", this.port);
            LOG.error(message);
            throw new RuntimeException(message);
        }
        this.server = new Server(this.port);
        this.server.setStopAtShutdown(true);
        this.registerWebapps();
        this.server.start();
    }

    private void registerWebapps() throws IOException, Exception, NamingException {
        LOG.info("Using webapps folder: " + this.webappsFolder.getAbsolutePath());
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.server);
        classlist.addAfter("org.eclipse.jetty.webapp.FragmentConfiguration", new String[]{"org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration"});
        File[] webappsFiles = this.webappsFolder.listFiles();
        if (webappsFiles == null || webappsFiles.length == 0) {
            throw new IllegalStateException(String.format("Empty webapps folder: %s", this.webappsFolder.getAbsolutePath()));
        }
        int webappsCount = 0;
        HandlerCollection handlerCollection = new HandlerCollection();
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        for (File webappFile : webappsFiles) {
            if (!webappFile.isFile() || !webappFile.getName().toLowerCase().endsWith("war")) continue;
            WebAppContext webapp = this.createWebapp(webappFile);
            for (JndiDataSourceConfiguration jndiDsConfiguration : this.jndiDsConfigurations) {
                this.registerDbJndiResource(webapp, jndiDsConfiguration);
            }
            contextHandlerCollection.addHandler((Handler)webapp);
            LOG.info(String.format("Webapp %s registered", webapp.getContextPath()));
            ++webappsCount;
        }
        handlerCollection.addHandler((Handler)contextHandlerCollection);
        this.server.setHandler((Handler)handlerCollection);
        LOG.info(String.format("%d webapps registered", webappsCount));
    }

    @Override
    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    @Override
    public String getUrl() {
        return String.format("%s://%s:%d/%s", "http", LOCALHOST_ADDRESS, this.port, this.getMainWebAppName());
    }

    private WebAppContext createWebapp(File warFile) {
        WebAppContext webapp = new WebAppContext();
        webapp.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration"});
        webapp.setParentLoaderPriority(true);
        String warFileName = warFile.getName();
        String context = warFileName.substring(0, warFileName.lastIndexOf("."));
        webapp.setContextPath("/" + context);
        File webappFolder = new File(warFile.getParentFile(), context);
        if (!webappFolder.exists()) {
            try {
                new ZipFile(warFile).extractAll(webappFolder.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        webapp.setExtractWAR(false);
        webapp.setWar(webappFolder.getAbsolutePath());
        return webapp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean portAvailable() {
        try (Socket ignored = new Socket(LOCALHOST_ADDRESS, this.port);){
            boolean bl = false;
            return bl;
        }
        catch (IOException ignored2) {
            return true;
        }
    }

    private void registerDbJndiResource(WebAppContext context, JndiDataSourceConfiguration jndiDataSourceConfig) throws IOException, Exception, NamingException {
        Properties properties = jndiDataSourceConfig.toProperties();
        DataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)properties);
        new Resource((Object)context.getServer(), jndiDataSourceConfig.getJndiName(), (Object)dataSource);
        LOG.info(String.format("JNDI resource %s registered for webapp %s", jndiDataSourceConfig.getJndiName(), context.getContextPath()));
    }

    protected abstract String getMainWebAppName();
}

