/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.controlpanel;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.controlpanel.CollectControlPanelController;
import org.openforis.collect.controlpanel.ErrorController;

public class CollectControlPanel
extends Application {
    private static final Logger LOG = LogManager.getLogger(CollectControlPanel.class);
    private static final String TITLE = "Open Foris Collect - Control Panel";
    private static final String CONTROL_PANEL_FXML = "collect_control_panel.fxml";
    private static final String LOGO_PATH = "of-collect-logo.png";
    private static final String ERROR_DIALOG_TITLE = "Open Foris Collect - Error";
    private CollectControlPanelController controller;

    public static void main(String[] args) {
        CollectControlPanel.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) throws Exception {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader();
            Pane pane = (Pane)fxmlLoader.load(((Object)((Object)this)).getClass().getResourceAsStream(CONTROL_PANEL_FXML));
            Scene scene = new Scene((Parent)pane);
            primaryStage.setScene(scene);
            primaryStage.setTitle(TITLE);
            primaryStage.setResizable(false);
            primaryStage.setOnCloseRequest((EventHandler)new OnCloseHandler());
            this.setLogo(primaryStage);
            this.controller = (CollectControlPanelController)fxmlLoader.getController();
            this.controller.setApp(this);
            this.controller.setStage(primaryStage);
            this.controller.closeLog();
            this.controller.startServer(() -> this.controller.openBrowser());
            primaryStage.show();
        }
        catch (Exception e) {
            CollectControlPanel.showErrorDialog(e.getCause());
        }
    }

    private void setLogo(Stage primaryStage) {
        InputStream logoIs = ((Object)((Object)this)).getClass().getResourceAsStream(LOGO_PATH);
        Image logo = new Image(logoIs);
        primaryStage.getIcons().add((Object)logo);
    }

    public void stop() throws Exception {
        super.stop();
        if (this.controller != null) {
            this.controller.stop();
        }
    }

    private static void showErrorDialog(Throwable e) {
        Stage dialog = new Stage();
        dialog.setTitle(ERROR_DIALOG_TITLE);
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.setResizable(false);
        FXMLLoader loader = new FXMLLoader();
        try {
            Parent root = (Parent)loader.load(CollectControlPanel.class.getResourceAsStream("error_dialog.fxml"));
            ErrorController errorController = (ErrorController)loader.getController();
            errorController.setMainText("Error initializing Collect");
            StringWriter errorDetailsSW = new StringWriter();
            e.printStackTrace(new PrintWriter(errorDetailsSW));
            errorController.setErrorText(errorDetailsSW.toString());
            dialog.setScene(new Scene(root, 400.0, 300.0));
            dialog.show();
        }
        catch (IOException exc) {
            LOG.error((Object)exc);
        }
    }

    private class OnCloseHandler
    implements EventHandler<WindowEvent> {
        private OnCloseHandler() {
        }

        public void handle(WindowEvent event) {
            event.consume();
            switch (CollectControlPanel.this.controller.getStatus()) {
                case INITIALIZING: 
                case STARTING: {
                    break;
                }
                default: {
                    try {
                        CollectControlPanel.this.controller.shutdown(null);
                        break;
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                }
            }
        }
    }
}

