/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.controlpanel;

import com.sun.deploy.uitoolkit.impl.fx.HostServicesFactory;
import com.sun.javafx.application.HostServicesDelegate;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.controlpanel.AboutController;
import org.openforis.collect.controlpanel.CollectControlPanel;
import org.openforis.collect.controlpanel.CollectJettyServer;
import org.openforis.collect.controlpanel.CollectProperties;
import org.openforis.collect.controlpanel.CollectPropertiesHandler;
import org.openforis.utils.Files;
import org.openforis.web.server.ApplicationServer;

public class CollectControlPanelController
implements Initializable {
    private static final Logger LOG = LogManager.getLogger(CollectControlPanelController.class);
    private static final String COLLECT_USER_HOME_LOCATION = Files.getLocation(Files.getUserHomeLocation(), "OpenForis", "Collect");
    private static final String COLLECT_DATA_FOLDER_NAME = "data";
    private static final String LOGS_LOCATION = Files.getLocation(Files.getCurrentLocation(), "logs");
    private static final String SERVER_LOG_FILE_LOCATION = Files.getLocation(LOGS_LOCATION, "collect_server.log");
    private static final String COLLECT_LOG_FILE_LOCATION = Files.getLocation(LOGS_LOCATION, "collect.log");
    private static final String SAIKU_LOG_FILE_LOCATION = Files.getLocation(LOGS_LOCATION, "saiku.log");
    private static final String SETTINGS_FILENAME = "collect.properties";
    private static final String SETTINGS_FILE_LOCATION = Files.getLocation(COLLECT_USER_HOME_LOCATION, "collect.properties");
    private static final String SETTINGS_FILE_LOCATION_DEV = Files.getLocation(Files.getCurrentLocation(), "collect.properties");
    private static final String DEFAULT_WEBAPPS_FOLDER_NAME = "webapps";
    private static final String DEFAULT_WEBAPPS_LOCATION = Files.getLocation(Files.getCurrentLocation(), "webapps");
    private static final int LOG_OPENED_WINDOW_HEIGHT = 580;
    private static final int LOG_CLOSED_WINDOW_HEIGHT = 260;
    private static final int LOG_TEXT_MAX_LENGTH = 20000;
    private static final String CATALINA_BASE = "catalina.base";
    private static final String ONLINE_MANUAL_URI = "http://www.openforis.org/tools/collect.html";
    private static final String CHANGELOG_URI = "https://github.com/openforis/collect/blob/master/CHANGELOG.md";
    @FXML
    private Pane applicationPane;
    @FXML
    private Button logBtn;
    @FXML
    private Button shutdownBtn;
    @FXML
    public TextArea serverConsole;
    @FXML
    public TextArea collectConsole;
    @FXML
    public TextArea saikuConsole;
    @FXML
    public Hyperlink urlHyperlink;
    @FXML
    public Text statusTxt;
    @FXML
    public ProgressBar progressBar;
    @FXML
    public Text errorMessageTxt;
    @FXML
    private VBox runningAtUrlBox;
    private CollectControlPanel app;
    private Stage stage;
    private ApplicationServer server;
    private ScheduledExecutorService executorService;
    private String webappsLocation;
    private Status status = Status.INITIALIZING;
    private String errorMessage;
    private boolean logOpened = false;
    private ConsoleLogFileReader serverLogFileReader;
    private ConsoleLogFileReader collectLogFileReader;
    private ConsoleLogFileReader saikuLogFileReader;

    public void initialize(URL location, ResourceBundle resources) {
        LOG.info("initializing control panel");
        try {
            CollectProperties collectProperties;
            this.executorService = Executors.newScheduledThreadPool(5);
            File collectHomeFolder = new File(COLLECT_USER_HOME_LOCATION);
            if (!collectHomeFolder.exists()) {
                this.initializeCollectHomeFolder();
                collectProperties = new CollectProperties();
                new CollectPropertiesHandler().write(collectProperties, new File(collectHomeFolder, SETTINGS_FILENAME));
            }
            collectProperties = this.loadProperties();
            this.webappsLocation = collectProperties.getWebappsLocation();
            if (this.webappsLocation == null || this.webappsLocation.isEmpty()) {
                this.webappsLocation = DEFAULT_WEBAPPS_LOCATION;
            }
            File webappsFolder = new File(this.webappsLocation);
            this.deleteBrokenTemporaryFiles();
            if (System.getProperty(CATALINA_BASE) == null) {
                System.setProperty(CATALINA_BASE, Files.getCurrentLocation());
            }
            this.server = new CollectJettyServer(collectProperties.getHttpPort(), webappsFolder, collectProperties.getCollectDataSourceConfiguration());
            this.server.initialize();
            this.initLogFileReaders();
            this.urlHyperlink.setText(this.server.getUrl());
        }
        catch (Exception e) {
            LOG.error("error initializing Collect: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initializeCollectHomeFolder() {
        File collectHomeFolder = new File(COLLECT_USER_HOME_LOCATION);
        CollectControlPanelController.createFolder(collectHomeFolder);
        CollectControlPanelController.createFolder(new File(collectHomeFolder, COLLECT_DATA_FOLDER_NAME));
    }

    private void initLogFileReaders() throws IOException {
        this.serverLogFileReader = new ConsoleLogFileReader(new File(SERVER_LOG_FILE_LOCATION), this.serverConsole);
        this.collectLogFileReader = new ConsoleLogFileReader(new File(COLLECT_LOG_FILE_LOCATION), this.collectConsole);
        this.saikuLogFileReader = new ConsoleLogFileReader(new File(SAIKU_LOG_FILE_LOCATION), this.saikuConsole);
        this.executorService.scheduleWithFixedDelay(() -> Platform.runLater(() -> {
            this.serverLogFileReader.readFile();
            this.collectLogFileReader.readFile();
            this.saikuLogFileReader.readFile();
        }), 3L, 3L, TimeUnit.SECONDS);
    }

    public void startServer(MouseEvent event) throws Exception {
        this.startServer((Runnable)null);
    }

    public void startServer(Runnable onComplete) throws Exception {
        this.executorService.schedule(() -> {
            this.changeStatus(Status.STARTING);
            try {
                this.server.start();
                this.changeStatus(Status.RUNNING);
                if (onComplete != null) {
                    onComplete.run();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }, 0L, TimeUnit.SECONDS);
    }

    private void changeStatus(Status status) {
        this.status = status;
        this.updateUI();
    }

    public void stopServer() throws Exception {
        if (this.server == null) {
            this.changeStatus(Status.ERROR);
        } else {
            this.changeStatus(Status.STOPPING);
            try {
                this.server.stop();
                this.waitUntilConditionIsVerifiedThenRun(() -> this.changeStatus(Status.IDLE), Void2 -> this.server.isRunning(), 1000);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    void stop() throws Exception {
        this.stopServer();
        this.executorService.shutdownNow();
    }

    @FXML
    void openBrowserFromLink(MouseEvent event) {
        this.openBrowser();
    }

    @FXML
    void shutdown(MouseEvent event) throws Exception {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Shutdown Collect ?", new ButtonType[]{ButtonType.YES, ButtonType.CANCEL});
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES) {
            try {
                this.stop();
                Platform.exit();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    void openBrowser() {
        HostServicesDelegate hostServices = HostServicesFactory.getInstance((Application)this.app);
        String url = this.server.getUrl();
        hostServices.showDocument(url);
    }

    @FXML
    public void toggleLog(MouseEvent event) {
        this.setLogVisible(!this.logOpened);
    }

    @FXML
    public void handleShowOnlineManual(ActionEvent event) {
        this.app.getHostServices().showDocument(ONLINE_MANUAL_URI);
    }

    @FXML
    public void handleShowChangelog(ActionEvent event) {
        this.app.getHostServices().showDocument(CHANGELOG_URI);
    }

    @FXML
    public void handleAboutAction(ActionEvent event) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("about_dialog.fxml"));
        Parent parent = (Parent)fxmlLoader.load();
        AboutController aboutController = (AboutController)fxmlLoader.getController();
        aboutController.setHostServices(this.app.getHostServices());
        Scene scene = new Scene(parent, 300.0, 200.0);
        Stage dialogStage = new Stage();
        dialogStage.setTitle("About");
        dialogStage.initModality(Modality.APPLICATION_MODAL);
        dialogStage.setScene(scene);
        dialogStage.showAndWait();
    }

    @FXML
    public void handleExitAction(ActionEvent event) {
        if (this.status == Status.RUNNING || this.status == Status.ERROR) {
            try {
                this.shutdown(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void closeLog() {
        this.setLogVisible(false);
    }

    private void setLogVisible(boolean visible) {
        this.logOpened = visible;
        this.logBtn.setText(visible ? "Hide Log" : "Show Log");
        this.updateUI();
    }

    private void updateUI() {
        int windowHeight = this.logOpened ? 580 : 260;
        Window window = this.applicationPane.getScene().getWindow();
        window.setHeight((double)windowHeight);
        boolean runningAtUrlVisible = false;
        boolean errorMessageVisible = false;
        boolean shutdownBtnVisible = false;
        boolean progressBarVisible = false;
        String detailedErrorMessage = null;
        String statusMessage = null;
        String statusMessageClassName = "info";
        switch (this.status) {
            case INITIALIZING: {
                statusMessage = "Initializing...";
                progressBarVisible = true;
                break;
            }
            case STARTING: {
                statusMessage = "Starting up...";
                progressBarVisible = true;
                break;
            }
            case RUNNING: {
                statusMessage = "Running!";
                runningAtUrlVisible = true;
                shutdownBtnVisible = true;
                break;
            }
            case STOPPING: {
                statusMessage = "Shutting down...";
                break;
            }
            case IDLE: {
                break;
            }
            case ERROR: {
                statusMessage = "Error";
                detailedErrorMessage = String.format("An error has occurred: %s\nOpen Log for more detals", this.errorMessage);
                errorMessageVisible = true;
                break;
            }
        }
        statusMessageClassName = this.status.name().toLowerCase();
        this.runningAtUrlBox.setVisible(runningAtUrlVisible);
        this.shutdownBtn.setVisible(shutdownBtnVisible);
        this.errorMessageTxt.setText(detailedErrorMessage);
        this.errorMessageTxt.setVisible(errorMessageVisible);
        this.statusTxt.setText(statusMessage);
        this.statusTxt.getStyleClass().clear();
        this.statusTxt.getStyleClass().add((Object)statusMessageClassName);
        this.progressBar.setVisible(progressBarVisible);
        this.serverConsole.setVisible(this.logOpened);
    }

    private void handleException(Exception e) {
        e.printStackTrace();
        this.errorMessage = e.getMessage();
        this.changeStatus(Status.ERROR);
    }

    private void waitUntilConditionIsVerifiedThenRun(Runnable runnable, Predicate<Void> sleepConditionVerifier, int sleepInterval) {
        while (sleepConditionVerifier.test(null)) {
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        Platform.runLater((Runnable)runnable);
    }

    private CollectProperties loadProperties() throws IOException {
        String location;
        Properties properties = new Properties();
        String[] possibleLocations = new String[]{SETTINGS_FILE_LOCATION_DEV, SETTINGS_FILE_LOCATION};
        File propertiesFile = null;
        String[] stringArray = possibleLocations;
        int n = stringArray.length;
        for (int i = 0; i < n && !(propertiesFile = new File(location = stringArray[i])).exists(); ++i) {
        }
        if (!propertiesFile.exists()) {
            throw new IllegalStateException(String.format("Cannot find %s file", SETTINGS_FILENAME));
        }
        FileInputStream is = new FileInputStream(propertiesFile);
        properties.load(is);
        return new CollectPropertiesHandler().parse(properties);
    }

    private void deleteBrokenTemporaryFiles() throws IOException {
        String[] folderContent;
        File webappsFolder = new File(this.webappsLocation);
        File collectWebappFolder = new File(webappsFolder, "collect");
        if (collectWebappFolder.exists() && collectWebappFolder.isDirectory() && ((folderContent = collectWebappFolder.list()).length == 0 || !Arrays.asList(folderContent).contains("index.html"))) {
            LOG.info("deleting empty Collect webapps folder");
            try {
                FileUtils.forceDelete((File)collectWebappFolder);
                LOG.info("Collect webapps folder deleted successfully");
            }
            catch (IOException e) {
                String message = String.format("Error deleting folder %s: %s. Please delete it manually and start Collect again", collectWebappFolder.getAbsolutePath(), e.getMessage());
                throw new IOException(message, e);
            }
        }
    }

    public void setApp(CollectControlPanel app) {
        this.app = app;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public Status getStatus() {
        return this.status;
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void createFolder(File folder) {
        if (!folder.mkdirs()) {
            throw new RuntimeException(String.format("Cannot create folder: %s", folder.getAbsolutePath()));
        }
    }

    private static class ConsoleLogFileReader {
        private File file;
        private TextArea textArea;

        public ConsoleLogFileReader(File file, TextArea textArea) {
            this.file = file;
            this.textArea = textArea;
        }

        public void readFile() {
            String oldContent;
            String content = Files.tail(this.file, 20000L);
            if (!content.equals(oldContent = this.textArea.getText())) {
                this.textArea.setText(content);
                this.textArea.setScrollTop(Double.MAX_VALUE);
            }
        }
    }

    public static enum Status {
        INITIALIZING,
        STARTING,
        RUNNING,
        STOPPING,
        ERROR,
        IDLE;

    }
}

