/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.controlpanel;

import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.openforis.collect.Collect;
import org.openforis.collect.controlpanel.CollectControlPanelController;
import org.openforis.collect.controlpanel.ControlPanel;
import org.openforis.collect.controlpanel.component.AboutDialog;
import org.openforis.collect.controlpanel.component.JHyperlinkLabel;
import org.openforis.collect.controlpanel.component.JMultilineLabel;
import org.openforis.utils.Browser;

public class CollectControlPanel
extends JFrame
implements ControlPanel {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 500;
    private static final int HEIGHT = 200;
    private static final String TITLE = "Open Foris Collect - v" + Collect.VERSION.toString();
    private static final String LOGO_PATH = "of-collect-logo.png";
    private static final Image LOGO_IMAGE = Toolkit.getDefaultToolkit().getImage(CollectControlPanel.class.getResource("of-collect-logo.png"));
    private static final String ONLINE_MANUAL_URL = "http://www.openforis.org/tools/collect.html";
    private static final String CHANGELOG_URL = "https://github.com/openforis/collect/blob/master/CHANGELOG.md";
    private static final Font ERROR_MSG_FONT = new Font("SansSerif", 0, 15);
    private static final Font STATUS_MSG_FONT = new Font("SansSerif", 1, 20);
    private static final Font SHUTDOWN_BTN_FONT = new Font("SansSerif", 1, 15);
    private CollectControlPanelController controller;
    private JHyperlinkLabel urlHyperlink;
    private JComponent runningAtUrlBox;
    private JButton shutdownBtn;
    private JMultilineLabel errorMessageTxt;
    private JLabel statusTxt;
    private JProgressBar progressBar;

    public static void main(String[] args) {
        FlatLightLaf.install();
        EventQueue.invokeLater(() -> {
            CollectControlPanel panel = new CollectControlPanel();
            panel.setVisible(true);
        });
    }

    public CollectControlPanel() {
        this.setLocationRelativeTo(null);
        this.setSize(500, 200);
        this.setResizable(false);
        this.setTitle();
        this.setIconImage(LOGO_IMAGE);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CollectControlPanel.this.controller.handleExitAction();
            }
        });
        this.createMenuBar();
        JComponent pane = (JComponent)this.getContentPane();
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box center = Box.createHorizontalBox();
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(new ImageIcon(LOGO_IMAGE));
        center.add(iconLabel);
        Box centerInnerBox = Box.createVerticalBox();
        centerInnerBox.setAlignmentX(0.5f);
        this.statusTxt = new JLabel();
        this.statusTxt.setFont(STATUS_MSG_FONT);
        centerInnerBox.add(this.statusTxt);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        centerInnerBox.add(this.progressBar);
        this.runningAtUrlBox = Box.createHorizontalBox();
        this.runningAtUrlBox.add(new JLabel("Running at: "));
        this.urlHyperlink = new JHyperlinkLabel();
        this.runningAtUrlBox.add(this.urlHyperlink);
        this.addMargin(this.runningAtUrlBox);
        centerInnerBox.add(this.runningAtUrlBox);
        this.errorMessageTxt = new JMultilineLabel();
        this.errorMessageTxt.setFont(ERROR_MSG_FONT);
        this.errorMessageTxt.setForeground(Color.RED);
        this.errorMessageTxt.setMaximumSize(new Dimension(400, 100));
        this.addMargin(this.errorMessageTxt);
        centerInnerBox.add(this.errorMessageTxt);
        center.add(centerInnerBox);
        pane.add((Component)center, "Center");
        Box south = Box.createVerticalBox();
        this.shutdownBtn = new JButton("Shutdown");
        this.shutdownBtn.setFont(SHUTDOWN_BTN_FONT);
        this.shutdownBtn.setAlignmentX(0.5f);
        this.shutdownBtn.addActionListener(e -> this.controller.handleExitAction());
        this.addMargin(this.shutdownBtn);
        south.add(this.shutdownBtn);
        pane.add((Component)south, "South");
        this.controller = new CollectControlPanelController(this);
        this.controller.init();
        this.controller.startServer(() -> this.controller.openCollectInBrowser());
    }

    private void addMargin(JComponent comp) {
        Border border = comp.getBorder();
        EmptyBorder margin = new EmptyBorder(10, 10, 10, 10);
        comp.setBorder(new CompoundBorder(border, margin));
    }

    private void setTitle() {
        this.setTitle(TITLE);
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, TITLE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem item = new JMenuItem("Exit");
        item.setMnemonic(69);
        item.addActionListener(event -> this.controller.handleExitAction());
        fileMenu.add(item);
        menuBar.add(fileMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem item2 = new JMenuItem("Online manual");
        item2.setMnemonic(77);
        item2.addActionListener(event -> Browser.openPage(ONLINE_MANUAL_URL));
        helpMenu.add(item2);
        item2 = new JMenuItem("Changelog");
        item2.setMnemonic(67);
        item2.addActionListener(event -> Browser.openPage(CHANGELOG_URL));
        helpMenu.add(item2);
        item2 = new JMenuItem("About");
        item2.setMnemonic(65);
        item2.addActionListener(event -> new AboutDialog(this));
        helpMenu.add(item2);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    @Override
    public JHyperlinkLabel getUrlHyperlink() {
        return this.urlHyperlink;
    }

    @Override
    public JComponent getRunningAtUrlBox() {
        return this.runningAtUrlBox;
    }

    @Override
    public JButton getShutdownBtn() {
        return this.shutdownBtn;
    }

    @Override
    public JMultilineLabel getErrorMessageTxt() {
        return this.errorMessageTxt;
    }

    @Override
    public JLabel getStatusTxt() {
        return this.statusTxt;
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.progressBar;
    }
}

