/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.controlpanel;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.controlpanel.CollectProperties;
import org.openforis.collect.controlpanel.CollectPropertiesHandler;
import org.openforis.collect.controlpanel.ControlPanel;
import org.openforis.collect.controlpanel.server.CollectJettyServer;
import org.openforis.utils.Browser;
import org.openforis.utils.Files;
import org.openforis.web.server.ApplicationServer;

public class CollectControlPanelController {
    private static final Logger LOG = LogManager.getLogger(CollectControlPanelController.class);
    private static final String COLLECT_USER_HOME_LOCATION = Files.getLocation(Files.getUserHomeLocation(), "OpenForis", "Collect");
    private static final String COLLECT_DATA_FOLDER_NAME = "data";
    private static final String SETTINGS_FILENAME = "collect.properties";
    private static final String SETTINGS_FILE_LOCATION = Files.getLocation(COLLECT_USER_HOME_LOCATION, "collect.properties");
    private static final String SETTINGS_FILE_LOCATION_DEV = Files.getLocation(Files.getCurrentLocation(), "collect.properties");
    private static final String DEFAULT_WEBAPPS_FOLDER_NAME = "webapps";
    private static final String DEFAULT_WEBAPPS_LOCATION = Files.getLocation(Files.getCurrentLocation(), "webapps");
    private static final String CATALINA_BASE = "catalina.base";
    private static final String ERROR_MSG_FORMAT = "An error has occurred: %s\nOpen Log for more details";
    private static final String ERROR_SHUTTING_DOWN_MSG_FORMAT = "Error shutting down Collect: %s";
    private ControlPanel controlPanel;
    private ApplicationServer server;
    private ScheduledExecutorService executorService;
    private String webappsLocation;
    private Status status = Status.INITIALIZING;
    private String errorMessage;

    public CollectControlPanelController(ControlPanel controlPanel) {
        this.controlPanel = controlPanel;
    }

    public void init() {
        LOG.info("initializing control panel");
        try {
            CollectProperties collectProperties;
            this.executorService = Executors.newScheduledThreadPool(5);
            File collectHomeFolder = new File(COLLECT_USER_HOME_LOCATION);
            if (!collectHomeFolder.exists()) {
                this.initializeCollectHomeFolder();
                collectProperties = new CollectProperties();
                new CollectPropertiesHandler().write(collectProperties, new File(collectHomeFolder, SETTINGS_FILENAME));
            }
            collectProperties = this.loadProperties();
            this.webappsLocation = collectProperties.getWebappsLocation();
            if (this.webappsLocation == null || this.webappsLocation.isEmpty()) {
                this.webappsLocation = DEFAULT_WEBAPPS_LOCATION;
            }
            File webappsFolder = new File(this.webappsLocation);
            this.deleteBrokenTemporaryFiles();
            if (System.getProperty(CATALINA_BASE) == null) {
                System.setProperty(CATALINA_BASE, Files.getCurrentLocation());
            }
            this.server = new CollectJettyServer(collectProperties.getHttpPort(), webappsFolder, collectProperties.getCollectDataSourceConfiguration());
            this.server.initialize();
            this.controlPanel.getUrlHyperlink().setUrl(this.server.getUrl());
        }
        catch (Exception e) {
            LOG.error("error initializing Collect: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initializeCollectHomeFolder() {
        File collectHomeFolder = new File(COLLECT_USER_HOME_LOCATION);
        CollectControlPanelController.createFolder(collectHomeFolder);
        CollectControlPanelController.createFolder(new File(collectHomeFolder, COLLECT_DATA_FOLDER_NAME));
    }

    public void startServer() {
        this.startServer(null);
    }

    public void startServer(Runnable onComplete) {
        this.executorService.schedule(() -> {
            this.changeStatus(Status.STARTING);
            try {
                this.server.start();
                this.changeStatus(Status.RUNNING);
                if (onComplete != null) {
                    onComplete.run();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }, 0L, TimeUnit.SECONDS);
    }

    private void changeStatus(Status status) {
        this.status = status;
        this.updateUI();
    }

    public void stopServer() throws Exception {
        if (this.server == null) {
            this.changeStatus(Status.ERROR);
        } else {
            this.changeStatus(Status.STOPPING);
            try {
                this.server.stop();
                this.waitUntil(() -> this.changeStatus(Status.IDLE), Void2 -> this.server.isRunning(), 1000);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void stop() throws Exception {
        this.stopServer();
        this.executorService.shutdownNow();
    }

    public void shutdown() {
        try {
            this.stop();
            this.exit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.format(ERROR_SHUTTING_DOWN_MSG_FORMAT, e.getMessage()));
            LOG.error((Object)e);
        }
    }

    private void exit() {
        System.exit(0);
    }

    public void openCollectInBrowser() {
        Browser.openPage(this.server.getUrl());
    }

    public void handleExitAction() {
        switch (this.status) {
            case INITIALIZING: 
            case STARTING: {
                break;
            }
            default: {
                int confirmResult = JOptionPane.showConfirmDialog(null, "Shutdown Collect?", "Confirm", 0);
                if (confirmResult != 0) break;
                if (this.status == Status.RUNNING || this.status == Status.ERROR) {
                    this.shutdown();
                    break;
                }
                this.exit();
            }
        }
    }

    private void updateUI() {
        boolean runningAtUrlVisible = false;
        boolean errorMessageVisible = false;
        boolean shutdownBtnVisible = false;
        boolean progressBarVisible = false;
        String detailedErrorMessage = null;
        String statusMessage = null;
        Color statusMessageColor = Color.ORANGE;
        switch (this.status) {
            case INITIALIZING: {
                statusMessage = "Initializing...";
                progressBarVisible = true;
                break;
            }
            case STARTING: {
                statusMessage = "Starting up...";
                progressBarVisible = true;
                break;
            }
            case RUNNING: {
                statusMessage = "Running!";
                runningAtUrlVisible = true;
                shutdownBtnVisible = true;
                statusMessageColor = Color.BLUE;
                break;
            }
            case STOPPING: {
                statusMessage = "Shutting down...";
                break;
            }
            case IDLE: {
                break;
            }
            case ERROR: {
                statusMessage = "Error";
                detailedErrorMessage = String.format(ERROR_MSG_FORMAT, this.errorMessage);
                errorMessageVisible = true;
                statusMessageColor = Color.RED;
                break;
            }
        }
        this.controlPanel.getRunningAtUrlBox().setVisible(runningAtUrlVisible);
        this.controlPanel.getShutdownBtn().setVisible(shutdownBtnVisible);
        this.controlPanel.getErrorMessageTxt().setText(detailedErrorMessage);
        this.controlPanel.getErrorMessageTxt().setVisible(errorMessageVisible);
        this.controlPanel.getStatusTxt().setText(statusMessage);
        this.controlPanel.getStatusTxt().setForeground(statusMessageColor);
        this.controlPanel.getProgressBar().setVisible(progressBarVisible);
    }

    private void handleException(Exception e) {
        e.printStackTrace();
        this.errorMessage = e.getMessage();
        this.changeStatus(Status.ERROR);
    }

    private void waitUntil(Runnable runnable, Predicate<Void> sleepConditionVerifier, int sleepInterval) {
        while (sleepConditionVerifier.test(null)) {
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        SwingUtilities.invokeLater(runnable);
    }

    private CollectProperties loadProperties() throws IOException {
        String location;
        Properties properties = new Properties();
        String[] possibleLocations = new String[]{SETTINGS_FILE_LOCATION_DEV, SETTINGS_FILE_LOCATION};
        File propertiesFile = null;
        String[] stringArray = possibleLocations;
        int n = stringArray.length;
        for (int i = 0; i < n && !(propertiesFile = new File(location = stringArray[i])).exists(); ++i) {
        }
        if (!propertiesFile.exists()) {
            throw new IllegalStateException(String.format("Cannot find %s file", SETTINGS_FILENAME));
        }
        FileInputStream is = new FileInputStream(propertiesFile);
        properties.load(is);
        return new CollectPropertiesHandler().parse(properties);
    }

    private void deleteBrokenTemporaryFiles() throws IOException {
        String[] folderContent;
        File webappsFolder = new File(this.webappsLocation);
        File collectWebappFolder = new File(webappsFolder, "collect");
        if (collectWebappFolder.exists() && collectWebappFolder.isDirectory() && ((folderContent = collectWebappFolder.list()).length == 0 || !Arrays.asList(folderContent).contains("index.html"))) {
            LOG.info("deleting empty Collect webapps folder");
            try {
                FileUtils.forceDelete((File)collectWebappFolder);
                LOG.info("Collect webapps folder deleted successfully");
            }
            catch (IOException e) {
                String message = String.format("Error deleting folder %s: %s. Please delete it manually and start Collect again", collectWebappFolder.getAbsolutePath(), e.getMessage());
                throw new IOException(message, e);
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setControlPanel(ControlPanel controlPanel) {
        this.controlPanel = controlPanel;
    }

    private static void createFolder(File folder) {
        if (!folder.mkdirs()) {
            throw new RuntimeException(String.format("Cannot create folder: %s", folder.getAbsolutePath()));
        }
    }

    public static enum Status {
        INITIALIZING,
        STARTING,
        RUNNING,
        STOPPING,
        ERROR,
        IDLE;

    }
}

