/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.utils;

import java.util.Properties;
import org.openforis.utils.Strings;

public class PropertiesExtractor {
    private Properties properties;
    private String propertiesFileName;

    public PropertiesExtractor(Properties properties, String propertiesFileName) {
        this.properties = properties;
        this.propertiesFileName = propertiesFileName;
    }

    public String getSystemVariableReplacedProperty(String propName) {
        return this.getSystemVariableReplacedProperty(propName, null);
    }

    public String getSystemVariableReplacedProperty(String propName, String defaultValue) {
        String[] systemProps;
        String originalValue;
        String finalValue = originalValue = this.getProperty(propName, defaultValue);
        for (String sysPropName : systemProps = new String[]{"user.home"}) {
            String propVal = System.getProperty(sysPropName);
            finalValue = finalValue.replace("${" + sysPropName + "}", propVal);
        }
        return finalValue;
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String value = this.getProperty(key, "");
        if (Strings.isBlank(value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Property '%s' of '%s' file must be an integer", key, this.propertiesFileName));
        }
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.getProperty(key);
        if (Strings.isBlank(value)) {
            if (defaultValue == null) {
                throw new RuntimeException(String.format("Missing property '%s' in '%s' file", key, this.propertiesFileName));
            }
            return defaultValue;
        }
        return value;
    }
}

