/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.utils;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import org.apache.commons.io.IOUtils;

public abstract class Files {
    public static String getCurrentLocation() {
        return new File(".").getAbsoluteFile().getParentFile().getAbsolutePath();
    }

    public static String getUserHomeLocation() {
        return System.getProperty("user.home");
    }

    public static String getLocation(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i >= parts.length - 1) continue;
            sb.append(File.separatorChar);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tail(File file, long maxSize) {
        String string;
        StringBuilder sb = new StringBuilder(new Long(maxSize).intValue());
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            long position = 0L;
            long size = raf.length();
            if (size > maxSize) {
                position = size - maxSize;
                raf.seek(position);
            }
            String line = raf.readLine();
            while (line != null && position < size) {
                position += (long)(line.length() + 1);
                sb.append(line);
                sb.append('\n');
                line = raf.readLine();
            }
            string = sb.toString();
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = "";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(raf);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)raf);
            return string2;
        }
        IOUtils.closeQuietly((Closeable)raf);
        return string;
    }
}

