/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.data.internal;

import java.util.List;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.relational.data.DataExtractor;
import org.openforis.collect.relational.data.Row;
import org.openforis.collect.relational.model.CodeLabelColumn;
import org.openforis.collect.relational.model.CodeListCodeColumn;
import org.openforis.collect.relational.model.CodeListDescriptionColumn;
import org.openforis.collect.relational.model.CodeParentKeyColumn;
import org.openforis.collect.relational.model.CodePrimaryKeyColumn;
import org.openforis.collect.relational.model.CodeTable;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.Table;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListService;
import org.openforis.idm.metamodel.PersistedCodeListItem;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.SurveyContext;

public class CodeTableDataExtractor
extends DataExtractor {
    public static final int DEFAULT_CODE_ROW_ID = -1;
    private CodeTable table;
    private List<CodeListItem> items;
    private int itemIndex;
    private int count;
    private int total;

    public CodeTableDataExtractor(CodeTable codeTable) {
        this.table = codeTable;
        CodeListService codeListService = this.getCodeListService();
        this.items = codeListService.loadItems(codeTable.getCodeList(), this.getEffectiveLevelIndex());
        this.itemIndex = 0;
        this.count = 0;
        this.total = this.items.size() + (this.isDefaultCodeRowToBeCreated() ? 1 : 0);
    }

    @Override
    public Row next() {
        Row row;
        if (this.isDefaultCodeRowToBeCreated()) {
            row = this.createDefaultCodeRow();
        } else {
            CodeListItem item = this.items.get(this.itemIndex);
            row = this.extractRow(item);
            ++this.itemIndex;
        }
        ++this.count;
        return row;
    }

    @Override
    public boolean hasNext() {
        return this.count < this.total;
    }

    @Override
    public Table<?> getTable() {
        return this.table;
    }

    private boolean isDefaultCodeRowToBeCreated() {
        return this.count == 0 && this.table.getDefaultCode() != null && !this.containsDefaultCodeItem();
    }

    private int getEffectiveLevelIndex() {
        Integer levelIdx = this.table.getLevelIdx();
        int level = levelIdx == null ? 1 : levelIdx + 1;
        return level;
    }

    public int getTotal() {
        return this.total;
    }

    private CodeListService getCodeListService() {
        CollectSurvey survey = (CollectSurvey)this.table.getCodeList().getSurvey();
        SurveyContext context = survey.getContext();
        CodeListService codeListService = context.getCodeListService();
        return codeListService;
    }

    private boolean containsDefaultCodeItem() {
        for (CodeListItem item : this.items) {
            if (!item.getCode().equals(this.table.getDefaultCode())) continue;
            return true;
        }
        return false;
    }

    public Row extractRow(CodeListItem source) {
        Row row = new Row(this.table);
        List columns = this.table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column col = (Column)columns.get(i);
            Object val = this.extractValue(source, col);
            row.setValue(i, val);
        }
        return row;
    }

    private Object extractValue(CodeListItem item, Column<?> col) {
        if (col instanceof CodeLabelColumn) {
            String langCode = ((CodeLabelColumn)col).getLanguageCode();
            return item.getLabel(langCode);
        }
        if (col instanceof CodeListCodeColumn) {
            return item.getCode();
        }
        if (col instanceof CodeListDescriptionColumn) {
            String langCode = ((CodeListDescriptionColumn)col).getLanguageCode();
            return item.getDescription(langCode);
        }
        if (col instanceof CodeParentKeyColumn) {
            CodeList list = item.getCodeList();
            if (list.isExternal()) {
                throw new UnsupportedOperationException(String.format("External code list not supported (survey: %s, code list: %s)", list.getSurvey().getName(), list.getName()));
            }
            CodeListItem parent = item instanceof PersistedCodeListItem ? this.getCodeListService(list).loadParentItem((CodeListItem)((PersistedCodeListItem)item)) : item.getParentItem();
            return parent.getId();
        }
        if (col instanceof CodePrimaryKeyColumn) {
            return item.getId();
        }
        throw new UnsupportedOperationException("Code List Table Column type not supported: " + col.getClass().getName());
    }

    protected Row createDefaultCodeRow() {
        Row row = new Row(this.table);
        List columns = this.table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column col = (Column)columns.get(i);
            Object val = col instanceof CodePrimaryKeyColumn ? Integer.valueOf(-1) : (col instanceof CodeListCodeColumn ? this.table.getDefaultCode() : (col instanceof CodeLabelColumn ? this.table.getDefaultCodeLabel(((CodeLabelColumn)col).getLanguageCode()) : null));
            row.setValue(i, val);
        }
        return row;
    }

    private CodeListService getCodeListService(CodeList list) {
        Survey survey = list.getSurvey();
        SurveyContext context = survey.getContext();
        CodeListService codeListService = context.getCodeListService();
        return codeListService;
    }
}

