/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.print;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.relational.data.DataExtractorFactory;
import org.openforis.collect.relational.data.internal.CodeTableDataExtractor;
import org.openforis.collect.relational.model.CodeTable;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.RelationalSchemaGenerator;
import org.openforis.collect.relational.print.RDBPrintTask;
import org.openforis.collect.relational.print.RDBSchemaPrintTask;
import org.openforis.commons.collection.Visitor;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.Survey;

public class RDBPrintJob
extends Job {
    private CollectSurvey survey;
    private String targetSchemaName;
    private boolean includeData;
    private RecordManager recordManager;
    private RecordFilter recordFilter;
    private RdbDialect dialect;
    private String dateTimeFormat;
    private boolean includeForeignKeysInCreateTable = true;
    private File outputFile;
    private transient RelationalSchema schema;
    private transient Writer writer;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.outputFile = File.createTempFile("rdb", ".sql");
        this.writer = new FileWriter(this.outputFile);
    }

    protected void buildTasks() throws Throwable {
        this.addTask((Worker)new SchemaGenerationTask());
        this.addTask((Worker)new RDBSchemaPrintTask());
        this.addTask((Worker)new ReferenceDataPrintTask());
        if (this.includeData) {
            this.addTask((Worker)new RecordDataPrintTask());
        }
    }

    protected void initializeTask(Worker task) {
        if (task instanceof SchemaGenerationTask) {
            ((SchemaGenerationTask)task).setSurvey(this.survey);
            ((SchemaGenerationTask)task).setTargetSchemaName(this.targetSchemaName);
        } else if (task instanceof RDBPrintTask) {
            RDBPrintTask t = (RDBPrintTask)task;
            t.setWriter(this.writer);
            t.setSchema(this.schema);
            t.setDialect(this.dialect);
            t.setDateTimeFormat(this.dateTimeFormat);
            if (task instanceof RDBSchemaPrintTask) {
                ((RDBSchemaPrintTask)task).setIncludeForeignKeysInCreateTable(this.includeForeignKeysInCreateTable);
            } else if (task instanceof RecordDataPrintTask) {
                RecordDataPrintTask dataPrintTask = (RecordDataPrintTask)task;
                dataPrintTask.setRecordManager(this.recordManager);
                dataPrintTask.setRecordFilter(this.recordFilter);
            }
        }
        super.initializeTask(task);
    }

    protected void onTaskCompleted(Worker task) {
        if (task instanceof SchemaGenerationTask) {
            this.schema = ((SchemaGenerationTask)task).getSchema();
        }
        super.onTaskCompleted(task);
    }

    protected void onEnd() {
        super.onEnd();
        IOUtils.closeQuietly((Writer)this.writer);
    }

    public CollectSurvey getSurvey() {
        return this.survey;
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setIncludeData(boolean includeData) {
        this.includeData = includeData;
    }

    public void setRecordManager(RecordManager recordManager) {
        this.recordManager = recordManager;
    }

    public void setRecordFilter(RecordFilter recordFilter) {
        this.recordFilter = recordFilter;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public void setDialect(RdbDialect dialect) {
        this.dialect = dialect;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setIncludeForeignKeysInCreateTable(boolean includeForeignKeysInCreateTable) {
        this.includeForeignKeysInCreateTable = includeForeignKeysInCreateTable;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public static class RecordDataPrintTask
    extends RDBPrintTask {
        private RecordManager recordManager;
        private RecordFilter recordFilter;

        protected long countTotalItems() {
            return this.recordManager.countRecords(this.recordFilter);
        }

        protected void execute() throws Throwable {
            this.recordManager.visitSummaries(this.recordFilter, null, (Visitor)new Visitor<CollectRecord>(){

                public void visit(CollectRecord summary) {
                    CollectRecord record = RecordDataPrintTask.this.recordManager.load((CollectSurvey)summary.getSurvey(), summary.getId().intValue(), summary.getStep());
                    if (record != null) {
                        for (DataTable table : RecordDataPrintTask.this.schema.getDataTables()) {
                            if (!RecordDataPrintTask.this.isRunning()) {
                                return;
                            }
                            try {
                                RecordDataPrintTask.this.writeBatchInsert(table, DataExtractorFactory.getRecordDataExtractor(table, record));
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    RecordDataPrintTask.this.incrementProcessedItems();
                }
            });
        }

        public void setRecordManager(RecordManager recordManager) {
            this.recordManager = recordManager;
        }

        public void setRecordFilter(RecordFilter recordFilter) {
            this.recordFilter = recordFilter;
        }
    }

    public static class ReferenceDataPrintTask
    extends RDBPrintTask {
        protected long countTotalItems() {
            long total = 0L;
            for (CodeTable codeTable : this.schema.getCodeListTables()) {
                CodeTableDataExtractor extractor = DataExtractorFactory.getExtractor(codeTable);
                total += (long)extractor.getTotal();
            }
            return total;
        }

        protected void execute() throws Throwable {
            for (CodeTable codeTable : this.schema.getCodeListTables()) {
                if (!this.isRunning()) {
                    return;
                }
                CodeTableDataExtractor extractor = DataExtractorFactory.getExtractor(codeTable);
                this.setProcessedItems(this.getProcessedItems() + (long)extractor.getTotal());
            }
        }
    }

    private static class SchemaGenerationTask
    extends Task {
        private CollectSurvey survey;
        private String targetSchemaName;
        private RelationalSchema schema;

        private SchemaGenerationTask() {
        }

        protected void execute() throws Throwable {
            RelationalSchema schema;
            RelationalSchemaGenerator schemaGenerator = new RelationalSchemaGenerator();
            this.schema = schema = schemaGenerator.generateSchema((Survey)this.survey, this.targetSchemaName);
        }

        public void setSurvey(CollectSurvey survey) {
            this.survey = survey;
        }

        public void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        public RelationalSchema getSchema() {
            return this.schema;
        }
    }

    public static enum RdbDialect {
        STANDARD,
        SQLITE;

    }
}

