/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.relational.model.RelationalSchemaConfig;
import org.openforis.collect.relational.util.Constants;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListLevel;

public class CodeListTables {
    public static String getTableName(CodeAttributeDefinition attrDef) {
        return CodeListTables.getTableName(RelationalSchemaConfig.createDefault(), attrDef);
    }

    public static String getTableName(RelationalSchemaConfig config, CodeAttributeDefinition attrDef) {
        return CodeListTables.getTableName(config, attrDef.getList(), attrDef.getListLevelIndex());
    }

    public static String getTableName(CodeList codeList, Integer levelIdx) {
        return CodeListTables.getTableName(RelationalSchemaConfig.createDefault(), codeList, levelIdx);
    }

    public static String getTableName(RelationalSchemaConfig config, CodeList codeList, Integer levelIdx) {
        String baseTableName = CodeListTables.getBaseTableName(codeList, levelIdx);
        return baseTableName + config.getCodeListTableSuffix();
    }

    public static String getIdColumnName(String tableName) {
        return CodeListTables.getIdColumnName(RelationalSchemaConfig.createDefault(), tableName);
    }

    public static String getIdColumnName(RelationalSchemaConfig config, String tableName) {
        String result = String.format("%s%s", tableName, config.getIdColumnSuffix());
        return result;
    }

    public static String getCodeColumnName(CodeList codeList, Integer hierarchyIdx) {
        return CodeListTables.getBaseTableName(codeList, hierarchyIdx);
    }

    public static String getCodeColumnName(String tableName) {
        return CodeListTables.getCodeColumnName(RelationalSchemaConfig.createDefault(), tableName);
    }

    public static String getCodeColumnName(RelationalSchemaConfig config, String tableName) {
        return StringUtils.removeEnd((String)tableName, (String)config.getCodeListTableSuffix());
    }

    public static String getLabelColumnName(CodeList codeList, Integer levelIdx) {
        return CodeListTables.getLabelColumnName(RelationalSchemaConfig.createDefault(), codeList, levelIdx);
    }

    public static String getLabelColumnName(RelationalSchemaConfig config, CodeList codeList, Integer levelIdx) {
        return CodeListTables.getLabelColumnName(config, codeList, levelIdx, null);
    }

    public static String getLabelColumnName(String tableName) {
        return CodeListTables.getLabelColumnName(RelationalSchemaConfig.createDefault(), tableName);
    }

    public static String getLabelColumnName(RelationalSchemaConfig config, String tableName) {
        String baseName = CodeListTables.extractBaseTableName(config, tableName);
        return CodeListTables.getLabelColumnName(config, baseName, null);
    }

    public static String getLabelColumnName(CodeList codeList, Integer levelIdx, String langCode) {
        return CodeListTables.getLabelColumnName(RelationalSchemaConfig.createDefault(), codeList, levelIdx, langCode);
    }

    public static String getLabelColumnName(RelationalSchemaConfig config, CodeList codeList, Integer levelIdx, String langCode) {
        String baseTableName = CodeListTables.getBaseTableName(codeList, levelIdx);
        return CodeListTables.getLabelColumnName(config, baseTableName, langCode);
    }

    private static String getLabelColumnName(RelationalSchemaConfig config, String baseTableName, String langCode) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(baseTableName);
        sb.append(config.getLabelColumnSuffix());
        if (StringUtils.isNotBlank((CharSequence)langCode)) {
            sb.append("_");
            sb.append(langCode);
        }
        return sb.toString();
    }

    public static String getDescriptionColumnName(String tableName) {
        return CodeListTables.getDescriptionColumnName(RelationalSchemaConfig.createDefault(), tableName);
    }

    public static String getDescriptionColumnName(RelationalSchemaConfig config, String tableName) {
        String baseName = CodeListTables.extractBaseTableName(config, tableName);
        return CodeListTables.getDescriptionColumnName(config, baseName, null);
    }

    public static String getDescriptionColumnName(CodeList codeList, Integer levelIdx) {
        return CodeListTables.getDescriptionColumnName(RelationalSchemaConfig.createDefault(), codeList, levelIdx);
    }

    public static String getDescriptionColumnName(RelationalSchemaConfig config, CodeList codeList, Integer levelIdx) {
        return CodeListTables.getDescriptionColumnName(config, codeList, levelIdx, null);
    }

    public static String getDescriptionColumnName(CodeList codeList, Integer levelIdx, String langCode) {
        return CodeListTables.getDescriptionColumnName(RelationalSchemaConfig.createDefault(), codeList, levelIdx, langCode);
    }

    public static String getDescriptionColumnName(RelationalSchemaConfig config, CodeList codeList, Integer levelIdx, String langCode) {
        String baseTableName = CodeListTables.getBaseTableName(codeList, levelIdx);
        return CodeListTables.getDescriptionColumnName(config, baseTableName, langCode);
    }

    protected static String getDescriptionColumnName(RelationalSchemaConfig config, String baseTableName, String langCode) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(baseTableName);
        sb.append(config.getDescriptionColumnSuffix());
        if (StringUtils.isNotBlank((CharSequence)langCode)) {
            sb.append("_");
            sb.append(langCode);
        }
        return sb.toString();
    }

    private static String getBaseTableName(CodeList codeList, Integer levelIdx) {
        StringBuilder sb = new StringBuilder();
        String tableNameAnnotation = codeList.getAnnotation(Constants.TABLE_NAME_QNAME);
        if (tableNameAnnotation == null) {
            sb.append(codeList.getName());
        } else {
            sb.append(tableNameAnnotation);
        }
        if (codeList.isHierarchical() && levelIdx != null) {
            List hierarchy = codeList.getHierarchy();
            CodeListLevel currentLevel = (CodeListLevel)hierarchy.get(levelIdx);
            sb.append("_");
            sb.append(currentLevel.getName());
        }
        return sb.toString();
    }

    private static String extractBaseTableName(RelationalSchemaConfig config, String tableName) {
        String baseName = StringUtils.removeEnd((String)tableName, (String)config.getCodeListTableSuffix());
        return baseName;
    }
}

